/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.utils.CollectionUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.jetbrains.annotations.ApiStatus;

public interface EntryRegistry {
    public static EntryRegistry getInstance() {
        return RoughlyEnoughItemsCore.getEntryRegistry();
    }

    public List<EntryStack> getStacksList();

    public List<EntryStack> getPreFilteredList();

    public List<class_1799> appendStacksForItem(class_1792 var1);

    public class_1799[] getAllStacksFromItem(class_1792 var1);

    default public void registerEntry(EntryStack stack) {
        this.registerEntryAfter(null, stack);
    }

    default public void registerEntryAfter(EntryStack afterEntry, EntryStack stack) {
        this.registerEntryAfter(afterEntry, stack, true);
    }

    @Deprecated
    @ApiStatus.Internal
    public void registerEntryAfter(EntryStack var1, EntryStack var2, boolean var3);

    public void queueRegisterEntryAfter(EntryStack var1, Collection<? extends EntryStack> var2);

    default public void registerEntriesAfter(EntryStack afterStack, EntryStack ... stacks) {
        this.registerEntriesAfter(afterStack, Arrays.asList(stacks));
    }

    public void registerEntriesAfter(EntryStack var1, Collection<? extends EntryStack> var2);

    default public void registerEntries(EntryStack ... stacks) {
        this.registerEntriesAfter(null, stacks);
    }

    default public boolean alreadyContain(EntryStack stack) {
        return CollectionUtils.anyMatchEqualsAll(this.getStacksList(), stack);
    }
}

