/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.gui.widget.ClickableActionedLabelWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.WidgetWithBounds;
import me.shedaniel.rei.impl.ScreenHelper;
import net.minecraft.class_364;
import org.jetbrains.annotations.ApiStatus;

public class LabelWidget
extends WidgetWithBounds {
    private Point pos;
    private String text;
    private int defaultColor;
    private boolean hasShadows = true;
    private boolean centered = true;
    private Supplier<String> tooltipSupplier;

    @ApiStatus.Internal
    public LabelWidget(int x, int y, String text) {
        this(new Point(x, y), text);
    }

    @ApiStatus.Internal
    public LabelWidget(Point point, String text) {
        this.pos = point;
        this.text = text;
        this.defaultColor = ScreenHelper.isDarkModeEnabled() ? -4473925 : -1;
    }

    public static LabelWidget create(Point point, String text) {
        return new LabelWidget(point, text);
    }

    public static ClickableLabelWidget createClickable(Point point, String text, Consumer<ClickableLabelWidget> onClicked) {
        return new ClickableActionedLabelWidget(point, text, onClicked);
    }

    public LabelWidget tooltip(Supplier<String> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public LabelWidget centered() {
        this.setCentered(true);
        return this;
    }

    public LabelWidget leftAligned() {
        this.setCentered(false);
        return this;
    }

    public boolean isHasShadows() {
        return this.hasShadows;
    }

    public void setHasShadows(boolean hasShadows) {
        this.hasShadows = hasShadows;
    }

    public LabelWidget noShadow() {
        this.setHasShadows(false);
        return this;
    }

    public int getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(int defaultColor) {
        this.defaultColor = defaultColor;
    }

    public Point getPosition() {
        return this.pos;
    }

    public LabelWidget setPosition(Point position) {
        this.pos = position;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public LabelWidget setText(String text) {
        this.text = text;
        return this;
    }

    public LabelWidget color(int defaultColor) {
        this.defaultColor = defaultColor;
        return this;
    }

    public Optional<String> getTooltips() {
        return Optional.ofNullable(this.tooltipSupplier).map(Supplier::get);
    }

    @Override
    public Rectangle getBounds() {
        int width = this.font.method_1727(this.text);
        Point pos = this.getPosition();
        if (this.isCentered()) {
            return new Rectangle(pos.x - width / 2 - 1, pos.y - 5, width + 2, 14);
        }
        return new Rectangle(pos.x - 1, pos.y - 5, width + 2, 14);
    }

    public List<? extends class_364> children() {
        return Collections.emptyList();
    }

    public void render(int mouseX, int mouseY, float delta) {
        int width = this.font.method_1727(this.text);
        Point pos = this.getPosition();
        if (this.isCentered()) {
            if (this.hasShadows) {
                this.font.method_1720(this.text, (float)pos.x - (float)width / 2.0f, (float)pos.y, this.defaultColor);
            } else {
                this.font.method_1729(this.text, (float)pos.x - (float)width / 2.0f, (float)pos.y, this.defaultColor);
            }
        } else if (this.hasShadows) {
            this.font.method_1720(this.text, (float)pos.x, (float)pos.y, this.defaultColor);
        } else {
            this.font.method_1729(this.text, (float)pos.x, (float)pos.y, this.defaultColor);
        }
    }

    protected void drawTooltips(int mouseX, int mouseY) {
        if (this.getTooltips().isPresent() && this.containsMouse(mouseX, mouseY)) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
        }
    }
}

