/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.math.api.Point;
import me.shedaniel.math.impl.PointHelper;
import org.jetbrains.annotations.ApiStatus;

public class QueuedTooltip {
    private Point location;
    private List<String> text;
    private Consumer<QueuedTooltip> consumer = null;

    private QueuedTooltip(Point location, List<String> text) {
        this.location = location;
        this.text = Lists.newArrayList(text);
    }

    public static QueuedTooltip create(Point location, List<String> text) {
        return new QueuedTooltip(location, text);
    }

    public static QueuedTooltip create(Point location, String ... text) {
        return QueuedTooltip.create(location, Lists.newArrayList((Object[])text));
    }

    public static QueuedTooltip create(List<String> text) {
        return QueuedTooltip.create(PointHelper.fromMouse(), text);
    }

    public static QueuedTooltip create(String ... text) {
        return QueuedTooltip.create(PointHelper.fromMouse(), text);
    }

    @ApiStatus.Internal
    public QueuedTooltip setSpecialRenderer(Consumer<QueuedTooltip> consumer) {
        this.consumer = consumer;
        return this;
    }

    @ApiStatus.Internal
    public Consumer<QueuedTooltip> getConsumer() {
        return this.consumer;
    }

    public Point getLocation() {
        return this.location;
    }

    public int getX() {
        return this.getLocation().x;
    }

    public int getY() {
        return this.getLocation().y;
    }

    public List<String> getText() {
        return this.text;
    }
}

