/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import me.shedaniel.math.api.Executor;
import me.shedaniel.math.api.Rectangle;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ConfigObject;
import me.shedaniel.rei.api.EntryStack;
import me.shedaniel.rei.api.ItemStackHook;
import me.shedaniel.rei.api.OptimalEntryStack;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.impl.AbstractEntryStack;
import me.shedaniel.rei.impl.SearchArgument;
import me.shedaniel.rei.impl.compat.ModelHasDepth1151Compat;
import me.shedaniel.rei.impl.compat.ModelSideLit1152Compat;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_809;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ItemEntryStack
extends AbstractEntryStack
implements OptimalEntryStack {
    private static final Predicate<class_1087> IS_SIDE_LIT;
    private static final class_4587 MATRICES;
    private class_1799 itemStack;

    public ItemEntryStack(class_1799 itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public Optional<class_2960> getIdentifier() {
        return Optional.ofNullable(class_2378.field_11142.method_10221((Object)this.getItem()));
    }

    @Override
    public EntryStack.Type getType() {
        return EntryStack.Type.ITEM;
    }

    @Override
    public int getAmount() {
        return this.itemStack.method_7947();
    }

    @Override
    public void setAmount(int amount) {
        this.itemStack.method_7939(amount);
    }

    @Override
    public boolean isEmpty() {
        return this.itemStack.method_7960();
    }

    @Override
    public EntryStack copy() {
        EntryStack stack = EntryStack.create(this.getItemStack().method_7972());
        for (Map.Entry<EntryStack.Settings<?>, Object> entry : this.getSettings().entrySet()) {
            stack.setting(entry.getKey(), entry.getValue());
        }
        return stack;
    }

    @Override
    public Object getObject() {
        return this.itemStack;
    }

    @Override
    public boolean equalsIgnoreTagsAndAmount(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        return this.itemStack.method_7909() == stack.getItem();
    }

    @Override
    public boolean equalsAll(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem() || this.getAmount() != stack.getAmount()) {
            return false;
        }
        return class_1799.method_7975((class_1799)this.itemStack, (class_1799)stack.getItemStack());
    }

    @Override
    public boolean equalsIgnoreAmount(EntryStack stack) {
        class_2487 o2;
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() == class_1802.field_8270) {
            // empty if block
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        if (this.itemStack.method_7909() == class_1802.field_8270) {
            class_2487 o22;
            class_1799 otherStack = stack.getItemStack();
            class_2487 o1 = this.itemStack.method_7969();
            boolean b = o1 == (o22 = otherStack.method_7969()) || o1 != null && o22 != null && this.equals(o1, o22);
            return b;
        }
        class_1799 otherStack = stack.getItemStack();
        class_2487 o1 = this.itemStack.method_7969();
        return o1 == (o2 = otherStack.method_7969()) || o1 != null && o2 != null && this.equals(o1, o2);
    }

    public boolean equals(class_2487 o1, class_2487 o2) {
        int o1Size = 0;
        int o2Size = 0;
        for (String key : o1.method_10541()) {
            if (key.equals("Count")) continue;
            ++o1Size;
        }
        for (String key : o2.method_10541()) {
            if (key.equals("Count") || ++o2Size <= o1Size) continue;
            return false;
        }
        if (o1Size != o2Size) {
            return false;
        }
        try {
            for (String key : o1.method_10541()) {
                if (key.equals("Count")) continue;
                class_2520 value = o1.method_10580(key);
                class_2520 otherValue = o2.method_10580(key);
                if (!(value == null ? otherValue != null || !o2.method_10545(key) : (value instanceof class_2487 && otherValue instanceof class_2487 ? value != otherValue && (value == null || otherValue == null || !this.equals((class_2487)value, (class_2487)otherValue)) : !value.method_10714().equals(otherValue.method_10714())))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreTags(EntryStack stack) {
        if (stack.getType() != EntryStack.Type.ITEM) {
            return false;
        }
        if (this.itemStack.method_7909() != stack.getItem()) {
            return false;
        }
        return this.getAmount() == stack.getAmount();
    }

    @Override
    public int hashOfAll() {
        int result = this.hashIgnoreAmount();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    @Override
    public int hashIgnoreTags() {
        int result = this.hashIgnoreAmountAndTags();
        result = 31 * result + this.itemStack.method_7947();
        return result;
    }

    @Override
    public int hashIgnoreAmount() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.itemStack.method_7909().hashCode();
        result = this.itemStack.method_7985() ? 31 * result + this.itemStack.method_7969().method_10714().hashCode() : 31 * result;
        return result;
    }

    @Override
    public int hashIgnoreAmountAndTags() {
        int result = 1;
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + this.itemStack.method_7909().hashCode();
        return result;
    }

    @Override
    @Nullable
    public QueuedTooltip getTooltip(int mouseX, int mouseY) {
        if (this.isEmpty() || !this.get(EntryStack.Settings.TOOLTIP_ENABLED).get().booleanValue()) {
            return null;
        }
        ArrayList toolTip = Lists.newArrayList(SearchArgument.tryGetItemStackToolTip(this.getItemStack(), true));
        toolTip.addAll((Collection)this.get(EntryStack.Settings.TOOLTIP_APPEND_EXTRA).apply(this));
        if (this.get(EntryStack.Settings.TOOLTIP_APPEND_MOD).get().booleanValue() && ConfigObject.getInstance().shouldAppendModNames()) {
            String modString = ClientHelper.getInstance().getFormattedModFromItem(this.getItem());
            boolean alreadyHasMod = false;
            for (String s : toolTip) {
                if (!s.equalsIgnoreCase(modString)) continue;
                alreadyHasMod = true;
                break;
            }
            if (!alreadyHasMod) {
                toolTip.add(modString);
            }
        }
        return QueuedTooltip.create(toolTip);
    }

    @Override
    public void render(Rectangle bounds, int mouseX, int mouseY, float delta) {
        this.optimisedRenderStart(delta);
        this.optimisedRenderBase(bounds, mouseX, mouseY, delta);
        this.optimisedRenderOverlay(bounds, mouseX, mouseY, delta);
        this.optimisedRenderEnd(delta);
    }

    @Override
    public void optimisedRenderStart(float delta) {
        class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
        class_4493.method_21920();
    }

    @Override
    public void optimisedRenderEnd(float delta) {
        class_4493.method_21922();
    }

    private class_1087 getModelFromStack(class_1799 stack) {
        class_1087 model = class_310.method_1551().method_1480().method_4012().method_3308(stack);
        if (stack.method_7909().method_7845()) {
            model = model.method_4710().method_3495(model, stack, null, null);
        }
        if (model != null) {
            return model;
        }
        return class_310.method_1551().method_1480().method_4012().method_3303().method_4744();
    }

    @Override
    public void optimisedRenderBase(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && this.get(EntryStack.Settings.RENDER).get().booleanValue()) {
            boolean bl;
            class_1799 stack = this.getItemStack();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint(this.get(EntryStack.Settings.Item.RENDER_ENCHANTMENT_GLINT).get());
            MATRICES.method_22903();
            MATRICES.method_22904((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)(100.0f + (float)this.getZ()));
            MATRICES.method_22905((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, (float)bounds.getHeight());
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            class_1087 model = this.getModelFromStack(stack);
            boolean bl2 = bl = !IS_SIDE_LIT.test(model);
            if (bl) {
                class_4493.method_24221();
            }
            class_310.method_1551().method_1480().method_23179(stack, class_809.class_811.field_4317, false, MATRICES, (class_4597)immediate, 0xF000F0, class_4608.field_21444, model);
            immediate.method_22993();
            if (bl) {
                class_4493.method_24222();
            }
            MATRICES.method_22909();
            ((ItemStackHook)stack).rei_setRenderEnchantmentGlint(false);
        }
    }

    @Override
    public void optimisedRenderOverlay(Rectangle bounds, int mouseX, int mouseY, float delta) {
        if (!this.isEmpty() && this.get(EntryStack.Settings.RENDER).get().booleanValue()) {
            class_310.method_1551().method_1480().field_4730 = this.getZ();
            class_310.method_1551().method_1480().method_4022(class_310.method_1551().field_1772, this.getItemStack(), bounds.x, bounds.y, this.get(EntryStack.Settings.RENDER_COUNTS).get() != false ? this.get(EntryStack.Settings.COUNTS).apply(this) : "");
            class_310.method_1551().method_1480().field_4730 = 0.0f;
        }
    }

    static {
        MATRICES = new class_4587();
        boolean isOn1_15_2 = false;
        String isSideLit = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1087", "method_24304", "()Z");
        try {
            class_1087.class.getDeclaredMethod(isSideLit, new Class[0]);
            isOn1_15_2 = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        IS_SIDE_LIT = isOn1_15_2 ? (Predicate)Executor.call(() -> () -> new ModelSideLit1152Compat()) : (Predicate)Executor.call(() -> () -> new ModelHasDepth1151Compat());
    }
}

