/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.entrypoint.minecraft.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.loader.FabricLoader;

public final class EntrypointUtils {
    public static <T> void invoke(String name, Class<T> type, Consumer<? super T> invoker) {
        FabricLoader loader = FabricLoader.INSTANCE;
        if (!loader.hasEntrypoints(name)) {
            loader.getLogger().debug("No subscribers for entrypoint '" + name + "'");
        } else {
            EntrypointUtils.invoke0(name, type, invoker);
        }
    }

    private static <T> void invoke0(String name, Class<T> type, Consumer<? super T> invoker) {
        FabricLoader loader = FabricLoader.INSTANCE;
        List<T> entrypoints = loader.getEntrypoints(name, type);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        loader.getLogger().debug("Iterating over entrypoint '" + name + "'");
        for (Object e : entrypoints) {
            try {
                invoker.accept(e);
            }
            catch (Throwable t) {
                errors.add(t);
            }
        }
        if (!errors.isEmpty()) {
            RuntimeException exception = new RuntimeException("Could not execute entrypoint stage '" + name + "' due to errors!");
            for (Throwable t : errors) {
                exception.addSuppressed(t);
            }
            throw exception;
        }
    }
}

