/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.entrypoint.minecraft.hooks.EntrypointUtils;
import net.fabricmc.loader.game.MinecraftGameProvider;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.common.FabricMixinBootstrap;
import net.fabricmc.loader.util.UrlConversionException;
import net.fabricmc.loader.util.UrlUtil;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class FabricTweaker
extends FabricLauncherBase
implements ITweaker {
    protected static Logger LOGGER = LogManager.getFormatterLogger((String)"Fabric|Tweaker");
    protected String[] arguments;
    private LaunchClassLoader launchClassLoader;
    private boolean isDevelopment;

    @Override
    public String getEntrypoint() {
        return this.getLaunchTarget();
    }

    @Override
    public String getTargetNamespace() {
        return this.isDevelopment ? "named" : "intermediary";
    }

    public void acceptOptions(List<String> localArgs, File gameDir, File assetsDir, String profile) {
        this.arguments = localArgs.toArray(new String[0]);
    }

    public void injectIntoClassLoader(LaunchClassLoader launchClassLoader) {
        this.isDevelopment = Boolean.parseBoolean(System.getProperty("fabric.development", "false"));
        Launch.blackboard.put("fabric.development", this.isDevelopment);
        FabricTweaker.setProperties(Launch.blackboard);
        this.launchClassLoader = launchClassLoader;
        launchClassLoader.addClassLoaderExclusion("org.objectweb.asm.");
        launchClassLoader.addClassLoaderExclusion("org.spongepowered.asm.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.loader.");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.Environment");
        launchClassLoader.addClassLoaderExclusion("net.fabricmc.api.EnvType");
        MinecraftGameProvider provider = new MinecraftGameProvider();
        provider.acceptArguments(this.arguments);
        if (!provider.locateGame(this.getEnvironmentType(), (ClassLoader)launchClassLoader)) {
            throw new RuntimeException("Could not locate Minecraft: provider locate failed");
        }
        FabricLoader loader = FabricLoader.INSTANCE;
        loader.setGameProvider(provider);
        loader.load();
        loader.freeze();
        launchClassLoader.registerTransformer("net.fabricmc.loader.launch.FabricClassTransformer");
        if (!this.isDevelopment) {
            Launch.blackboard.put("fabric.development", false);
            try {
                String target = this.getLaunchTarget();
                URL loc = launchClassLoader.findResource(target.replace('.', '/') + ".class");
                JarURLConnection locConn = (JarURLConnection)loc.openConnection();
                File jarFile = UrlUtil.asFile(locConn.getJarFileURL());
                if (!jarFile.exists()) {
                    throw new RuntimeException("Could not locate Minecraft: " + jarFile.getAbsolutePath() + " not found");
                }
                FabricLauncherBase.deobfuscate(provider.getGameId(), provider.getNormalizedGameVersion(), provider.getLaunchDirectory(), jarFile.toPath(), this);
            }
            catch (IOException | UrlConversionException e) {
                throw new RuntimeException("Failed to deobfuscate Minecraft!", e);
            }
        }
        MinecraftGameProvider.TRANSFORMER.locateEntrypoints(this);
        MixinBootstrap.init();
        FabricMixinBootstrap.init(this.getEnvironmentType(), FabricLoader.INSTANCE);
        MixinEnvironment.getDefaultEnvironment().setSide(this.getEnvironmentType() == EnvType.CLIENT ? MixinEnvironment.Side.CLIENT : MixinEnvironment.Side.SERVER);
        EntrypointUtils.invoke("preLaunch", PreLaunchEntrypoint.class, PreLaunchEntrypoint::onPreLaunch);
    }

    public String[] getLaunchArguments() {
        return this.arguments;
    }

    @Override
    public void propose(URL url) {
        this.launchClassLoader.addURL(url);
    }

    @Override
    public Collection<URL> getLoadTimeDependencies() {
        return this.launchClassLoader.getSources();
    }

    @Override
    public boolean isClassLoaded(String name) {
        throw new RuntimeException("TODO isClassLoaded/launchwrapper");
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.launchClassLoader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getTargetClassLoader() {
        return this.launchClassLoader;
    }

    @Override
    public byte[] getClassByteArray(String name) throws IOException {
        return this.launchClassLoader.getClassBytes(name);
    }

    @Override
    public boolean isDevelopment() {
        return this.isDevelopment;
    }
}

