/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.launch.knot;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.launch.knot.DummyClassLoader;
import net.fabricmc.loader.launch.knot.KnotClassDelegate;
import net.fabricmc.loader.launch.knot.KnotClassLoaderInterface;

class KnotClassLoader
extends SecureClassLoader
implements KnotClassLoaderInterface {
    private final DynamicURLClassLoader urlLoader;
    private final ClassLoader originalLoader = this.getClass().getClassLoader();
    private final KnotClassDelegate delegate;

    KnotClassLoader(boolean isDevelopment, EnvType envType, GameProvider provider) {
        super(new DynamicURLClassLoader(new URL[0]));
        this.urlLoader = (DynamicURLClassLoader)this.getParent();
        this.delegate = new KnotClassDelegate(isDevelopment, envType, this, provider);
    }

    @Override
    public KnotClassDelegate getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassLoaded(String name) {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            return this.findLoadedClass(name) != null;
        }
    }

    @Override
    public URL getResource(String name) {
        Objects.requireNonNull(name);
        URL url = this.urlLoader.getResource(name);
        if (url == null) {
            url = this.originalLoader.getResource(name);
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        Objects.requireNonNull(name);
        InputStream inputStream = this.urlLoader.getResourceAsStream(name);
        if (inputStream == null) {
            inputStream = this.originalLoader.getResourceAsStream(name);
        }
        return inputStream;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        final Enumeration<URL> first = this.urlLoader.getResources(name);
        final Enumeration<URL> second = this.originalLoader.getResources(name);
        return new Enumeration<URL>(){
            Enumeration<URL> current;
            {
                this.current = first;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.current == null) {
                    return false;
                }
                if (this.current.hasMoreElements()) {
                    return true;
                }
                return this.current == first && second.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (this.current == null) {
                    return null;
                }
                if (!this.current.hasMoreElements()) {
                    if (this.current == first) {
                        this.current = second;
                    } else {
                        this.current = null;
                        return null;
                    }
                }
                return this.current.nextElement();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            byte[] input;
            Class<?> c = this.findLoadedClass(name);
            if (c == null && !name.startsWith("com.google.gson.") && (input = this.delegate.loadClassData(name, resolve)) != null) {
                String pkgString;
                KnotClassDelegate.Metadata metadata = this.delegate.getMetadata(name, this.urlLoader.getResource(this.delegate.getClassFileName(name)));
                int pkgDelimiterPos = name.lastIndexOf(46);
                if (pkgDelimiterPos > 0 && this.getPackage(pkgString = name.substring(0, pkgDelimiterPos)) == null) {
                    this.definePackage(pkgString, null, null, null, null, null, null, null);
                }
                c = this.defineClass(name, input, 0, input.length, metadata.codeSource);
            }
            if (c == null) {
                c = this.originalLoader.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public void addURL(URL url) {
        this.urlLoader.addURL(url);
    }

    @Override
    public InputStream getResourceAsStream(String classFile, boolean skipOriginalLoader) throws IOException {
        InputStream inputStream = this.urlLoader.getResourceAsStream(classFile);
        if (inputStream == null && !skipOriginalLoader) {
            inputStream = this.originalLoader.getResourceAsStream(classFile);
        }
        return inputStream;
    }

    static {
        KnotClassLoader.registerAsParallelCapable();
    }

    private static class DynamicURLClassLoader
    extends URLClassLoader {
        private DynamicURLClassLoader(URL[] urls) {
            super(urls, (ClassLoader)new DummyClassLoader());
        }

        @Override
        public void addURL(URL url) {
            super.addURL(url);
        }

        static {
            DynamicURLClassLoader.registerAsParallelCapable();
        }
    }
}

