/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.loader.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.ModMetadataV0;
import net.fabricmc.loader.metadata.ModMetadataV1;
import net.fabricmc.loader.util.version.VersionDeserializer;

public class ModMetadataParser {
    public static final int LATEST_VERSION = 1;
    private static final Gson GSON_V1 = new GsonBuilder().registerTypeAdapter(Version.class, (Object)new VersionDeserializer()).registerTypeAdapter(ModMetadataV1.JarEntry.class, (Object)new ModMetadataV1.JarEntry.Deserializer()).registerTypeAdapter(ModMetadataV1.IconEntry.class, (Object)new ModMetadataV1.IconEntry.Deserializer()).registerTypeAdapter(ModMetadataV1.LicenseEntry.class, (Object)new ModMetadataV1.LicenseEntry.Deserializer()).registerTypeAdapter(ModMetadataV1.Person.class, (Object)new ModMetadataV1.Person.Deserializer()).registerTypeAdapter(ModMetadataV1.DependencyContainer.class, (Object)new ModMetadataV1.DependencyContainer.Deserializer()).registerTypeAdapter(ModMetadataV1.MixinEntry.class, (Object)new ModMetadataV1.MixinEntry.Deserializer()).registerTypeAdapter(ModMetadataV1.EntrypointContainer.class, (Object)new ModMetadataV1.EntrypointContainer.Deserializer()).registerTypeAdapter(ModMetadataV1.Environment.class, (Object)new ModMetadataV1.Environment.Deserializer()).create();
    private static final Gson GSON_V0 = new GsonBuilder().registerTypeAdapter(Version.class, (Object)new VersionDeserializer()).registerTypeAdapter(ModMetadataV0.Side.class, (Object)new ModMetadataV0.Side.Deserializer()).registerTypeAdapter(ModMetadataV0.Mixins.class, (Object)new ModMetadataV0.Mixins.Deserializer()).registerTypeAdapter(ModMetadataV0.Links.class, (Object)new ModMetadataV0.Links.Deserializer()).registerTypeAdapter(ModMetadataV0.Dependency.class, (Object)new ModMetadataV0.Dependency.Deserializer()).registerTypeAdapter(ModMetadataV0.Person.class, (Object)new ModMetadataV0.Person.Deserializer()).create();
    private static final JsonParser JSON_PARSER = new JsonParser();

    private static LoaderModMetadata getMod(FabricLoader loader, JsonObject object) {
        if (!object.has("schemaVersion")) {
            return (LoaderModMetadata)GSON_V0.fromJson((JsonElement)object, ModMetadataV0.class);
        }
        switch (object.get("schemaVersion").getAsInt()) {
            case 1: {
                return (LoaderModMetadata)GSON_V1.fromJson((JsonElement)object, ModMetadataV1.class);
            }
        }
        loader.getLogger().warn("Mod ID " + (object.has("id") ? object.get("id").getAsString() : "<unknown>") + " has invalid schema version: " + object.get("schemaVersion").getAsInt());
        return null;
    }

    public static LoaderModMetadata[] getMods(FabricLoader loader, InputStream in) {
        LoaderModMetadata metadata;
        JsonElement el = JSON_PARSER.parse((Reader)new InputStreamReader(in));
        if (el.isJsonObject() && (metadata = ModMetadataParser.getMod(loader, el.getAsJsonObject())) != null) {
            return new LoaderModMetadata[]{metadata};
        }
        return new LoaderModMetadata[0];
    }
}

