/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.version;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.util.version.VersionParsingException;

public class SemanticVersionImpl
implements SemanticVersion {
    private static final Pattern DOT_SEPARATED_ID = Pattern.compile("|[-0-9A-Za-z]+(\\.[-0-9A-Za-z]+)*");
    private final int[] components;
    private final String prerelease;
    private final String build;
    private String friendlyName;

    public SemanticVersionImpl(String version, boolean storeX) throws VersionParsingException {
        int buildDelimPos = version.indexOf(43);
        if (buildDelimPos >= 0) {
            this.build = version.substring(buildDelimPos + 1);
            version = version.substring(0, buildDelimPos);
        } else {
            this.build = null;
        }
        int dashDelimPos = version.indexOf(45);
        if (dashDelimPos >= 0) {
            this.prerelease = version.substring(dashDelimPos + 1);
            version = version.substring(0, dashDelimPos);
        } else {
            this.prerelease = null;
        }
        if (this.prerelease != null && !DOT_SEPARATED_ID.matcher(this.prerelease).matches()) {
            throw new VersionParsingException("Invalid prerelease string '" + this.prerelease + "'!");
        }
        if (this.build != null && !DOT_SEPARATED_ID.matcher(this.build).matches()) {
            throw new VersionParsingException("Invalid build string '" + this.build + "'!");
        }
        if (version.endsWith(".")) {
            throw new VersionParsingException("Negative version number component found!");
        }
        if (version.startsWith(".")) {
            throw new VersionParsingException("Missing version component!");
        }
        String[] componentStrings = version.split("\\.");
        if (componentStrings.length < 1) {
            throw new VersionParsingException("Did not provide version numbers!");
        }
        this.components = new int[componentStrings.length];
        for (int i = 0; i < componentStrings.length; ++i) {
            String compStr = componentStrings[i];
            if (storeX) {
                if (compStr.equals("x") || compStr.equals("X") || compStr.equals("*")) {
                    if (this.prerelease != null) {
                        throw new VersionParsingException("Pre-release versions are not allowed to use X-ranges!");
                    }
                    this.components[i] = Integer.MIN_VALUE;
                    continue;
                }
                if (i > 0 && this.components[i - 1] == Integer.MIN_VALUE) {
                    throw new VersionParsingException("Interjacent wildcard (1.x.2) are disallowed!");
                }
            }
            if (compStr.trim().isEmpty()) {
                throw new VersionParsingException("Missing version number component!");
            }
            try {
                this.components[i] = Integer.parseInt(compStr);
                if (this.components[i] >= 0) continue;
                throw new VersionParsingException("Negative version number component '" + compStr + "'!");
            }
            catch (NumberFormatException e) {
                throw new VersionParsingException("Could not parse version number component '" + compStr + "'!", e);
            }
        }
        if (storeX && this.components.length == 1 && this.components[0] == Integer.MIN_VALUE) {
            throw new VersionParsingException("Versions of form 'x' or 'X' not allowed!");
        }
        this.buildFriendlyName();
    }

    private void buildFriendlyName() {
        StringBuilder fnBuilder = new StringBuilder();
        boolean first = true;
        for (int i : this.components) {
            if (first) {
                first = false;
            } else {
                fnBuilder.append('.');
            }
            if (i == Integer.MIN_VALUE) {
                fnBuilder.append('x');
                continue;
            }
            fnBuilder.append(i);
        }
        if (this.prerelease != null) {
            fnBuilder.append('-').append(this.prerelease);
        }
        if (this.build != null) {
            fnBuilder.append('+').append(this.build);
        }
        this.friendlyName = fnBuilder.toString();
    }

    @Override
    public int getVersionComponentCount() {
        return this.components.length;
    }

    @Override
    public int getVersionComponent(int pos) {
        if (pos < 0) {
            throw new RuntimeException("Tried to access negative version number component!");
        }
        if (pos >= this.components.length) {
            return this.components[this.components.length - 1] == Integer.MIN_VALUE ? Integer.MIN_VALUE : 0;
        }
        return this.components[pos];
    }

    @Override
    public Optional<String> getPrereleaseKey() {
        return Optional.ofNullable(this.prerelease);
    }

    @Override
    public Optional<String> getBuildKey() {
        return Optional.ofNullable(this.build);
    }

    @Override
    public String getFriendlyString() {
        return this.friendlyName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SemanticVersionImpl)) {
            return false;
        }
        SemanticVersionImpl other = (SemanticVersionImpl)o;
        if (!this.equalsComponentsExactly(other)) {
            return false;
        }
        return Objects.equals(this.prerelease, other.prerelease) && Objects.equals(this.build, other.build);
    }

    public int hashCode() {
        return Arrays.hashCode(this.components) * 73 + (this.prerelease != null ? this.prerelease.hashCode() * 11 : 0) + (this.build != null ? this.build.hashCode() : 0);
    }

    public String toString() {
        return this.getFriendlyString();
    }

    @Override
    public boolean hasWildcard() {
        for (int i : this.components) {
            if (i >= 0) continue;
            return true;
        }
        return false;
    }

    public boolean equalsComponentsExactly(SemanticVersionImpl other) {
        for (int i = 0; i < Math.max(this.getVersionComponentCount(), other.getVersionComponentCount()); ++i) {
            if (this.getVersionComponent(i) == other.getVersionComponent(i)) continue;
            return false;
        }
        return true;
    }

    boolean isPrerelease() {
        return this.prerelease != null;
    }
}

