/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.orderly;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.prospector.orderly.config.OrderlyConfig;
import io.github.prospector.orderly.config.OrderlyConfigManager;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_757;
import net.minecraft.class_765;
import net.minecraft.class_898;
import org.lwjgl.opengl.GL11;

public class HealthBarRenderer {
    public static void render(class_4587 matrices, float partialTicks, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, class_1159 projection, class_4604 capturedFrustum) {
        class_1297 cameraEntity;
        class_310 mc = class_310.method_1551();
        OrderlyConfig config = OrderlyConfigManager.getConfig();
        if (mc.field_1687 == null || !config.canRenderInF1() && !class_310.method_1498() || !config.canDraw()) {
            return;
        }
        Object object = cameraEntity = camera.method_19331() != null ? camera.method_19331() : mc.field_1724;
        assert (cameraEntity != null) : "Camera Entity must not be null!";
        if (config.showingOnlyFocused()) {
            class_1297 focused = HealthBarRenderer.getEntityLookedAt(cameraEntity);
            if (focused instanceof class_1309 && focused.method_5805()) {
                HealthBarRenderer.renderHealthBar((class_1309)focused, matrices, partialTicks, camera, cameraEntity);
            }
        } else {
            class_4604 frustum;
            class_243 cameraPos = camera.method_19326();
            if (capturedFrustum != null) {
                frustum = capturedFrustum;
            } else {
                frustum = new class_4604(matrices.method_23760().method_23761(), projection);
                frustum.method_23088(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215());
            }
            StreamSupport.stream(mc.field_1687.method_18112().spliterator(), false).filter(entity -> entity instanceof class_1309 && entity != cameraEntity && entity.method_5805() && entity.method_5736().isEmpty() && entity.method_5727(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215()) && (entity.field_5985 || frustum.method_23093(entity.method_5829()))).map(class_1309.class::cast).forEach(entity -> HealthBarRenderer.renderHealthBar(entity, matrices, partialTicks, camera, cameraEntity));
        }
    }

    private static class_1297 getEntityLookedAt(class_1297 e) {
        class_1297 foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        class_239 pos = HealthBarRenderer.raycast(e, 32.0);
        class_243 positionVector = e.method_5812();
        if (e instanceof class_1657) {
            positionVector = positionVector.method_1031(0.0, (double)e.method_18381(e.method_18376()), 0.0);
        }
        if (pos != null) {
            distance = pos.method_17784().method_1022(positionVector);
        }
        class_243 lookVector = e.method_5720();
        class_243 reachVector = positionVector.method_1031(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0);
        class_1297 lookedEntity = null;
        List entitiesInBoundingBox = e.method_5770().method_8335(e, e.method_5829().method_1012(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0).method_1014(1.0));
        double minDistance = distance;
        for (class_1297 entity : entitiesInBoundingBox) {
            if (entity.method_5863()) {
                double distanceToEntity;
                class_238 collisionBox = entity.method_5830();
                Optional interceptPosition = collisionBox.method_992(positionVector, reachVector);
                if (collisionBox.method_1006(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.method_1022((class_243)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static void renderHealthBar(class_1309 passedEntity, class_4587 matrices, float partialTicks, class_4184 camera, class_1297 viewPoint) {
        Preconditions.checkNotNull((Object)passedEntity, (Object)"tried to render health bar for null entity");
        OrderlyConfig config = OrderlyConfigManager.getConfig();
        class_310 mc = class_310.method_1551();
        Stack<class_1309> passengerStack = new Stack<class_1309>();
        class_1309 entity = passedEntity;
        passengerStack.push(entity);
        while (entity.method_5642() instanceof class_1309) {
            entity = (class_1309)entity.method_5642();
            passengerStack.push(entity);
        }
        float pastTranslate = 0.0f;
        while (!passengerStack.isEmpty()) {
            boolean useHue;
            float maxHealth;
            float distance;
            entity = (class_1309)passengerStack.pop();
            if (!entity.method_5805()) continue;
            class_2960 entityID = class_2378.field_11145.method_10221((Object)entity.method_5864());
            String idString = String.valueOf(entityID);
            boolean boss = config.getBosses().contains(idString);
            if (config.getBlacklist().contains(idString) || (distance = passedEntity.method_5739(viewPoint)) > (float)config.getMaxDistance() || !passedEntity.method_6057(viewPoint) || entity.method_5767() || boss && !config.canShowOnBosses() || !config.canShowOnPlayers() && entity instanceof class_1657 || (maxHealth = entity.method_6063()) <= 0.0f) continue;
            double x = passedEntity.field_6014 + (passedEntity.method_23317() - passedEntity.field_6014) * (double)partialTicks;
            double y = passedEntity.field_6036 + (passedEntity.method_23318() - passedEntity.field_6036) * (double)partialTicks;
            double z = passedEntity.field_5969 + (passedEntity.method_23321() - passedEntity.field_5969) * (double)partialTicks;
            float scale = 0.026666673f * config.getHealthBarScale();
            float health = class_3532.method_15363((float)entity.method_6032(), (float)0.0f, (float)maxHealth);
            float percent = health / maxHealth * 100.0f;
            class_898 renderManager = class_310.method_1551().method_1561();
            int bgHeight = config.getBackgroundHeight();
            int barHeight = config.getBarHeight();
            float padding = config.getBackgroundPadding();
            matrices.method_22903();
            matrices.method_22904(x - renderManager.field_4686.method_19326().field_1352, y - renderManager.field_4686.method_19326().field_1351 + (double)passedEntity.method_17682() + config.getHeightAbove(), z - renderManager.field_4686.method_19326().field_1350);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            class_1158 rotation = camera.method_23767().method_23695();
            rotation.method_22872(-1.0f);
            matrices.method_22907(rotation);
            matrices.method_22905(-scale, -scale, scale);
            boolean lighting = GL11.glGetBoolean((int)2896);
            RenderSystem.disableLighting();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((class_4493.class_4535)class_4493.class_4535.SRC_ALPHA, (class_4493.class_4534)class_4493.class_4534.ONE_MINUS_SRC_ALPHA);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            float size = config.getPlateSize();
            int r = 0;
            int g = 255;
            int b = 0;
            class_1799 stack = null;
            if (entity instanceof class_1308) {
                r = 255;
                g = 0;
                class_1310 attr = entity.method_6046();
                stack = attr == class_1310.field_6293 ? new class_1799((class_1935)class_1802.field_8680) : (attr == class_1310.field_6289 ? new class_1799((class_1935)class_1802.field_8511) : new class_1799((class_1935)class_1802.field_8398, 1));
            }
            if (boss) {
                stack = new class_1799((class_1935)class_1802.field_8791);
                size = config.getPlateSizeBoss();
                r = 128;
                g = 0;
                b = 128;
            }
            int armor = entity.method_6096();
            boolean bl = useHue = !config.colorByType();
            if (useHue) {
                float hue = Math.max(0.0f, health / maxHealth / 3.0f - 0.07f);
                Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
                r = color.getRed();
                g = color.getGreen();
                b = color.getBlue();
            }
            matrices.method_22904(0.0, (double)pastTranslate, 0.0);
            float s = 0.5f;
            String name = (entity.method_16914() ? entity.method_5797().method_10854(class_124.field_1056) : entity.method_5476()).method_10863();
            float namel = (float)mc.field_1772.method_1727(name) * s;
            if (namel + 20.0f > size * 2.0f) {
                size = namel / 2.0f + 10.0f;
            }
            float healthSize = size * (health / maxHealth);
            class_1159 modelViewMatrix = matrices.method_23760().method_23761();
            if (config.drawsBackground()) {
                buffer.method_1328(7, class_290.field_1576);
                buffer.method_22918(modelViewMatrix, -size - padding, (float)(-bgHeight), 0.0f).method_1336(0, 0, 0, 64).method_1344();
                buffer.method_22918(modelViewMatrix, -size - padding, (float)barHeight + padding, 0.0f).method_1336(0, 0, 0, 64).method_1344();
                buffer.method_22918(modelViewMatrix, size + padding, (float)barHeight + padding, 0.0f).method_1336(0, 0, 0, 64).method_1344();
                buffer.method_22918(modelViewMatrix, size + padding, (float)(-bgHeight), 0.0f).method_1336(0, 0, 0, 64).method_1344();
                buffer.method_1326();
                class_286.method_1309((class_287)buffer);
            }
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22918(modelViewMatrix, -size, 0.0f, 0.0f).method_1336(127, 127, 127, 127).method_1344();
            buffer.method_22918(modelViewMatrix, -size, (float)barHeight, 0.0f).method_1336(127, 127, 127, 127).method_1344();
            buffer.method_22918(modelViewMatrix, size, (float)barHeight, 0.0f).method_1336(127, 127, 127, 127).method_1344();
            buffer.method_22918(modelViewMatrix, size, 0.0f, 0.0f).method_1336(127, 127, 127, 127).method_1344();
            buffer.method_1326();
            class_286.method_1309((class_287)buffer);
            buffer.method_1328(7, class_290.field_1576);
            buffer.method_22918(modelViewMatrix, -size, 0.0f, 0.0f).method_1336(r, g, b, 127).method_1344();
            buffer.method_22918(modelViewMatrix, -size, (float)barHeight, 0.0f).method_1336(r, g, b, 127).method_1344();
            buffer.method_22918(modelViewMatrix, healthSize * 2.0f - size, (float)barHeight, 0.0f).method_1336(r, g, b, 127).method_1344();
            buffer.method_22918(modelViewMatrix, healthSize * 2.0f - size, 0.0f, 0.0f).method_1336(r, g, b, 127).method_1344();
            buffer.method_1326();
            class_286.method_1309((class_287)buffer);
            RenderSystem.enableTexture();
            matrices.method_22903();
            matrices.method_22904((double)(-size), -4.5, 0.0);
            matrices.method_22905(s, s, s);
            class_4597.class_4598 immediate = mc.method_22940().method_23000();
            modelViewMatrix = matrices.method_23760().method_23761();
            mc.field_1772.method_22942(name, 0.0f, 0.0f, 0xFFFFFF, false, modelViewMatrix, (class_4597)immediate, true, 0, 0xF000F0);
            float s1 = 0.75f;
            matrices.method_22903();
            matrices.method_22905(s1, s1, s1);
            modelViewMatrix = matrices.method_23760().method_23761();
            int h = config.getHpTextHeight();
            String maxHpStr = String.format("%s%.2f", class_124.field_1067, Float.valueOf(maxHealth)).replaceAll("\\.00$", "");
            String hpStr = String.format("%.2f", Float.valueOf(health)).replaceAll("\\.00$", "");
            String percStr = String.format("%.2f%%", Float.valueOf(percent)).replace(".00%", "%");
            if (maxHpStr.endsWith(".00")) {
                maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 3);
            }
            if (hpStr.endsWith(".00")) {
                hpStr = hpStr.substring(0, hpStr.length() - 3);
            }
            int light = 0xF000F0;
            int white = 0xFFFFFF;
            int black = 0;
            if (config.showCurrentHP()) {
                mc.field_1772.method_22942(hpStr, 2.0f, (float)h, white, false, modelViewMatrix, (class_4597)immediate, true, black, light);
            }
            if (config.canShowMaxHP()) {
                mc.field_1772.method_22942(maxHpStr, (float)((int)(size / (s * s1) * 2.0f) - 2 - mc.field_1772.method_1727(maxHpStr)), (float)h, white, false, modelViewMatrix, (class_4597)immediate, true, black, light);
            }
            if (config.canShowPercentage()) {
                mc.field_1772.method_22942(percStr, (float)((int)(size / (s * s1))) - (float)mc.field_1772.method_1727(percStr) / 2.0f, (float)h, white, false, modelViewMatrix, (class_4597)immediate, true, black, light);
            }
            if (config.isDebugInfoEnabled() && mc.field_1690.field_1866) {
                mc.field_1772.method_22942(String.format("ID: \"%s\"", idString), 0.0f, (float)(h + 16), white, false, modelViewMatrix, (class_4597)immediate, true, black, light);
            }
            matrices.method_22909();
            immediate.method_22993();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int off = 0;
            s1 = 0.5f;
            matrices.method_22905(s1, s1, s1);
            matrices.method_22904((double)(size / (s * s1) * 2.0f - 16.0f), 0.0, 0.0);
            mc.method_1531().method_22813(class_1059.field_5275);
            modelViewMatrix = matrices.method_23760().method_23761();
            if (stack != null && config.canShowAttributes()) {
                HealthBarRenderer.renderIcon(off, 0, stack, 16, 16, modelViewMatrix);
                off -= 16;
            }
            if (armor > 0 && config.canShowArmor()) {
                int i;
                int ironArmor = armor % 5;
                int diamondArmor = armor / 5;
                if (!config.canShowGroupArmor()) {
                    ironArmor = armor;
                    diamondArmor = 0;
                }
                stack = new class_1799((class_1935)class_1802.field_8523);
                for (i = 0; i < ironArmor; ++i) {
                    HealthBarRenderer.renderIcon(off, 0, stack, 16, 16, modelViewMatrix);
                    off -= 4;
                }
                stack = new class_1799((class_1935)class_1802.field_8058);
                for (i = 0; i < diamondArmor; ++i) {
                    HealthBarRenderer.renderIcon(off, 0, stack, 16, 16, modelViewMatrix);
                    off -= 4;
                }
            }
            matrices.method_22909();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            if (lighting) {
                RenderSystem.enableLighting();
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrices.method_22909();
            pastTranslate -= (float)(bgHeight + barHeight) + padding;
        }
    }

    @Nullable
    private static class_239 raycast(class_1297 entity, double len) {
        class_243 look;
        class_243 vec = new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321());
        if (entity instanceof class_1657) {
            vec = vec.method_1019(new class_243(0.0, (double)entity.method_18381(entity.method_18376()), 0.0));
        }
        if ((look = entity.method_5720()) == null) {
            return null;
        }
        return HealthBarRenderer.raycast(entity, vec, look, len);
    }

    private static void renderIcon(int vertexX, int vertexY, class_1799 stack, int intU, int intV, class_1159 modelViewMatrix) {
        try {
            class_310 mc = class_310.method_1551();
            class_1087 bakedModel = mc.method_1480().method_4012().method_3308(stack);
            class_1058 textureAtlasSprite = bakedModel.method_4711();
            RenderSystem.enableBlend();
            mc.method_1531().method_22813(class_1059.field_5275);
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(7, class_290.field_1585);
            buffer.method_22918(modelViewMatrix, (float)vertexX, (float)(vertexY + intV), 0.0f).method_22913(textureAtlasSprite.method_4594(), textureAtlasSprite.method_4575()).method_1344();
            buffer.method_22918(modelViewMatrix, (float)(vertexX + intU), (float)(vertexY + intV), 0.0f).method_22913(textureAtlasSprite.method_4577(), textureAtlasSprite.method_4575()).method_1344();
            buffer.method_22918(modelViewMatrix, (float)(vertexX + intU), (float)vertexY, 0.0f).method_22913(textureAtlasSprite.method_4577(), textureAtlasSprite.method_4593()).method_1344();
            buffer.method_22918(modelViewMatrix, (float)vertexX, (float)vertexY, 0.0f).method_22913(textureAtlasSprite.method_4594(), textureAtlasSprite.method_4593()).method_1344();
            buffer.method_1326();
            class_286.method_1309((class_287)buffer);
            RenderSystem.disableBlend();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class_239 raycast(class_1297 entity, class_243 origin, class_243 ray, double len) {
        class_243 next = origin.method_1019(ray.method_1029().method_1021(len));
        return entity.method_5770().method_17742(new class_3959(origin, next, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity));
    }
}

