/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.orderly.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import io.github.prospector.orderly.config.OrderlyConfigManager;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class OrderlyConfig {
    private static final transient String[] blacklistDefaults = new String[]{"minecraft:armor_stand", "minecraft:bee", "minecraft:cod", "minecraft:pufferfish", "minecraft:salmon", "minecraft:shulker", "minecraft:tropical_fish", "illuminations:firefly"};
    private static final transient String[] bossDefaults = new String[]{"minecraft:ender_dragon", "minecraft:wither"};
    private boolean draw = true;
    private int maxDistance = 24;
    private boolean renderInF1 = false;
    private float healthBarScale = 1.0f;
    private double heightAbove = 0.6;
    private boolean drawBackground = true;
    private int backgroundPadding = 2;
    private int backgroundHeight = 6;
    private int barHeight = 4;
    private int plateSize = 25;
    private int plateSizeBoss = 50;
    private boolean showAttributes = true;
    private boolean showArmor = true;
    private boolean groupArmor = true;
    private boolean colorByType = false;
    private int hpTextHeight = 14;
    @SerializedName(value="show_max_hp")
    private boolean showMaxHP = true;
    @SerializedName(value="show_current_hp")
    private boolean showCurrentHP = true;
    private boolean showPercentage = true;
    private boolean showOnPlayers = true;
    private boolean showOnBosses = true;
    private boolean showOnlyFocused = false;
    private boolean enableDebugInfo = false;
    private Set<String> blacklist = Sets.newHashSet((Object[])blacklistDefaults);
    private Set<String> bosses = Sets.newHashSet((Object[])bossDefaults);

    static class_437 createConfigScreen(class_437 parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(String.format("config.%s.title", "orderly"));
        OrderlyConfig config = OrderlyConfigManager.getConfig();
        builder.getOrCreateCategory("general").addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("draw", config.canDraw()).setDefaultValue(true).setSaveConsumer(b -> {
            config.draw = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("maxDistance", config.getMaxDistance()).setDefaultValue(24).setSaveConsumer(i -> {
            config.maxDistance = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("renderInF1", config.canRenderInF1()).setDefaultValue(false).setSaveConsumer(b -> {
            config.renderInF1 = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startFloatField("healthBarScale", config.getHealthBarScale()).setDefaultValue(1.0f).setSaveConsumer(d -> {
            config.healthBarScale = d.floatValue();
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startDoubleField("heightAbove", config.getHeightAbove()).setDefaultValue(0.6).setSaveConsumer(d -> {
            config.heightAbove = d;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("drawBackground", config.drawsBackground()).setDefaultValue(true).setSaveConsumer(b -> {
            config.drawBackground = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("backgroundPadding", config.getBackgroundPadding()).setDefaultValue(2).setSaveConsumer(i -> {
            config.backgroundPadding = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("backgroundHeight", config.getBackgroundHeight()).setDefaultValue(6).setSaveConsumer(i -> {
            config.backgroundHeight = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("barHeight", config.getBarHeight()).setDefaultValue(4).setSaveConsumer(i -> {
            config.barHeight = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("plateSize", config.getPlateSize()).setDefaultValue(25).setSaveConsumer(i -> {
            config.plateSize = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("plateSizeBoss", config.getPlateSizeBoss()).setDefaultValue(50).setSaveConsumer(i -> {
            config.plateSizeBoss = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showAttributes", config.canShowAttributes()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showAttributes = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showArmor", config.canShowArmor()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showArmor = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("groupArmor", config.canShowGroupArmor()).setDefaultValue(true).setSaveConsumer(b -> {
            config.groupArmor = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("colorByType", config.colorByType()).setDefaultValue(false).setSaveConsumer(b -> {
            config.colorByType = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startIntField("hpTextHeight", config.getHpTextHeight()).setDefaultValue(14).setSaveConsumer(i -> {
            config.hpTextHeight = i;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showMaxHP", config.canShowMaxHP()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showMaxHP = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showCurrentHP", config.showCurrentHP()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showCurrentHP = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showPercentage", config.canShowPercentage()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showPercentage = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showOnPlayers", config.canShowOnPlayers()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showOnPlayers = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showOnBosses", config.canShowOnBosses()).setDefaultValue(true).setSaveConsumer(b -> {
            config.showOnBosses = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("showOnlyFocused", config.showingOnlyFocused()).setDefaultValue(false).setSaveConsumer(b -> {
            config.showOnlyFocused = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startBooleanToggle("enableDebugInfo", config.isDebugInfoEnabled()).setDefaultValue(false).setSaveConsumer(b -> {
            config.enableDebugInfo = b;
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startStrList("blacklist", (List)Lists.newArrayList(config.getBlacklist())).setCellErrorSupplier(value -> Optional.ofNullable(!class_2960.method_20207((String)value) ? class_1074.method_4662((String)"config.orderly.error.invalid_identifier", (Object[])new Object[]{value}) : null)).setDefaultValue((List)Lists.newArrayList((Object[])blacklistDefaults)).setExpended(true).setSaveConsumer(strings -> {
            config.blacklist = strings.stream().filter(class_2960::method_20207).map(class_2960::new).map(class_2960::toString).collect(Collectors.toSet());
        }).build()).addEntry((AbstractConfigListEntry)ConfigEntryBuilder.create().startStrList("bosses", (List)Lists.newArrayList(config.getBosses())).setCellErrorSupplier(value -> Optional.ofNullable(!class_2960.method_20207((String)value) ? class_1074.method_4662((String)"config.orderly.error.invalid_identifier", (Object[])new Object[]{value}) : null)).setDefaultValue((List)Lists.newArrayList((Object[])bossDefaults)).setExpended(true).setSaveConsumer(strings -> {
            config.bosses = strings.stream().filter(class_2960::method_20207).map(class_2960::new).map(class_2960::toString).collect(Collectors.toSet());
        }).build());
        builder.setSavingRunnable(OrderlyConfigManager::save);
        return builder.build();
    }

    public boolean canDraw() {
        return this.draw;
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public boolean canRenderInF1() {
        return this.renderInF1;
    }

    public float getHealthBarScale() {
        return this.healthBarScale;
    }

    public double getHeightAbove() {
        return this.heightAbove;
    }

    public boolean drawsBackground() {
        return this.drawBackground;
    }

    public int getBackgroundPadding() {
        return this.backgroundPadding;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public int getPlateSize() {
        return this.plateSize;
    }

    public int getPlateSizeBoss() {
        return this.plateSizeBoss;
    }

    public boolean canShowAttributes() {
        return this.showAttributes;
    }

    public boolean canShowArmor() {
        return this.showArmor;
    }

    public boolean canShowGroupArmor() {
        return this.groupArmor;
    }

    public boolean colorByType() {
        return this.colorByType;
    }

    public int getHpTextHeight() {
        return this.hpTextHeight;
    }

    public boolean canShowMaxHP() {
        return this.showMaxHP;
    }

    public boolean showCurrentHP() {
        return this.showCurrentHP;
    }

    public boolean canShowPercentage() {
        return this.showPercentage;
    }

    public boolean canShowOnPlayers() {
        return this.showOnPlayers;
    }

    public boolean canShowOnBosses() {
        return this.showOnBosses;
    }

    public boolean showingOnlyFocused() {
        return this.showOnlyFocused;
    }

    public boolean isDebugInfoEnabled() {
        return this.enableDebugInfo;
    }

    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    public Set<String> getBosses() {
        return this.bosses;
    }

    public void toggleDraw() {
        this.draw = !this.draw;
    }
}

