/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.orderly.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import io.github.prospector.orderly.Orderly;
import io.github.prospector.orderly.config.OrderlyConfig;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.util.Supplier;

public class OrderlyConfigManager {
    private static final Executor EXECUTOR = Executors.newSingleThreadExecutor(r -> new Thread(r, "Orderly Config Manager"));
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static OrderlyConfig config;
    private static Path configFile;

    public static OrderlyConfig getConfig() {
        return config != null ? config : OrderlyConfigManager.init();
    }

    public static OrderlyConfig init() {
        configFile = FabricLoader.getInstance().getConfigDirectory().toPath().resolve("orderly.json");
        if (!Files.exists(configFile, new LinkOption[0])) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = configFile::getFileName;
            Orderly.getLogger().info("creating orderly config file ({})", supplierArray);
            OrderlyConfigManager.save().join();
        }
        ((CompletableFuture)OrderlyConfigManager.load().thenApply(c -> {
            config = c;
            return config;
        })).join();
        return Objects.requireNonNull(config, "failed to init config");
    }

    public static CompletableFuture<OrderlyConfig> load() {
        return CompletableFuture.supplyAsync(() -> {
            try (BufferedReader reader = Files.newBufferedReader(configFile);){
                OrderlyConfig orderlyConfig = (OrderlyConfig)GSON.fromJson((Reader)reader, OrderlyConfig.class);
                return orderlyConfig;
            }
            catch (JsonParseException | IOException e) {
                Orderly.getLogger().error("unable to read config file, restoring defaults!", e);
                OrderlyConfigManager.save();
                return new OrderlyConfig();
            }
        }, EXECUTOR);
    }

    public static CompletableFuture<Void> save() {
        Orderly.getLogger().trace("saving orderly config file to {}", (Object)configFile);
        return CompletableFuture.runAsync(() -> {
            try (BufferedWriter writer = Files.newBufferedWriter(configFile, new OpenOption[0]);){
                GSON.toJson((Object)Optional.ofNullable(config).orElseGet(OrderlyConfig::new), (Appendable)writer);
            }
            catch (JsonIOException | IOException e) {
                Orderly.getLogger().error("unable to write config file", e);
            }
        }, EXECUTOR);
    }
}

