/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import net.minecraft.class_1059;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4604;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private class_310 mc;
    private WorldRendererSchematic worldRenderer;
    private class_4604 frustum;
    private int frameCount;
    private long finishTimeNano;
    private boolean renderCollidingSchematicBlocks;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewisePrepared;
    private boolean translucentSchematic;

    private LitematicaRenderer() {
    }

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = class_310.method_1551();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().loadRenderers();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsTarget = 60L;
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsTarget / 2L, 0L);
    }

    public void renderSchematicWorld(class_4587 matrices, class_1159 matrix, float partialTicks) {
        if (!this.mc.field_1743) {
            this.mc.method_16011().method_15396("litematica_schematic_world_render");
            if (this.mc.method_1560() == null) {
                this.mc.method_1504((class_1297)this.mc.field_1724);
            }
            RenderSystem.pushMatrix();
            RenderSystem.enableDepthTest();
            this.calculateFinishTime();
            this.renderWorld(matrices, matrix, partialTicks, this.finishTimeNano);
            this.cleanup();
            RenderSystem.popMatrix();
            this.mc.method_16011().method_15407();
        }
    }

    private void renderWorld(class_4587 matrices, class_1159 matrix, float partialTicks, long finishTimeNano) {
        this.mc.method_16011().method_15396("culling");
        RenderSystem.shadeModel((int)7425);
        class_4184 camera = this.getCamera();
        class_243 cameraPos = camera.method_19326();
        double x = cameraPos.field_1352;
        double y = cameraPos.field_1351;
        double z = cameraPos.field_1350;
        class_4604 frustum = new class_4604(matrices.method_23760().method_23761(), matrix);
        frustum.method_23088(x, y, z);
        this.mc.method_16011().method_15405("prepare_terrain");
        this.mc.method_1531().method_22813(class_1059.field_5275);
        RenderUtils.disableDiffuseLighting();
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        this.mc.method_16011().method_15405("terrain_setup");
        worldRenderer.setupTerrain(camera, frustum, this.frameCount++, this.mc.field_1724.method_7325());
        this.mc.method_16011().method_15405("update_chunks");
        worldRenderer.updateChunks(finishTimeNano);
        this.mc.method_16011().method_15405("terrain");
        RenderSystem.matrixMode((int)5888);
        RenderSystem.disableAlphaTest();
        if (Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
            RenderSystem.pushMatrix();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.2f, (float)-0.4f);
            }
            this.startShaderIfEnabled();
            RenderUtils.setupBlend();
            worldRenderer.renderBlockLayer(class_1921.method_23577(), matrices, camera);
            worldRenderer.renderBlockLayer(class_1921.method_23579(), matrices, camera);
            worldRenderer.renderBlockLayer(class_1921.method_23581(), matrices, camera);
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            RenderSystem.disableBlend();
            RenderSystem.shadeModel((int)7424);
            RenderSystem.alphaFunc((int)516, (float)0.01f);
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            this.mc.method_16011().method_15405("entities");
            RenderSystem.pushMatrix();
            RenderUtils.enableDiffuseLightingForLevel((class_4587)matrices);
            RenderUtils.setupBlend();
            worldRenderer.renderEntities(camera, frustum, matrices, partialTicks);
            RenderSystem.disableFog();
            RenderSystem.disableBlend();
            RenderUtils.disableDiffuseLighting();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.popMatrix();
            RenderSystem.enableCull();
            RenderSystem.alphaFunc((int)516, (float)0.1f);
            this.mc.method_1531().method_22813(class_1059.field_5275);
            RenderSystem.shadeModel((int)7425);
            this.mc.method_16011().method_15405("translucent");
            RenderSystem.depthMask((boolean)false);
            RenderSystem.pushMatrix();
            RenderUtils.setupBlend();
            worldRenderer.renderBlockLayer(class_1921.method_23583(), matrices, camera);
            RenderSystem.popMatrix();
            this.disableShader();
        }
        this.mc.method_16011().method_15405("overlay");
        this.renderSchematicOverlay(matrices);
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableCull();
        this.mc.method_16011().method_15407();
    }

    public void renderSchematicOverlay(class_4587 matrices) {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            RenderSystem.pushMatrix();
            RenderSystem.disableTexture();
            RenderSystem.disableCull();
            RenderSystem.alphaFunc((int)516, (float)0.001f);
            RenderSystem.enablePolygonOffset();
            RenderSystem.polygonOffset((float)-0.4f, (float)-0.8f);
            RenderSystem.lineWidth((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.glMultiTexCoord2f((int)33985, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                RenderSystem.disableDepthTest();
            } else {
                RenderSystem.enableDepthTest();
            }
            this.getWorldRenderer().renderBlockOverlays(matrices, this.getCamera());
            RenderSystem.enableDepthTest();
            RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
            RenderSystem.disablePolygonOffset();
            RenderSystem.enableTexture();
            RenderSystem.popMatrix();
        }
    }

    public void startShaderIfEnabled() {
        this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (this.translucentSchematic) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)alpha);
        }
    }

    public void disableShader() {
        if (this.translucentSchematic) {
            GL20.glUseProgram((int)0);
        }
    }

    public void piecewisePrepareAndUpdate(class_4604 frustum) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.method_1560() != null;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
        if (this.renderPiecewise && frustum != null) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.renderCollidingSchematicBlocks = Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.method_16011().method_15396("litematica_culling");
            this.calculateFinishTime();
            WorldRendererSchematic worldRenderer = this.getWorldRenderer();
            this.mc.method_16011().method_15405("litematica_terrain_setup");
            worldRenderer.setupTerrain(this.getCamera(), frustum, this.frameCount++, this.mc.field_1724.method_7325());
            this.mc.method_16011().method_15405("litematica_update_chunks");
            worldRenderer.updateChunks(this.finishTimeNano);
            this.mc.method_16011().method_15407();
            this.frustum = frustum;
            this.renderPiecewisePrepared = true;
        }
    }

    public void piecewiseRenderSolid(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_solid");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23577(), matrices, this.getCamera());
            this.disableShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutoutMipped(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout_mipped");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23579(), matrices, this.getCamera());
            this.disableShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderCutout(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_blocks_cutout");
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.enablePolygonOffset();
                RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderBlockLayer(class_1921.method_23581(), matrices, this.getCamera());
            this.disableShader();
            if (this.renderCollidingSchematicBlocks) {
                RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                RenderSystem.disablePolygonOffset();
            }
            this.mc.method_16011().method_15407();
        }
    }

    public void piecewiseRenderTranslucent(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewisePrepared) {
            if (this.renderPiecewiseBlocks) {
                this.mc.method_16011().method_15396("litematica_translucent");
                if (this.renderCollidingSchematicBlocks) {
                    RenderSystem.enablePolygonOffset();
                    RenderSystem.polygonOffset((float)-0.3f, (float)-0.6f);
                }
                this.startShaderIfEnabled();
                this.getWorldRenderer().renderBlockLayer(class_1921.method_23583(), matrices, this.getCamera());
                this.disableShader();
                if (this.renderCollidingSchematicBlocks) {
                    RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
                    RenderSystem.disablePolygonOffset();
                }
                this.mc.method_16011().method_15407();
            }
            if (this.renderPiecewiseSchematic) {
                this.mc.method_16011().method_15396("litematica_overlay");
                this.renderSchematicOverlay(matrices);
                this.mc.method_16011().method_15407();
            }
            this.cleanup();
        }
    }

    public void piecewiseRenderEntities(class_4587 matrices, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.method_16011().method_15396("litematica_entities");
            RenderUtils.setupBlend();
            this.startShaderIfEnabled();
            this.getWorldRenderer().renderEntities(this.getCamera(), this.frustum, matrices, partialTicks);
            this.disableShader();
            RenderSystem.disableBlend();
            this.mc.method_16011().method_15407();
        }
    }

    private class_4184 getCamera() {
        return this.mc.field_1773.method_19418();
    }

    private void cleanup() {
        this.renderPiecewise = false;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        GL20.glUseProgram((int)program);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)program, (CharSequence)"texture"), (int)0);
        GL20.glUseProgram((int)0);
    }
}

