/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4696;
import net.minecraft.class_638;
import net.minecraft.class_824;
import net.minecraft.class_827;

public class ChunkRendererSchematicVbo {
    public static int schematicRenderChunksUpdated;
    protected volatile WorldSchematic world;
    protected final WorldRendererSchematic worldRenderer;
    protected final ReentrantLock chunkRenderLock;
    protected final ReentrantLock chunkRenderDataLock;
    protected final Set<class_2586> setBlockEntities = new HashSet<class_2586>();
    protected final class_2338.class_2339 position;
    protected final class_2338.class_2339 chunkRelativePos;
    protected final Map<class_1921, class_291> vertexBufferBlocks;
    protected final class_291[] vertexBufferOverlay;
    protected final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    protected final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private class_238 boundingBox;
    protected Color4f overlayColor;
    protected boolean hasOverlay = false;
    protected ChunkCacheSchematic schematicWorldView;
    protected ChunkCacheSchematic clientWorldView;
    protected ChunkRenderTaskSchematic compileTask;
    protected ChunkRenderDataSchematic chunkRenderData;
    private boolean needsUpdate;
    private boolean needsImmediateUpdate;

    public ChunkRendererSchematicVbo(WorldSchematic world, WorldRendererSchematic worldRenderer) {
        this.world = world;
        this.worldRenderer = worldRenderer;
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.chunkRenderLock = new ReentrantLock();
        this.chunkRenderDataLock = new ReentrantLock();
        this.vertexBufferBlocks = new HashMap<class_1921, class_291>();
        this.vertexBufferOverlay = new class_291[OverlayRenderType.values().length];
        this.position = new class_2338.class_2339();
        this.chunkRelativePos = new class_2338.class_2339();
        for (class_1921 layer : class_1921.method_22720()) {
            this.vertexBufferBlocks.put(layer, new class_291(class_290.field_1590));
        }
        for (int i = 0; i < OverlayRenderType.values().length; ++i) {
            this.vertexBufferOverlay[i] = new class_291(class_290.field_1576);
        }
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    public class_291 getBlocksVertexBufferByLayer(class_1921 layer) {
        return this.vertexBufferBlocks.get(layer);
    }

    public class_291 getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay[type.ordinal()];
    }

    public ChunkRenderDataSchematic getChunkRenderData() {
        return this.chunkRenderData;
    }

    public void setChunkRenderData(ChunkRenderDataSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.chunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public class_2338 getOrigin() {
        return this.position;
    }

    public class_238 getBoundingBox() {
        if (this.boundingBox == null) {
            int x = this.position.method_10263();
            int y = this.position.method_10264();
            int z = this.position.method_10260();
            this.boundingBox = new class_238((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
        }
        return this.boundingBox;
    }

    public void setPosition(int x, int y, int z) {
        if (x != this.position.method_10263() || y != this.position.method_10264() || z != this.position.method_10260()) {
            this.clear();
            this.position.method_10103(x, y, z);
            this.boundingBox = new class_238((double)x, (double)y, (double)z, (double)(x + 16), (double)(y + 16), (double)(z + 16));
        }
    }

    protected double getDistanceSq() {
        class_1297 entity = EntityUtils.getCameraEntity();
        double x = (double)this.position.method_10263() + 8.0 - entity.method_23317();
        double y = (double)this.position.method_10264() + 8.0 - entity.method_23318();
        double z = (double)this.position.method_10260() + 8.0 - entity.method_23321();
        return x * x + y * y + z * z;
    }

    public void deleteGlResources() {
        this.clear();
        this.world = null;
        this.vertexBufferBlocks.values().forEach(buf -> buf.close());
        for (int i = 0; i < this.vertexBufferOverlay.length; ++i) {
            if (this.vertexBufferOverlay[i] == null) continue;
            this.vertexBufferOverlay[i].close();
        }
    }

    public void resortTransparency(ChunkRenderTaskSchematic task) {
        OverlayRenderType type;
        class_1921 layerTranslucent = class_1921.method_23583();
        ChunkRenderDataSchematic data = task.getChunkRenderData();
        BufferBuilderCache buffers = task.getBufferCache();
        class_287.class_288 bufferState = data.getBlockBufferState(layerTranslucent);
        class_243 cameraPos = task.getCameraPosSupplier().get();
        float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
        float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
        float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
        if (bufferState != null && !data.isBlockLayerEmpty(layerTranslucent)) {
            class_287 buffer = buffers.getBlockBufferByLayer(layerTranslucent);
            this.preRenderBlocks(buffer);
            buffer.method_1324(bufferState);
            this.postRenderBlocks(layerTranslucent, x, y, z, buffer, data);
        }
        if ((bufferState = data.getOverlayBufferState(type = OverlayRenderType.QUAD)) != null && !data.isOverlayTypeEmpty(type)) {
            class_287 buffer = buffers.getOverlayBuffer(type);
            this.preRenderOverlay(buffer, type.getGlMode());
            buffer.method_1324(bufferState);
            this.postRenderOverlay(type, x, y, z, buffer, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(ChunkRenderTaskSchematic task) {
        ChunkRenderDataSchematic data = new ChunkRenderDataSchematic();
        task.getLock().lock();
        try {
            if (task.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            task.setChunkRenderData(data);
        }
        finally {
            task.getLock().unlock();
        }
        HashSet<class_2586> tileEntities = new HashSet<class_2586>();
        class_2338.class_2339 posChunk = this.position;
        LayerRange range = DataManager.getRenderLayerRange();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersects(new SubChunkPos(posChunk.method_10263() >> 4, posChunk.method_10264() >> 4, posChunk.method_10260() >> 4)))) {
                ++schematicRenderChunksUpdated;
                class_243 cameraPos = task.getCameraPosSupplier().get();
                float x = (float)cameraPos.field_1352 - (float)this.position.method_10263();
                float y = (float)cameraPos.field_1351 - (float)this.position.method_10264();
                float z = (float)cameraPos.field_1350 - (float)this.position.method_10260();
                HashSet<class_1921> usedLayers = new HashSet<class_1921>();
                BufferBuilderCache buffers = task.getBufferCache();
                class_4587 matrices = new class_4587();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    class_2338 posFrom = new class_2338(box.minX, box.minY, box.minZ);
                    class_2338 posTo = new class_2338(box.maxX, box.maxY, box.maxZ);
                    for (class_2338 posMutable : class_2338.class_2339.method_10097((class_2338)posFrom, (class_2338)posTo)) {
                        matrices.method_22903();
                        matrices.method_22904((double)(posMutable.method_10263() & 0xF), (double)(posMutable.method_10264() & 0xF), (double)(posMutable.method_10260() & 0xF));
                        this.renderBlocksAndOverlay(posMutable, data, tileEntities, usedLayers, matrices, buffers);
                        matrices.method_22909();
                    }
                }
                for (class_1921 layerTmp : class_1921.method_22720()) {
                    if (usedLayers.contains(layerTmp)) {
                        data.setBlockLayerUsed(layerTmp);
                    }
                    if (!data.isBlockLayerStarted(layerTmp)) continue;
                    this.postRenderBlocks(layerTmp, x, y, z, buffers.getBlockBufferByLayer(layerTmp), data);
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        data.setOverlayTypeUsed(type);
                        this.postRenderOverlay(type, x, y, z, buffers.getOverlayBuffer(type), data);
                    }
                }
            }
        }
        this.chunkRenderLock.lock();
        try {
            HashSet set = Sets.newHashSet(tileEntities);
            HashSet set1 = Sets.newHashSet(this.setBlockEntities);
            set.removeAll(this.setBlockEntities);
            set1.removeAll(tileEntities);
            this.setBlockEntities.clear();
            this.setBlockEntities.addAll(tileEntities);
            this.worldRenderer.updateBlockEntities(set1, set);
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        data.setTimeBuilt(this.world.method_8510());
    }

    protected void renderBlocksAndOverlay(class_2338 pos, ChunkRenderDataSchematic data, Set<class_2586> tileEntities, Set<class_1921> usedLayers, class_4587 matrices, BufferBuilderCache buffers) {
        class_2680 stateSchematic = this.schematicWorldView.method_8320(pos);
        class_2680 stateClient = this.clientWorldView.method_8320(pos);
        class_2248 blockSchematic = stateSchematic.method_11614();
        boolean clientHasAir = stateClient.method_11588();
        boolean schematicHasAir = stateSchematic.method_11588();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            class_287 bufferSchematic;
            class_1921 layer;
            if (blockSchematic.method_9570()) {
                this.addBlockEntity(pos, data, tileEntities);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            class_3610 fluidState = stateSchematic.method_11618();
            if (!fluidState.method_15769()) {
                layer = class_4696.method_23680((class_3610)fluidState);
                bufferSchematic = buffers.getBlockBufferByLayer(layer);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic);
                }
                if (this.worldRenderer.renderFluid(this.schematicWorldView, fluidState, pos, bufferSchematic)) {
                    usedLayers.add(layer);
                }
            }
            if (stateSchematic.method_11610() != class_2464.field_11455) {
                layer = translucent ? class_1921.method_23583() : class_4696.method_23679((class_2680)stateSchematic);
                bufferSchematic = buffers.getBlockBufferByLayer(layer);
                if (!data.isBlockLayerStarted(layer)) {
                    data.setBlockLayerStarted(layer);
                    this.preRenderBlocks(bufferSchematic);
                }
                if (this.worldRenderer.renderBlock(this.schematicWorldView, stateSchematic, pos, matrices, bufferSchematic)) {
                    usedLayers.add(layer);
                }
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, data, buffers);
            }
        }
    }

    protected void renderOverlay(OverlayType type, class_2338 pos, class_2680 stateSchematic, boolean missing, ChunkRenderDataSchematic data, BufferBuilderCache buffers) {
        class_1087 bakedModel;
        class_2338.class_2339 relPos = this.getChunkRelativePosition(pos);
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            class_287 bufferOverlayQuads = buffers.getOverlayBuffer(OverlayRenderType.QUAD);
            if (!data.isOverlayTypeStarted(OverlayRenderType.QUAD)) {
                data.setOverlayTypeStarted(OverlayRenderType.QUAD);
                this.preRenderOverlay(bufferOverlayQuads, OverlayRenderType.QUAD);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                for (int i = 0; i < 6; ++i) {
                    class_2350 side = PositionUtils.FACING_ALL[i];
                    posMutable.method_10103(pos.method_10263() + side.method_10148(), pos.method_10264() + side.method_10164(), pos.method_10260() + side.method_10165());
                    class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                    class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        class_1087 bakedModel2 = this.worldRenderer.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && class_2248.method_9501((class_265)stateSchematic.method_11628((class_1922)this.schematicWorldView, pos), (class_2350)side)) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, (class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    RenderUtils.drawBlockBoxSideBatchedQuads((class_2338)relPos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((class_2338)relPos, (Color4f)this.overlayColor, (double)0.0, (class_287)bufferOverlayQuads);
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            class_287 bufferOverlayOutlines = buffers.getOverlayBuffer(OverlayRenderType.OUTLINE);
            if (!data.isOverlayTypeStarted(OverlayRenderType.OUTLINE)) {
                data.setOverlayTypeStarted(OverlayRenderType.OUTLINE);
                this.preRenderOverlay(bufferOverlayOutlines, OverlayRenderType.OUTLINE);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                class_2338.class_2339 posMutable = new class_2338.class_2339();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.method_10103(pos.method_10263() + x - 1, pos.method_10264() + y - 1, pos.method_10260() + z - 1);
                                class_2680 adjStateSchematic = this.schematicWorldView.method_8320((class_2338)posMutable);
                                class_2680 adjStateClient = this.clientWorldView.method_8320((class_2338)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    class_1087 bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                    if (stateSchematic.method_11619()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel, stateSchematic, (class_2338)relPos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)relPos, (Color4f)this.overlayColor, (double)0.0, (class_287)bufferOverlayOutlines);
            }
        }
    }

    protected class_2338.class_2339 getChunkRelativePosition(class_2338 pos) {
        return this.chunkRelativePos.method_10103(pos.method_10263() & 0xF, pos.method_10264() & 0xF, pos.method_10260() & 0xF);
    }

    protected void renderOverlayReducedEdges(class_2338 pos, OverlayType[][][] adjTypes, OverlayType typeSelf, class_287 bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        class_2382[] neighborPositions = new class_2382[4];
        int lines = 0;
        for (class_2350.class_2351 axis : PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                class_2382[] offsets = PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    class_2382 offset = offsets[i];
                    OverlayType type = adjTypes[offset.method_10263() + 1][offset.method_10264() + 1][offset.method_10260() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new class_2382(pos.method_10263() + offset.method_10263(), pos.method_10264() + offset.method_10264(), pos.method_10260() + offset.method_10260());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                class_2382 posTmp = new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    class_2382 tmp = neighborPositions[i];
                    if (tmp.method_10263() > posTmp.method_10263() || tmp.method_10264() > posTmp.method_10264() || tmp.method_10260() > posTmp.method_10260()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.method_10263() != pos.method_10263() || posTmp.method_10264() != pos.method_10264() || posTmp.method_10260() != pos.method_10260()) continue;
                RenderUtils.drawBlockBoxEdgeBatchedLines((class_2338)this.getChunkRelativePosition(pos), axis, corner, this.overlayColor, bufferOverlayOutlines);
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(class_2680 stateSchematic, class_2680 stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.method_11588();
        boolean schematicHasAir = stateSchematic.method_11588();
        if (schematicHasAir) {
            return clientHasAir ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.method_11614() != stateClient.method_11614()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addBlockEntity(class_2338 pos, ChunkRenderDataSchematic chunkRenderData, Set<class_2586> blockEntities) {
        class_827 tesr;
        class_2586 te = this.schematicWorldView.getBlockEntity(pos, class_2818.class_2819.field_12859);
        if (te != null && (tesr = class_824.field_4346.method_3550(te)) != null) {
            chunkRenderData.addBlockEntity(te);
            if (tesr.method_3563(te)) {
                blockEntities.add(te);
            }
        }
    }

    private void preRenderBlocks(class_287 buffer) {
        buffer.method_1328(7, class_290.field_1590);
    }

    private void postRenderBlocks(class_1921 layer, float x, float y, float z, class_287 buffer, ChunkRenderDataSchematic chunkRenderData) {
        if (layer == class_1921.method_23583() && !chunkRenderData.isBlockLayerEmpty(layer)) {
            buffer.method_1341(x, y, z);
            chunkRenderData.setBlockBufferState(layer, buffer.method_1334());
        }
        buffer.method_1326();
    }

    private void preRenderOverlay(class_287 buffer, OverlayRenderType type) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        buffer.method_1328(type.getGlMode(), class_290.field_1576);
    }

    private void preRenderOverlay(class_287 buffer, int glMode) {
        buffer.method_1328(glMode, class_290.field_1576);
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, class_287 buffer, ChunkRenderDataSchematic chunkRenderData) {
        if (type == OverlayRenderType.QUAD && !chunkRenderData.isOverlayTypeEmpty(type)) {
            buffer.method_1341(x, y, z);
            chunkRenderData.setOverlayBufferState(type, buffer.method_1334());
        }
        buffer.method_1326();
    }

    public ChunkRenderTaskSchematic makeCompileTaskChunkSchematic(Supplier<class_243> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        ChunkRenderTaskSchematic generator = null;
        try {
            this.finishCompileTask();
            this.rebuildWorldView();
            generator = this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, cameraPosSupplier, this.getDistanceSq());
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return generator;
    }

    @Nullable
    public ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic(Supplier<class_243> cameraPosSupplier) {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, cameraPosSupplier, this.getDistanceSq());
                this.compileTask.setChunkRenderData(this.chunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
        return null;
    }

    protected void finishCompileTask() {
        this.chunkRenderLock.lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.chunkRenderLock.unlock();
        }
    }

    public ReentrantLock getLockCompileTask() {
        return this.chunkRenderLock;
    }

    public void clear() {
        this.finishCompileTask();
        this.chunkRenderData = ChunkRenderDataSchematic.EMPTY;
        this.needsUpdate = true;
    }

    public void setNeedsUpdate(boolean immediate) {
        if (this.needsUpdate) {
            immediate |= this.needsImmediateUpdate;
        }
        this.needsUpdate = true;
        this.needsImmediateUpdate = immediate;
    }

    public void clearNeedsUpdate() {
        this.needsUpdate = false;
        this.needsImmediateUpdate = false;
    }

    public boolean needsUpdate() {
        return this.needsUpdate;
    }

    public boolean needsImmediateUpdate() {
        return this.needsUpdate && this.needsImmediateUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            class_638 worldClient = class_310.method_1551().field_1687;
            this.schematicWorldView = new ChunkCacheSchematic(this.world, worldClient, (class_2338)this.position, 2);
            this.clientWorldView = new ChunkCacheSchematic(worldClient, worldClient, (class_2338)this.position, 2);
            class_2338.class_2339 pos = this.position;
            SubChunkPos subChunk = new SubChunkPos(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
            this.boxes.clear();
            this.boxes.addAll(DataManager.getSchematicPlacementManager().getTouchedBoxesInSubChunk(subChunk));
        }
    }

    public static enum OverlayRenderType {
        OUTLINE(1),
        QUAD(7);

        private final int glMode;

        private OverlayRenderType(int glMode) {
            this.glMode = glMode;
        }

        public int getGlMode() {
            return this.glMode;
        }
    }
}

