/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;

public abstract class TaskProcessChunkBase
extends TaskBase {
    protected final ArrayListMultimap<class_1923, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final Set<class_1923> requiredChunks = new HashSet<class_1923>();
    protected final class_638 worldClient;
    protected final class_1937 world;
    protected final boolean isClientWorld;

    protected TaskProcessChunkBase(String nameOnHud) {
        this.worldClient = this.mc.field_1687;
        this.world = WorldUtils.getBestWorld((class_310)this.mc);
        this.isClientWorld = this.world == this.mc.field_1687;
        this.name = StringUtils.translate((String)nameOnHud, (Object[])new Object[0]);
        InfoHud.getInstance().addInfoHudRenderer(this, true);
    }

    @Override
    public boolean execute() {
        if (this.worldClient != null) {
            Iterator<class_1923> iter = this.requiredChunks.iterator();
            int processed = 0;
            while (iter.hasNext()) {
                class_1923 pos = iter.next();
                if (!this.canProcessChunk(pos)) continue;
                this.processChunk(pos);
                iter.remove();
                ++processed;
            }
            if (processed > 0) {
                this.updateInfoHudLinesMissingChunks(this.requiredChunks);
            }
        }
        this.finished = this.requiredChunks.isEmpty();
        return this.finished;
    }

    @Override
    public void stop() {
        if (this.isClientWorld) {
            this.onStop();
        } else {
            this.mc.execute(new Runnable(){

                @Override
                public void run() {
                    TaskProcessChunkBase.this.onStop();
                }
            });
        }
    }

    protected void onStop() {
        this.notifyListener();
    }

    protected abstract boolean canProcessChunk(class_1923 var1);

    protected abstract boolean processChunk(class_1923 var1);

    protected void addBoxesPerChunks(Collection<Box> allBoxes) {
        this.boxesInChunks.clear();
        this.requiredChunks.clear();
        this.requiredChunks.addAll(PositionUtils.getTouchedChunksForBoxes(allBoxes));
        for (class_1923 pos : this.requiredChunks) {
            this.boxesInChunks.putAll((Object)pos, PositionUtils.getBoxesWithinChunk(pos.field_9181, pos.field_9180, allBoxes));
        }
    }

    protected List<IntBoundingBox> getBoxesInChunk(class_1923 pos) {
        return this.boxesInChunks.get((Object)pos);
    }
}

