/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3509;
import net.minecraft.class_631;
import net.minecraft.class_638;

public class ChunkProviderSchematic
extends class_631 {
    private final WorldSchematic world;
    private final Long2ObjectMap<ChunkSchematic> loadedChunks = new Long2ObjectOpenHashMap(8192);
    private final ChunkSchematic blankChunk;

    public ChunkProviderSchematic(WorldSchematic world) {
        super((class_638)world, 1);
        this.world = world;
        this.blankChunk = new ChunkSchematic((class_1937)world, new class_1923(0, 0));
    }

    public ChunkSchematic loadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = new ChunkSchematic((class_1937)this.world, new class_1923(chunkX, chunkZ));
        this.loadedChunks.put(class_1923.method_8331((int)chunkX, (int)chunkZ), (Object)chunk);
        return chunk;
    }

    public boolean method_12123(int chunkX, int chunkZ) {
        return this.loadedChunks.containsKey(class_1923.method_8331((int)chunkX, (int)chunkZ));
    }

    public Long2ObjectMap<ChunkSchematic> getLoadedChunks() {
        return this.loadedChunks;
    }

    public class_2818 method_2857(int chunkX, int chunkZ, class_2806 status, boolean fallbackToEmpty) {
        ChunkSchematic chunk = this.getChunk(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    @Nullable
    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.get(class_1923.method_8331((int)chunkX, (int)chunkZ)));
        return chunk == null ? this.blankChunk : chunk;
    }

    public void unloadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.remove(class_1923.method_8331((int)chunkX, (int)chunkZ)));
        if (chunk != null) {
            this.world.unloadBlockEntities(chunk.method_12214().values());
            for (class_3509 list : chunk.method_12215()) {
                for (class_1297 entity : list.method_15216(class_1297.class)) {
                    this.world.method_2945(entity.method_5628());
                }
            }
        }
    }
}

