/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import zabi.minecraft.nbttooltip.ConfigInstance;

public class ModConfig {
    public static boolean showSeparator;
    public static int maxLinesShown;
    public static boolean requiresf3;
    public static boolean showDelimiters;
    public static boolean compress;
    public static int ticksBeforeScroll;
    public static boolean ctrlSuppressesRest;
    private static File folder;
    private static Gson config;

    public static void init() {
        ModConfig.loadDefaults();
        ModConfig.generateFoldersAndFiles();
        ModConfig.readJson();
    }

    public static void loadDefaults() {
        maxLinesShown = 10;
        compress = false;
        requiresf3 = true;
        showDelimiters = true;
        showSeparator = true;
        ticksBeforeScroll = 20;
        ctrlSuppressesRest = true;
    }

    private static void generateFoldersAndFiles() {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (folder.isDirectory()) {
            File configFile = new File(folder, "NBTTooltip.config");
            if (!configFile.exists()) {
                try {
                    configFile.createNewFile();
                    ConfigInstance def = new ConfigInstance(showSeparator, maxLinesShown, requiresf3, showDelimiters, compress, ticksBeforeScroll, ctrlSuppressesRest);
                    String json = config.toJson((Object)def);
                    FileWriter writer = new FileWriter(configFile);
                    writer.write(json);
                    writer.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't create config file", e);
                }
            } else if (configFile.isDirectory()) {
                throw new IllegalStateException("'NBTTooltip.config' must be a file!");
            }
        } else {
            throw new IllegalStateException("'config' must be a folder!");
        }
    }

    public static void readJson() {
        File configFile = new File(folder, "NBTTooltip.config");
        try {
            ConfigInstance instance = (ConfigInstance)config.fromJson((Reader)new FileReader(configFile), ConfigInstance.class);
            if (instance == null) {
                throw new IllegalStateException("Null configuration");
            }
            showDelimiters = instance.showDelimiters;
            showSeparator = instance.showSeparator;
            ticksBeforeScroll = instance.ticksBeforeScroll;
            maxLinesShown = instance.maxLinesShown;
            compress = instance.compress;
            requiresf3 = instance.requiresf3;
            ctrlSuppressesRest = instance.ctrlSuppressesRest;
        }
        catch (JsonSyntaxException e) {
            System.err.println("Invalid configuration!");
            e.printStackTrace();
        }
        catch (JsonIOException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    static {
        folder = new File("config");
        config = new GsonBuilder().setPrettyPrinting().create();
    }
}

