/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.nbttooltip;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_437;
import zabi.minecraft.nbttooltip.ModConfig;

public class NBTTooltip
implements ModInitializer {
    public static int ticks = 0;
    public static int line_scrolled = 0;
    public static final String FORMAT = class_124.field_1056.toString() + class_124.field_1063;

    public void onInitialize() {
        ModConfig.init();
    }

    public static ArrayList<class_2561> transformTtip(ArrayList<class_2561> ttip, int lines) {
        ArrayList<class_2561> newttip = new ArrayList<class_2561>(lines);
        if (ModConfig.showSeparator) {
            newttip.add((class_2561)new class_2585("- NBTTooltip -"));
        }
        if (ttip.size() > lines) {
            if (lines + line_scrolled > ttip.size()) {
                line_scrolled = 0;
            }
            for (int i = 0; i < lines; ++i) {
                newttip.add(ttip.get(i + line_scrolled));
            }
            return newttip;
        }
        line_scrolled = 0;
        newttip.addAll(ttip);
        return newttip;
    }

    public static void unwrapTag(List<class_2561> tooltip, class_2520 base, String pad, String tagName, String padIncrement) {
        if (base instanceof class_2487) {
            class_2487 tag = (class_2487)base;
            tag.method_10541().forEach(s -> {
                boolean nested;
                boolean bl = nested = tag.method_10580(s) instanceof class_2483 || tag.method_10580(s) instanceof class_2487;
                if (nested) {
                    tooltip.add((class_2561)new class_2585(pad + s + ": {"));
                    NBTTooltip.unwrapTag(tooltip, tag.method_10580(s), pad + padIncrement, s, padIncrement);
                    tooltip.add((class_2561)new class_2585(pad + "}"));
                } else {
                    NBTTooltip.addValueToTooltip(tooltip, tag.method_10580(s), s, pad);
                }
            });
        } else if (base instanceof class_2483) {
            class_2483 tag = (class_2483)base;
            int index = 0;
            for (class_2520 nbtnext : tag) {
                if (nbtnext instanceof class_2483 || nbtnext instanceof class_2487) {
                    tooltip.add((class_2561)new class_2585(pad + "[" + index + "]: {"));
                    NBTTooltip.unwrapTag(tooltip, nbtnext, pad + padIncrement, "", padIncrement);
                    tooltip.add((class_2561)new class_2585(pad + "}"));
                } else {
                    tooltip.add((class_2561)new class_2585(pad + "[" + index + "] -> " + nbtnext.toString()));
                }
                ++index;
            }
        } else {
            NBTTooltip.addValueToTooltip(tooltip, base, tagName, pad);
        }
    }

    private static void addValueToTooltip(List<class_2561> tooltip, class_2520 nbt, String name, String pad) {
        tooltip.add((class_2561)new class_2585(pad + name + ": " + nbt.toString()));
    }

    public static void onInjectTooltip(Object stackIn, class_1937 world, List<class_2561> list, class_1836 context) {
        if (!ModConfig.requiresf3 || context.method_8035()) {
            class_1799 stack = (class_1799)stackIn;
            int lines = ModConfig.maxLinesShown;
            if (ModConfig.ctrlSuppressesRest && class_437.hasControlDown()) {
                lines += list.size();
                list.clear();
            } else {
                list.add((class_2561)new class_2585(""));
            }
            class_2487 tag = stack.method_7969();
            ArrayList<class_2561> ttip = new ArrayList<class_2561>(lines);
            if (tag != null) {
                if (ModConfig.showDelimiters) {
                    ttip.add((class_2561)new class_2585(class_124.field_1064 + " - nbt start -"));
                }
                if (ModConfig.compress) {
                    ttip.add((class_2561)new class_2585(FORMAT + tag.toString()));
                } else {
                    NBTTooltip.unwrapTag(ttip, (class_2520)tag, FORMAT, "", ModConfig.compress ? "" : "  ");
                }
                if (ModConfig.showDelimiters) {
                    ttip.add((class_2561)new class_2585(class_124.field_1064 + " - nbt end -"));
                }
                ttip = NBTTooltip.transformTtip(ttip, lines);
                list.addAll(ttip);
            } else {
                list.add((class_2561)new class_2585(FORMAT + "No NBT tag"));
            }
        }
    }
}

