/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools;

import net.fabricmc.loader.util.sat4j.core.VecInt;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.specs.TimeoutException;

public class Backbone {
    private Backbone() {
    }

    public static IVecInt compute(ISolver solver) throws TimeoutException {
        return Backbone.compute(solver, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver solver, IVecInt assumptions) throws TimeoutException {
        boolean result = solver.isSatisfiable(assumptions);
        if (!result) {
            return VecInt.EMPTY;
        }
        return Backbone.compute(solver, solver.primeImplicant(), assumptions);
    }

    public static IVecInt compute(ISolver solver, int[] implicant) throws TimeoutException {
        return Backbone.compute(solver, implicant, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver solver, int[] implicant, IVecInt assumptions) throws TimeoutException {
        VecInt litsToTest = new VecInt();
        for (int p : implicant) {
            if (assumptions.contains(p)) continue;
            litsToTest.push(-p);
        }
        VecInt candidates = new VecInt();
        assumptions.copyTo(candidates);
        while (!litsToTest.isEmpty()) {
            int p = litsToTest.last();
            candidates.push(p);
            litsToTest.pop();
            if (solver.isSatisfiable(candidates)) {
                candidates.pop();
                implicant = solver.primeImplicant();
                Backbone.removeVarNotPresentAndSatisfiedLits(implicant, litsToTest, solver.nVars());
                continue;
            }
            candidates.pop().push(-p);
        }
        return candidates;
    }

    private static void removeVarNotPresentAndSatisfiedLits(int[] implicant, IVecInt litsToTest, int n) {
        int[] marks = new int[n + 1];
        int[] nArray = implicant;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int p;
            marks[(p = nArray[i]) > 0 ? p : -p] = p;
        }
        int i = 0;
        while (i < litsToTest.size()) {
            int q = litsToTest.get(i);
            int mark = marks[q > 0 ? q : -q];
            if (mark == 0 || mark == q) {
                litsToTest.delete(i);
                continue;
            }
            ++i;
        }
    }
}

