/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.util.sat4j.tools.encoding;

import net.fabricmc.loader.util.sat4j.specs.ContradictionException;
import net.fabricmc.loader.util.sat4j.specs.IConstr;
import net.fabricmc.loader.util.sat4j.specs.ISolver;
import net.fabricmc.loader.util.sat4j.specs.IVecInt;
import net.fabricmc.loader.util.sat4j.tools.encoding.Binary;
import net.fabricmc.loader.util.sat4j.tools.encoding.Binomial;
import net.fabricmc.loader.util.sat4j.tools.encoding.Commander;
import net.fabricmc.loader.util.sat4j.tools.encoding.EncodingStrategy;
import net.fabricmc.loader.util.sat4j.tools.encoding.EncodingStrategyAdapter;
import net.fabricmc.loader.util.sat4j.tools.encoding.Ladder;
import net.fabricmc.loader.util.sat4j.tools.encoding.Product;
import net.fabricmc.loader.util.sat4j.tools.encoding.Sequential;

public class Policy
extends EncodingStrategyAdapter {
    private static final long serialVersionUID = 1L;
    private final Sequential seq = new Sequential();
    private final Binary binary = new Binary();
    private final Product product = new Product();
    private final Commander commander = new Commander();
    private final Binomial binomial = new Binomial();
    private final Ladder ladder = new Ladder();
    private EncodingStrategyAdapter atMostOneEncoding = null;
    private EncodingStrategyAdapter atMostKEncoding = null;
    private EncodingStrategyAdapter exactlyOneEncoding = null;
    private EncodingStrategyAdapter exactlyKEncoding = null;
    private EncodingStrategyAdapter atLeastOneEncoding = null;
    private EncodingStrategyAdapter atLeastKEncoding = null;

    private EncodingStrategyAdapter getAdapterFromEncodingName(EncodingStrategy encodingName) {
        switch (encodingName) {
            case BINARY: {
                return this.binary;
            }
            case BINOMIAL: {
                return this.binomial;
            }
            case COMMANDER: {
                return this.commander;
            }
            case LADDER: {
                return this.ladder;
            }
            case PRODUCT: {
                return this.product;
            }
            case SEQUENTIAL: {
                return this.seq;
            }
        }
        return null;
    }

    private EncodingStrategy getEncodingTypeFromAdapter(EncodingStrategyAdapter adapter) {
        if (adapter instanceof Binary) {
            return EncodingStrategy.BINARY;
        }
        if (adapter instanceof Binomial) {
            return EncodingStrategy.BINOMIAL;
        }
        if (adapter instanceof Commander) {
            return EncodingStrategy.COMMANDER;
        }
        if (adapter instanceof Ladder) {
            return EncodingStrategy.LADDER;
        }
        if (adapter instanceof Product) {
            return EncodingStrategy.PRODUCT;
        }
        if (adapter instanceof Sequential) {
            return EncodingStrategy.SEQUENTIAL;
        }
        return EncodingStrategy.NATIVE;
    }

    public EncodingStrategyAdapter getAtMostOneEncoding() {
        return this.atMostOneEncoding;
    }

    public void setAtMostOneEncoding(EncodingStrategyAdapter atMostOneEncoding) {
        this.atMostOneEncoding = atMostOneEncoding;
    }

    public void setAtMostOneEncoding(EncodingStrategy atMostOneEncoding) {
        this.atMostOneEncoding = this.getAdapterFromEncodingName(atMostOneEncoding);
    }

    public EncodingStrategyAdapter getAtMostKEncoding() {
        return this.atMostKEncoding;
    }

    public void setAtMostKEncoding(EncodingStrategyAdapter atMostKEncoding) {
        this.atMostKEncoding = atMostKEncoding;
    }

    public void setAtMostKEncoding(EncodingStrategy atMostKEncoding) {
        this.atMostKEncoding = this.getAdapterFromEncodingName(atMostKEncoding);
    }

    public EncodingStrategyAdapter getExactlyOneEncoding() {
        return this.exactlyOneEncoding;
    }

    public void setExactlyOneEncoding(EncodingStrategyAdapter exactlyOneEncoding) {
        this.exactlyOneEncoding = exactlyOneEncoding;
    }

    public void setExactlyOneEncoding(EncodingStrategy exactlyOneEncoding) {
        this.exactlyOneEncoding = this.getAdapterFromEncodingName(exactlyOneEncoding);
    }

    public EncodingStrategyAdapter getExactlyKEncoding() {
        return this.exactlyKEncoding;
    }

    public void setExactlyKEncoding(EncodingStrategyAdapter exactlyKEncoding) {
        this.exactlyKEncoding = exactlyKEncoding;
    }

    public void setExactlyKEncoding(EncodingStrategy exactlyKEncoding) {
        this.exactlyKEncoding = this.getAdapterFromEncodingName(exactlyKEncoding);
    }

    public EncodingStrategyAdapter getAtLeastOneEncoding() {
        return this.atLeastOneEncoding;
    }

    public void setAtLeastOneEncoding(EncodingStrategyAdapter atLeastOneEncoding) {
        this.atLeastOneEncoding = atLeastOneEncoding;
    }

    public void setAtLeastOneEncoding(EncodingStrategy atLeastOneEncoding) {
        this.atLeastOneEncoding = this.getAdapterFromEncodingName(atLeastOneEncoding);
    }

    public EncodingStrategyAdapter getAtLeastKEncoding() {
        return this.atLeastKEncoding;
    }

    public void setAtLeastKEncoding(EncodingStrategyAdapter atLeastKEncoding) {
        this.atLeastKEncoding = atLeastKEncoding;
    }

    public void setAtLeastKEncoding(EncodingStrategy atLeastKEncoding) {
        this.atLeastKEncoding = this.getAdapterFromEncodingName(atLeastKEncoding);
    }

    public IConstr addAtMost(ISolver solver, IVecInt literals, int k) throws ContradictionException {
        if (k == 0 || literals.size() == 1) {
            return super.addAtMost(solver, literals, k);
        }
        if (literals.size() <= 1) {
            throw new UnsupportedOperationException("requires at least 2 literals");
        }
        if (k == 1 && this.atMostOneEncoding != null) {
            return this.atMostOneEncoding.addAtMostOne(solver, literals);
        }
        if (this.atMostKEncoding != null) {
            if (k == 1) {
                return this.atMostKEncoding.addAtMostOne(solver, literals);
            }
            return this.atMostKEncoding.addAtMost(solver, literals, k);
        }
        return super.addAtMost(solver, literals, k);
    }

    public IConstr addExactly(ISolver solver, IVecInt literals, int n) throws ContradictionException {
        if (n == 1 && this.exactlyOneEncoding != null) {
            return this.exactlyOneEncoding.addExactlyOne(solver, literals);
        }
        if (this.exactlyKEncoding != null) {
            if (n == 1) {
                return this.exactlyKEncoding.addExactlyOne(solver, literals);
            }
            return this.exactlyKEncoding.addExactly(solver, literals, n);
        }
        return super.addExactly(solver, literals, n);
    }

    public IConstr addAtLeast(ISolver solver, IVecInt literals, int n) throws ContradictionException {
        if (n == 1) {
            if (this.atLeastOneEncoding != null) {
                return this.atLeastOneEncoding.addAtLeastOne(solver, literals);
            }
        } else if (this.atLeastKEncoding != null) {
            return this.atLeastKEncoding.addAtLeast(solver, literals, n);
        }
        return super.addAtLeast(solver, literals, n);
    }

    public String toString() {
        String s = "";
        s = s + "Policy = [At most K: " + (Object)((Object)this.getEncodingTypeFromAdapter(this.getAtMostKEncoding())) + ", at most 1: " + (Object)((Object)this.getEncodingTypeFromAdapter(this.getAtMostOneEncoding())) + ", exactly K: " + (Object)((Object)this.getEncodingTypeFromAdapter(this.getExactlyKEncoding())) + ", exactly 1: " + (Object)((Object)this.getEncodingTypeFromAdapter(this.getExactlyOneEncoding())) + "]";
        return s;
    }
}

