/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.accesswidener.AccessWidener;
import net.fabricmc.accesswidener.AccessWidenerReader;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.EntrypointStorage;
import net.fabricmc.loader.FabricMappingResolver;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.fabricmc.loader.discovery.ClasspathModCandidateFinder;
import net.fabricmc.loader.discovery.DirectoryModCandidateFinder;
import net.fabricmc.loader.discovery.ModCandidate;
import net.fabricmc.loader.discovery.ModResolutionException;
import net.fabricmc.loader.discovery.ModResolver;
import net.fabricmc.loader.discovery.RuntimeModRemapper;
import net.fabricmc.loader.game.GameProvider;
import net.fabricmc.loader.gui.FabricGuiEntry;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.loader.launch.knot.Knot;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.util.DefaultLanguageAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabricLoader
implements net.fabricmc.loader.api.FabricLoader {
    @Deprecated
    public static final FabricLoader INSTANCE = new FabricLoader();
    public static final int ASM_VERSION = 589824;
    protected static Logger LOGGER = LogManager.getFormatterLogger((String)"Fabric|Loader");
    protected final Map<String, net.fabricmc.loader.ModContainer> modMap = new HashMap<String, net.fabricmc.loader.ModContainer>();
    protected List<net.fabricmc.loader.ModContainer> mods = new ArrayList<net.fabricmc.loader.ModContainer>();
    private final Map<String, LanguageAdapter> adapterMap = new HashMap<String, LanguageAdapter>();
    private final EntrypointStorage entrypointStorage = new EntrypointStorage();
    private final AccessWidener accessWidener = new AccessWidener();
    private boolean frozen = false;
    private Object gameInstance;
    private MappingResolver mappingResolver;
    private GameProvider provider;
    private Path gameDir;
    private Path configDir;

    protected FabricLoader() {
    }

    public void freeze() {
        if (this.frozen) {
            throw new RuntimeException("Already frozen!");
        }
        this.frozen = true;
        this.finishModLoading();
    }

    public GameProvider getGameProvider() {
        if (this.provider == null) {
            throw new IllegalStateException("game provider not set (yet)");
        }
        return this.provider;
    }

    public void setGameProvider(GameProvider provider) {
        this.provider = provider;
        this.setGameDir(provider.getLaunchDirectory());
    }

    private void setGameDir(Path gameDir) {
        this.gameDir = gameDir;
        this.configDir = gameDir.resolve("config");
    }

    @Override
    public Object getGameInstance() {
        return this.gameInstance;
    }

    @Override
    public EnvType getEnvironmentType() {
        return FabricLauncherBase.getLauncher().getEnvironmentType();
    }

    @Override
    public Path getGameDir() {
        return this.gameDir;
    }

    @Override
    @Deprecated
    public File getGameDirectory() {
        return this.getGameDir().toFile();
    }

    @Override
    public Path getConfigDir() {
        if (!Files.exists(this.configDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Creating config directory", e);
            }
        }
        return this.configDir;
    }

    @Override
    @Deprecated
    public File getConfigDirectory() {
        return this.getConfigDir().toFile();
    }

    public Path getModsDir() {
        return this.getGameDir().resolve("mods");
    }

    @Deprecated
    public File getModsDirectory() {
        return this.getModsDir().toFile();
    }

    private String join(Stream<String> strings, String joiner) {
        StringBuilder builder = new StringBuilder();
        AtomicInteger i = new AtomicInteger();
        ((Stream)strings.sequential()).forEach(s -> {
            if (i.getAndIncrement() > 0) {
                builder.append(joiner);
            }
            builder.append((String)s);
        });
        return builder.toString();
    }

    public void load() {
        if (this.provider == null) {
            throw new IllegalStateException("game provider not set");
        }
        if (this.frozen) {
            throw new IllegalStateException("Frozen - cannot load additional mods!");
        }
        try {
            this.setup();
        }
        catch (ModResolutionException exception) {
            FabricGuiEntry.displayCriticalError(exception, true);
        }
    }

    private void setup() throws ModResolutionException {
        String modText;
        ModResolver resolver = new ModResolver();
        resolver.addCandidateFinder(new ClasspathModCandidateFinder());
        resolver.addCandidateFinder(new DirectoryModCandidateFinder(this.getModsDir(), this.isDevelopmentEnvironment()));
        Map<String, ModCandidate> candidateMap = resolver.resolve(this);
        switch (candidateMap.values().size()) {
            case 0: {
                modText = "Loading %d mods";
                break;
            }
            case 1: {
                modText = "Loading %d mod: %s";
                break;
            }
            default: {
                modText = "Loading %d mods: %s";
            }
        }
        LOGGER.info("[" + this.getClass().getSimpleName() + "] " + modText, (Object)candidateMap.values().size(), (Object)candidateMap.values().stream().map(info -> String.format("%s@%s", info.getInfo().getId(), info.getInfo().getVersion().getFriendlyString())).collect(Collectors.joining(", ")));
        boolean runtimeModRemapping = this.isDevelopmentEnvironment();
        if (runtimeModRemapping && System.getProperty("fabric.remapClasspathFile") == null) {
            LOGGER.warn("Runtime mod remapping disabled due to no fabric.remapClasspathFile being specified. You may need to update loom.");
            runtimeModRemapping = false;
        }
        if (runtimeModRemapping) {
            for (ModCandidate candidate : RuntimeModRemapper.remap(candidateMap.values(), ModResolver.getInMemoryFs())) {
                this.addMod(candidate);
            }
        } else {
            for (ModCandidate candidate : candidateMap.values()) {
                this.addMod(candidate);
            }
        }
    }

    protected void finishModLoading() {
        for (net.fabricmc.loader.ModContainer mod : this.mods) {
            if (mod.getInfo().getId().equals("fabricloader")) continue;
            FabricLauncherBase.getLauncher().propose(mod.getOriginUrl());
        }
        this.postprocessModMetadata();
        this.setupLanguageAdapters();
        this.setupMods();
    }

    public boolean hasEntrypoints(String key) {
        return this.entrypointStorage.hasEntrypoints(key);
    }

    @Override
    public <T> List<T> getEntrypoints(String key, Class<T> type) {
        return this.entrypointStorage.getEntrypoints(key, type);
    }

    @Override
    public <T> List<EntrypointContainer<T>> getEntrypointContainers(String key, Class<T> type) {
        return this.entrypointStorage.getEntrypointContainers(key, type);
    }

    @Override
    public MappingResolver getMappingResolver() {
        if (this.mappingResolver == null) {
            this.mappingResolver = new FabricMappingResolver(FabricLauncherBase.getLauncher().getMappingConfiguration()::getMappings, FabricLauncherBase.getLauncher().getTargetNamespace());
        }
        return this.mappingResolver;
    }

    @Override
    public Optional<ModContainer> getModContainer(String id) {
        return Optional.ofNullable((ModContainer)this.modMap.get(id));
    }

    @Override
    public Collection<ModContainer> getAllMods() {
        return Collections.unmodifiableList(this.mods);
    }

    @Override
    public boolean isModLoaded(String id) {
        return this.modMap.containsKey(id);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return FabricLauncherBase.getLauncher().isDevelopment();
    }

    @Deprecated
    public Collection<net.fabricmc.loader.ModContainer> getModContainers() {
        return Collections.unmodifiableList(this.mods);
    }

    @Deprecated
    public List<net.fabricmc.loader.ModContainer> getMods() {
        return Collections.unmodifiableList(this.mods);
    }

    protected void addMod(ModCandidate candidate) throws ModResolutionException {
        LoaderModMetadata info = candidate.getInfo();
        URL originUrl = candidate.getOriginUrl();
        if (this.modMap.containsKey(info.getId())) {
            throw new ModResolutionException("Duplicate mod ID: " + info.getId() + "! (" + this.modMap.get(info.getId()).getOriginUrl().getFile() + ", " + originUrl.getFile() + ")");
        }
        if (!info.loadsInEnvironment(this.getEnvironmentType())) {
            return;
        }
        net.fabricmc.loader.ModContainer container = new net.fabricmc.loader.ModContainer(info, originUrl);
        this.mods.add(container);
        this.modMap.put(info.getId(), container);
        for (String provides : info.getProvides()) {
            if (this.modMap.containsKey(provides)) {
                throw new ModResolutionException("Duplicate provided alias: " + provides + "! (" + this.modMap.get(info.getId()).getOriginUrl().getFile() + ", " + originUrl.getFile() + ")");
            }
            this.modMap.put(provides, container);
        }
    }

    protected void postprocessModMetadata() {
        for (net.fabricmc.loader.ModContainer mod : this.mods) {
            if (!(mod.getInfo().getVersion() instanceof SemanticVersion)) {
                LOGGER.warn("Mod `" + mod.getInfo().getId() + "` (" + mod.getInfo().getVersion().getFriendlyString() + ") does not respect SemVer - comparison support is limited.");
                continue;
            }
            if (((SemanticVersion)mod.getInfo().getVersion()).getVersionComponentCount() < 4) continue;
            LOGGER.warn("Mod `" + mod.getInfo().getId() + "` (" + mod.getInfo().getVersion().getFriendlyString() + ") uses more dot-separated version components than SemVer allows; support for this is currently not guaranteed.");
        }
    }

    private void setupLanguageAdapters() {
        this.adapterMap.put("default", DefaultLanguageAdapter.INSTANCE);
        for (net.fabricmc.loader.ModContainer mod : this.mods) {
            for (Map.Entry<String, String> laEntry : mod.getInfo().getLanguageAdapterDefinitions().entrySet()) {
                if (this.adapterMap.containsKey(laEntry.getKey())) {
                    throw new RuntimeException("Duplicate language adapter key: " + laEntry.getKey() + "! (" + laEntry.getValue() + ", " + this.adapterMap.get(laEntry.getKey()).getClass().getName() + ")");
                }
                try {
                    this.adapterMap.put(laEntry.getKey(), (LanguageAdapter)Class.forName(laEntry.getValue(), true, FabricLauncherBase.getLauncher().getTargetClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to instantiate language adapter: " + laEntry.getKey(), e);
                }
            }
        }
    }

    private void setupMods() {
        for (net.fabricmc.loader.ModContainer mod : this.mods) {
            try {
                mod.setupRootPath();
                for (String in : mod.getInfo().getOldInitializers()) {
                    String adapter = mod.getInfo().getOldStyleLanguageAdapter();
                    this.entrypointStorage.addDeprecated(mod, adapter, in);
                }
                for (String key : mod.getInfo().getEntrypointKeys()) {
                    for (EntrypointMetadata in : mod.getInfo().getEntrypoints(key)) {
                        this.entrypointStorage.add(mod, key, in, this.adapterMap);
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to setup mod %s (%s)", mod.getInfo().getName(), mod.getOriginUrl().getFile()), e);
            }
        }
    }

    public void loadAccessWideners() {
        AccessWidenerReader accessWidenerReader = new AccessWidenerReader(this.accessWidener);
        for (ModContainer modContainer : this.getAllMods()) {
            LoaderModMetadata modMetadata = (LoaderModMetadata)modContainer.getMetadata();
            String accessWidener = modMetadata.getAccessWidener();
            if (accessWidener == null) continue;
            Path path = modContainer.getPath(accessWidener);
            try {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    accessWidenerReader.read(reader, this.getMappingResolver().getCurrentRuntimeNamespace());
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read accessWidener file from mod " + modMetadata.getId(), e);
            }
        }
    }

    public void prepareModInit(Path newRunDir, Object gameInstance) {
        if (!this.frozen) {
            throw new RuntimeException("Cannot instantiate mods when not frozen!");
        }
        if (gameInstance != null && FabricLauncherBase.getLauncher() instanceof Knot) {
            ClassLoader targetClassLoader;
            ClassLoader gameClassLoader = gameInstance.getClass().getClassLoader();
            boolean matchesKnot = gameClassLoader == (targetClassLoader = FabricLauncherBase.getLauncher().getTargetClassLoader());
            boolean containsKnot = false;
            if (matchesKnot) {
                containsKnot = true;
            } else {
                for (gameClassLoader = gameClassLoader.getParent(); gameClassLoader != null && gameClassLoader.getParent() != gameClassLoader; gameClassLoader = gameClassLoader.getParent()) {
                    if (gameClassLoader != targetClassLoader) continue;
                    containsKnot = true;
                }
            }
            if (!matchesKnot) {
                if (containsKnot) {
                    this.getLogger().info("Environment: Target class loader is parent of game class loader.");
                } else {
                    this.getLogger().warn("\n\n* CLASS LOADER MISMATCH! THIS IS VERY BAD AND WILL PROBABLY CAUSE WEIRD ISSUES! *\n - Expected game class loader: " + FabricLauncherBase.getLauncher().getTargetClassLoader() + "\n - Actual game class loader: " + gameClassLoader + "\nCould not find the expected class loader in game class loader parents!\n");
                }
            }
        }
        this.gameInstance = gameInstance;
        if (this.gameDir != null) {
            try {
                if (!this.gameDir.toRealPath(new LinkOption[0]).equals(newRunDir.toRealPath(new LinkOption[0]))) {
                    this.getLogger().warn("Inconsistent game execution directories: engine says " + newRunDir.toRealPath(new LinkOption[0]) + ", while initializer says " + this.gameDir.toRealPath(new LinkOption[0]) + "...");
                    this.setGameDir(newRunDir);
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Exception while checking game execution directory consistency!", (Throwable)e);
            }
        } else {
            this.setGameDir(newRunDir);
        }
    }

    public AccessWidener getAccessWidener() {
        return this.accessWidener;
    }

    public Logger getLogger() {
        return LOGGER;
    }

    @Deprecated
    public void setGameInstance(Object gameInstance) {
        if (this.getEnvironmentType() != EnvType.SERVER) {
            throw new UnsupportedOperationException("Cannot set game instance on a client!");
        }
        if (this.gameInstance != null) {
            throw new UnsupportedOperationException("Cannot overwrite current game instance!");
        }
        this.gameInstance = gameInstance;
    }

    @Override
    public String[] getLaunchArguments(boolean sanitize) {
        return this.getGameProvider().getLaunchArguments(sanitize);
    }
}

