/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.VersionPredicate;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.util.version.VersionPredicateParser;

final class ModDependencyImpl
implements ModDependency {
    private final String modId;
    private final List<String> matcherStringList;
    private Set<VersionPredicate> ranges;

    ModDependencyImpl(String modId, List<String> matcherStringList) {
        this.modId = modId;
        this.matcherStringList = matcherStringList;
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean matches(Version version) {
        for (String s : this.matcherStringList) {
            try {
                if (!VersionPredicateParser.matches(version, s)) continue;
                return true;
            }
            catch (VersionParsingException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append(this.modId);
        builder.append(" @ [");
        for (int i = 0; i < this.matcherStringList.size(); ++i) {
            if (i > 0) {
                builder.append(" || ");
            }
            builder.append(this.matcherStringList.get(i));
        }
        builder.append("]}");
        return builder.toString();
    }

    @Override
    public Set<VersionPredicate> getVersionRequirements() {
        if (this.ranges == null) {
            this.ranges = VersionPredicate.parse(this.matcherStringList);
        }
        return this.ranges;
    }
}

