/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.metadata.AbstractModMetadata;
import net.fabricmc.loader.metadata.EntrypointMetadata;
import net.fabricmc.loader.metadata.LoaderModMetadata;
import net.fabricmc.loader.metadata.NestedJarEntry;
import org.apache.logging.log4j.Logger;

final class V0ModMetadata
extends AbstractModMetadata
implements LoaderModMetadata {
    private static final Mixins EMPTY_MIXINS = new Mixins(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    private final String id;
    private final Version version;
    private final Map<String, ModDependency> requires;
    private final Map<String, ModDependency> conflicts;
    private final String languageAdapter = "net.fabricmc.loader.language.JavaLanguageAdapter";
    private final Mixins mixins;
    private final ModEnvironment environment;
    private final String initializer;
    private final Collection<String> initializers;
    private final String name;
    private final String description;
    private final Map<String, ModDependency> recommends;
    private final Collection<Person> authors;
    private final Collection<Person> contributors;
    private final ContactInformation links;
    private final String license;

    V0ModMetadata(String id, Version version, Map<String, ModDependency> requires, Map<String, ModDependency> conflicts, Mixins mixins, ModEnvironment environment, String initializer, Collection<String> initializers, String name, String description, Map<String, ModDependency> recommends, Collection<Person> authors, Collection<Person> contributors, ContactInformation links, String license) {
        this.id = id;
        this.version = version;
        this.requires = Collections.unmodifiableMap(requires);
        this.conflicts = Collections.unmodifiableMap(conflicts);
        this.mixins = mixins == null ? EMPTY_MIXINS : mixins;
        this.environment = environment;
        this.initializer = initializer;
        this.initializers = Collections.unmodifiableCollection(initializers);
        this.name = name;
        this.description = description == null ? "" : description;
        this.recommends = Collections.unmodifiableMap(recommends);
        this.authors = Collections.unmodifiableCollection(authors);
        this.contributors = contributors;
        this.links = links;
        this.license = license;
    }

    @Override
    public int getSchemaVersion() {
        return 0;
    }

    @Override
    public String getType() {
        return "fabric";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<String> getProvides() {
        return Collections.emptyList();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public ModEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public boolean loadsInEnvironment(EnvType type) {
        return this.environment.matches(type);
    }

    @Override
    public Collection<ModDependency> getDepends() {
        return this.requires.values();
    }

    @Override
    public Collection<ModDependency> getRecommends() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ModDependency> getSuggests() {
        return this.recommends.values();
    }

    @Override
    public Collection<ModDependency> getConflicts() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ModDependency> getBreaks() {
        return this.conflicts.values();
    }

    @Override
    public String getName() {
        if (this.name != null && this.name.isEmpty()) {
            return this.id;
        }
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Collection<Person> getAuthors() {
        return this.authors;
    }

    @Override
    public Collection<Person> getContributors() {
        return this.contributors;
    }

    @Override
    public ContactInformation getContact() {
        return this.links;
    }

    @Override
    public Collection<String> getLicense() {
        return Collections.singleton(this.license);
    }

    @Override
    public Optional<String> getIconPath(int size) {
        return Optional.of("assets/" + this.getId() + "/icon.png");
    }

    @Override
    public String getOldStyleLanguageAdapter() {
        return this.languageAdapter;
    }

    @Override
    public Map<String, CustomValue> getCustomValues() {
        return Collections.emptyMap();
    }

    @Override
    public boolean containsCustomValue(String key) {
        return false;
    }

    @Override
    public CustomValue getCustomValue(String key) {
        return null;
    }

    @Override
    public Map<String, String> getLanguageAdapterDefinitions() {
        return Collections.emptyMap();
    }

    @Override
    public Collection<NestedJarEntry> getJars() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getOldInitializers() {
        if (this.initializer != null) {
            return Collections.singletonList(this.initializer);
        }
        if (!this.initializers.isEmpty()) {
            return this.initializers;
        }
        return Collections.emptyList();
    }

    @Override
    public List<EntrypointMetadata> getEntrypoints(String type) {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getEntrypointKeys() {
        return Collections.emptyList();
    }

    @Override
    public void emitFormatWarnings(Logger logger) {
    }

    @Override
    public Collection<String> getMixinConfigs(EnvType type) {
        ArrayList<String> mixinConfigs = new ArrayList<String>(this.mixins.common);
        switch (type) {
            case CLIENT: {
                mixinConfigs.addAll(this.mixins.client);
                break;
            }
            case SERVER: {
                mixinConfigs.addAll(this.mixins.server);
            }
        }
        return mixinConfigs;
    }

    @Override
    public String getAccessWidener() {
        return null;
    }

    static final class Mixins {
        final Collection<String> client;
        final Collection<String> common;
        final Collection<String> server;

        private Mixins() {
            this.client = Collections.emptyList();
            this.common = Collections.emptyList();
            this.server = Collections.emptyList();
        }

        Mixins(Collection<String> client, Collection<String> common, Collection<String> server) {
            this.client = Collections.unmodifiableCollection(client);
            this.common = Collections.unmodifiableCollection(common);
            this.server = Collections.unmodifiableCollection(server);
        }
    }
}

