/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.tinyremapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.fabricmc.tinyremapper.NonClassCopyMode;
import net.fabricmc.tinyremapper.TinyRemapper;

public class OutputConsumerPath
implements BiConsumer<String, byte[]>,
Closeable {
    private static final String classSuffix = ".class";
    private final Path dstDir;
    private final boolean closeFs;
    private final boolean isJarFs;
    private final Lock lock;
    private final Predicate<String> classNameFilter;
    private boolean closed;

    @Deprecated
    public OutputConsumerPath(Path dstFile) throws IOException {
        this(dstFile, true);
    }

    @Deprecated
    public OutputConsumerPath(Path dstDir, boolean closeFs) throws IOException {
        this(dstDir, OutputConsumerPath.isJar(dstDir), !closeFs, false, null);
    }

    private OutputConsumerPath(Path destination, boolean isJar, boolean keepFsOpen, boolean threadSyncWrites, Predicate<String> classNameFilter) throws IOException {
        if (!isJar) {
            Files.createDirectories(destination, new FileAttribute[0]);
        } else {
            URI uri;
            OutputConsumerPath.createParentDirs(destination);
            try {
                uri = new URI("jar:" + destination.toUri().toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            destination = FileSystems.newFileSystem(uri, env).getPath("/", new String[0]);
        }
        this.dstDir = destination;
        this.closeFs = isJar && !keepFsOpen;
        this.isJarFs = isJar;
        this.lock = threadSyncWrites ? new ReentrantLock() : null;
        this.classNameFilter = classNameFilter;
    }

    public void addNonClassFiles(Path srcFile) throws IOException {
        this.addNonClassFiles(srcFile, NonClassCopyMode.UNCHANGED, null);
    }

    public void addNonClassFiles(Path srcDir, boolean closeFs) throws IOException {
        this.addNonClassFiles(srcDir, NonClassCopyMode.UNCHANGED, null, closeFs);
    }

    public void addNonClassFiles(Path srcFile, NonClassCopyMode copyMode, TinyRemapper remapper) throws IOException {
        if (Files.isDirectory(srcFile, new LinkOption[0])) {
            this.addNonClassFiles(srcFile, copyMode, remapper, false);
        } else if (Files.exists(srcFile, new LinkOption[0])) {
            this.addNonClassFiles(FileSystems.newFileSystem(srcFile, null).getPath("/", new String[0]), copyMode, remapper, true);
        } else {
            throw new FileNotFoundException("file " + srcFile + " doesn't exist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonClassFiles(final Path srcDir, final NonClassCopyMode copyMode, final TinyRemapper remapper, boolean closeFs) throws IOException {
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            if (this.closed) {
                throw new IllegalStateException("consumer already closed");
            }
            Files.walkFileTree(srcDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    block55: {
                        String fileName = file.getFileName().toString();
                        if (!fileName.endsWith(OutputConsumerPath.classSuffix)) {
                            Path relativePath = srcDir.relativize(file);
                            Path dstFile = OutputConsumerPath.this.dstDir.resolve(relativePath.toString());
                            if (copyMode == NonClassCopyMode.UNCHANGED || !relativePath.startsWith("META-INF") || copyMode == NonClassCopyMode.SKIP_META_INF && relativePath.getNameCount() != 2) {
                                OutputConsumerPath.createParentDirs(dstFile);
                                Files.copy(file, dstFile, StandardCopyOption.REPLACE_EXISTING);
                            } else if (copyMode == NonClassCopyMode.FIX_META_INF && !OutputConsumerPath.shouldStripForFixMeta(relativePath)) {
                                OutputConsumerPath.createParentDirs(dstFile);
                                if (fileName.equals("MANIFEST.MF")) {
                                    Manifest manifest;
                                    try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                                        manifest = new Manifest(is);
                                    }
                                    OutputConsumerPath.fixManifest(manifest, remapper);
                                    var8_8 = null;
                                    try (BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(dstFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));){
                                        manifest.write(os);
                                    }
                                    catch (Throwable throwable) {
                                        var8_8 = throwable;
                                        throw throwable;
                                    }
                                }
                                if (remapper != null && relativePath.getNameCount() == 3 && relativePath.getName(1).toString().equals("services")) {
                                    fileName = OutputConsumerPath.mapFullyQualifiedClassName(fileName, remapper);
                                    try (BufferedReader reader = Files.newBufferedReader(file);
                                         BufferedWriter writer = Files.newBufferedWriter(dstFile.getParent().resolve(fileName), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                                        OutputConsumerPath.fixServiceDecl(reader, writer, remapper);
                                        break block55;
                                    }
                                }
                                Files.copy(file, dstFile, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
            if (closeFs) {
                srcDir.getFileSystem().close();
            }
        }
    }

    private static boolean shouldStripForFixMeta(Path file) {
        if (file.getNameCount() != 2) {
            return false;
        }
        assert (file.getName(0).toString().equals("META-INF"));
        String fileName = file.getFileName().toString();
        return fileName.endsWith(".SF") || fileName.endsWith(".DSA") || fileName.endsWith(".RSA") || fileName.startsWith("SIG-");
    }

    private static String mapFullyQualifiedClassName(String name, TinyRemapper remapper) {
        assert (name.indexOf(47) < 0);
        return remapper.mapClass(name.replace('.', '/')).replace('/', '.');
    }

    private static void fixManifest(Manifest manifest, TinyRemapper remapper) {
        Attributes mainAttrs = manifest.getMainAttributes();
        if (remapper != null) {
            String val = mainAttrs.getValue(Attributes.Name.MAIN_CLASS);
            if (val != null) {
                mainAttrs.put(Attributes.Name.MAIN_CLASS, OutputConsumerPath.mapFullyQualifiedClassName(val, remapper));
            }
            if ((val = mainAttrs.getValue("Launcher-Agent-Class")) != null) {
                mainAttrs.put("Launcher-Agent-Class", OutputConsumerPath.mapFullyQualifiedClassName(val, remapper));
            }
        }
        mainAttrs.remove(Attributes.Name.SIGNATURE_VERSION);
        Iterator<Attributes> it = manifest.getEntries().values().iterator();
        while (it.hasNext()) {
            Attributes attrs = it.next();
            Iterator<Object> it2 = attrs.keySet().iterator();
            while (it2.hasNext()) {
                Attributes.Name attrName = (Attributes.Name)it2.next();
                String name = attrName.toString();
                if (!name.endsWith("-Digest") && !name.contains("-Digest-") && !name.equals("Magic")) continue;
                it2.remove();
            }
            if (!attrs.isEmpty()) continue;
            it.remove();
        }
    }

    private static void fixServiceDecl(BufferedReader reader, BufferedWriter writer, TinyRemapper remapper) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            char c;
            int start;
            int end = line.indexOf(35);
            if (end < 0) {
                end = line.length();
            }
            for (start = 0; start < end && ((c = line.charAt(start)) == ' ' || c == '\t'); ++start) {
            }
            while (end > start && ((c = line.charAt(end - 1)) == ' ' || c == '\t')) {
                --end;
            }
            if (start == end) {
                writer.write(line);
            } else {
                writer.write(line, 0, start);
                writer.write(OutputConsumerPath.mapFullyQualifiedClassName(line.substring(start, end), remapper));
                writer.write(line, end, line.length() - end);
            }
            writer.newLine();
        }
    }

    @Override
    public void accept(String clsName, byte[] data) {
        if (this.classNameFilter != null && !this.classNameFilter.test(clsName)) {
            return;
        }
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            if (this.closed) {
                throw new IllegalStateException("consumer already closed");
            }
            Path dstFile = this.dstDir.resolve(clsName + classSuffix);
            if (this.isJarFs && Files.exists(dstFile, new LinkOption[0])) {
                if (Files.isDirectory(dstFile, new LinkOption[0])) {
                    throw new FileAlreadyExistsException("dst file " + dstFile + " is a directory");
                }
                Files.delete(dstFile);
            }
            OutputConsumerPath.createParentDirs(dstFile);
            Files.write(dstFile, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            if (this.lock != null) {
                this.lock.lock();
            }
            if (this.closeFs) {
                this.dstDir.getFileSystem().close();
            }
            this.closed = true;
        }
        finally {
            if (this.lock != null) {
                this.lock.unlock();
            }
        }
    }

    private static boolean isJar(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            return !Files.isDirectory(path, new LinkOption[0]);
        }
        String name = path.getFileName().toString().toLowerCase(Locale.ENGLISH);
        return name.endsWith(".jar") || name.endsWith(".zip");
    }

    private static void createParentDirs(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static class Builder {
        private final Path destination;
        private Boolean assumeArchive;
        private boolean keepFsOpen = false;
        private boolean threadSyncWrites = false;
        private Predicate<String> classNameFilter;

        public Builder(Path destination) {
            this.destination = destination;
        }

        public Builder assumeArchive(boolean value) {
            this.assumeArchive = value;
            return this;
        }

        public Builder keepFsOpen(boolean value) {
            this.keepFsOpen = value;
            return this;
        }

        public Builder threadSyncWrites(boolean value) {
            this.threadSyncWrites = value;
            return this;
        }

        public Builder filter(Predicate<String> classNameFilter) {
            this.classNameFilter = classNameFilter;
            return this;
        }

        public OutputConsumerPath build() throws IOException {
            boolean isJar = this.assumeArchive == null || Files.exists(this.destination, new LinkOption[0]) ? OutputConsumerPath.isJar(this.destination) : this.assumeArchive;
            return new OutputConsumerPath(this.destination, isJar, this.keepFsOpen, this.threadSyncWrites, this.classNameFilter);
        }
    }
}

