/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.mojang.datafixers.DataFixer;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2286;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2462;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2747;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_638;

public class WorldUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    private static boolean preventOnBlockAdded;

    public static boolean shouldPreventOnBlockAdded() {
        return preventOnBlockAdded;
    }

    public static void setShouldPreventOnBlockAdded(boolean prevent) {
        preventOnBlockAdded = prevent;
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(new File(inputDir, inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld();
        WorldUtils.loadChunksSchematicWorld(world, class_2338.field_10980, schematic.getSize());
        class_3492 placementSettings = new class_3492();
        placementSettings.method_15133(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks(world, class_2338.field_10980, placementSettings);
        String subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(class_2338.field_10980, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, class_2338.field_10980);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new class_2338(schematic.getSize()).method_10069(-1, -1, -1));
        LitematicaSchematic.SchematicSaveInfo info = new LitematicaSchematic.SchematicSaveInfo(false, false);
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld(world, area, info, "?", feedback);
        if (litematicaSchematic != null && !ignoreEntities) {
            litematicaSchematic.takeEntityDataFromSchematicaSchematic(schematic, subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        return litematicaSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(File structureDir, String structureFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(File structureDir, String structureFileName, boolean ignoreEntities, IStringConsumer feedback) {
        try {
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(structureDir, structureFileName, true);
            if (litematicaSchematic == null) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to read the vanilla structure template from '" + structureFileName + '\"'), (Object[])new Object[0]);
            }
            return litematicaSchematic;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Exception while trying to load the vanilla structure: " + e.getMessage()), (Object[])new Object[0]);
            Litematica.logger.error("Exception while trying to load the vanilla structure: " + e.getMessage());
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        return false;
    }

    @Nullable
    public static SchematicaSchematic convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld();
        class_2338 size = new class_2338(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, class_2338.field_10980, (class_2382)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, class_2338.field_10980);
        litematicaSchematic.placeToWorld(world, schematicPlacement, false);
        SchematicaSchematic schematic = SchematicaSchematic.createFromWorld(world, class_2338.field_10980, size, ignoreEntities);
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_create_schematic");
        }
        return schematic;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        class_3499 template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static class_3499 convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.createSchematicWorld();
        class_2338 size = new class_2338(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, class_2338.field_10980, (class_2382)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, class_2338.field_10980);
        litematicaSchematic.placeToWorld(world, schematicPlacement, false);
        class_3499 template = new class_3499();
        template.method_15174((class_1937)world, class_2338.field_10980, size, !ignoreEntities, class_2246.field_10369);
        return template;
    }

    private static boolean writeVanillaStructureToFile(class_3499 template, File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        String fileName = fileNameIn;
        String extension = ".nbt";
        if (!fileName.endsWith(extension)) {
            fileName = fileName + extension;
        }
        File file = new File(dir, fileName);
        FileOutputStream os = null;
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && file.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.getAbsolutePath()}));
                return false;
            }
            class_2487 tag = template.method_15175(new class_2487());
            os = new FileOutputStream(file);
            class_2507.method_10634((class_2487)tag, (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()}));
            return false;
        }
    }

    private static class_3499 readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        class_2487 nbt = class_2507.method_10629((InputStream)stream);
        class_3499 template = new class_3499();
        template.method_15183(nbt);
        return template;
    }

    public static boolean isClientChunkLoaded(class_638 world, int chunkX, int chunkZ) {
        return world.method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false) != null;
    }

    public static void loadChunksSchematicWorld(WorldSchematic world, class_2338 origin, class_2382 areaSize) {
        class_2338 posEnd = origin.method_10081((class_2382)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        class_2338 posMin = PositionUtils.getMinCorner(origin, posEnd);
        class_2338 posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.method_10263() >> 4;
        int czMin = posMin.method_10260() >> 4;
        int cxMax = posMax.method_10263() >> 4;
        int czMax = posMax.method_10260() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.getChunkProvider().loadChunk(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, class_310 mc) {
        class_3965 trace;
        class_2680 state = class_2246.field_10124.method_9564();
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getGenericTrace((class_1937)mc.field_1687, (class_1297)mc.field_1724, 6.0, true);
        if (wrapper != null && (trace = wrapper.getBlockHitResult()) != null && trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = trace.method_17777();
            if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                state = SchematicWorldHandler.getSchematicWorld().method_8320(pos);
            } else if (wrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
                state = mc.field_1687.method_8320(pos);
            }
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, class_310 mc) {
        class_2338 pos = null;
        pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((class_1937)mc.field_1687, (class_1297)mc.field_1724, 6.0) : RayTraceUtils.getFurthestSchematicWorldTrace((class_1937)mc.field_1687, (class_1297)mc.field_1724, 6.0);
        if (pos != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            class_2680 state = world.method_8320(pos);
            class_1799 stack = MaterialCache.getInstance().getRequiredBuildItemForState(state, world, pos);
            if (!stack.method_7960()) {
                class_1661 inv = mc.field_1724.field_7514;
                stack = stack.method_7972();
                if (mc.field_1724.field_7503.field_7477) {
                    class_2586 te = world.method_8321(pos);
                    if (GuiBase.isCtrlDown() && te != null && mc.field_1687.method_22347(pos)) {
                        ItemUtils.storeTEInStack(stack, te);
                    }
                    InventoryUtils.setPickedItemToHand(stack, mc);
                    mc.field_1761.method_2909(mc.field_1724.method_5998(class_1268.field_5808), 36 + inv.field_7545);
                } else {
                    boolean canPick;
                    int slot = inv.method_7395(stack);
                    boolean shouldPick = inv.field_7545 != slot;
                    boolean bl = canPick = slot != -1;
                    if (shouldPick && canPick) {
                        InventoryUtils.setPickedItemToHand(stack, mc);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void easyPlaceOnUseTick(class_310 mc) {
        if (mc.field_1724 != null && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld() && KeybindMulti.isKeyDown((int)KeybindMulti.getKeyCode((class_304)mc.field_1690.field_1904))) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    public static boolean handleEasyPlace(class_310 mc) {
        class_1269 result = WorldUtils.doEasyPlaceAction(mc);
        if (result == class_1269.field_5814) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
            return true;
        }
        return result != class_1269.field_5811;
    }

    private static class_1269 doEasyPlaceAction(class_310 mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((class_1937)mc.field_1687, (class_1297)mc.field_1724, 6.0, true);
        if (traceWrapper == null) {
            return class_1269.field_5811;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            class_3965 trace = traceWrapper.getBlockHitResult();
            class_239 traceVanilla = RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, (class_1297)mc.field_1724, false, 6.0);
            class_2338 pos = trace.method_17777();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            class_2680 stateSchematic = world.method_8320(pos);
            class_1799 stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (WorldUtils.easyPlaceIsPositionCached(pos)) {
                return class_1269.field_5814;
            }
            if (!stack.method_7960()) {
                class_2680 stateClient = mc.field_1687.method_8320(pos);
                if (stateSchematic == stateClient) {
                    return class_1269.field_5814;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (class_1657)mc.field_1724, traceVanilla, stack)) {
                    return class_1269.field_5814;
                }
                if (!WorldUtils.doSchematicWorldPickBlock(true, mc)) {
                    return class_1269.field_5814;
                }
                class_1268 hand = EntityUtils.getUsedHandForItem((class_1657)mc.field_1724, stack);
                if (hand == null) {
                    return class_1269.field_5814;
                }
                class_243 hitPos = trace.method_17784();
                class_2350 sideOrig = trace.method_17780();
                if (traceVanilla != null && traceVanilla.method_17783() == class_239.class_240.field_1332) {
                    class_3965 hitResult = (class_3965)traceVanilla;
                    class_2338 posVanilla = hitResult.method_17777();
                    class_2350 sideVanilla = hitResult.method_17780();
                    class_2680 stateVanilla = mc.field_1687.method_8320(posVanilla);
                    class_243 hit = traceVanilla.method_17784();
                    class_1750 ctx = new class_1750(new class_1838((class_1657)mc.field_1724, hand, hitResult));
                    if (!stateVanilla.method_26166(ctx) && pos.equals((Object)(posVanilla = posVanilla.method_10093(sideVanilla)))) {
                        hitPos = hit;
                        sideOrig = sideVanilla;
                    }
                }
                class_2350 side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                hitPos = WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                WorldUtils.cacheEasyPlacePosition(pos);
                class_3965 hitResult = new class_3965(hitPos, side, pos, false);
                mc.field_1761.method_2896(mc.field_1724, mc.field_1687, hand, hitResult);
                if (stateSchematic.method_26204() instanceof class_2482 && stateSchematic.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682 && (stateClient = mc.field_1687.method_8320(pos)).method_26204() instanceof class_2482 && stateClient.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    hitResult = new class_3965(hitPos, side, pos, false);
                    mc.field_1761.method_2896(mc.field_1724, mc.field_1687, hand, hitResult);
                }
            }
            return class_1269.field_5812;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA_BLOCK) {
            return WorldUtils.placementRestrictionInEffect(mc) ? class_1269.field_5814 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static boolean easyPlaceBlockChecksCancel(class_2680 stateSchematic, class_2680 stateClient, class_1657 player, class_239 trace, class_1799 stack) {
        class_2248 blockClient;
        class_2248 blockSchematic = stateSchematic.method_26204();
        if (blockSchematic instanceof class_2482 && stateSchematic.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682 && (blockClient = stateClient.method_26204()) instanceof class_2482 && stateClient.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
            return blockSchematic != blockClient;
        }
        if (trace.method_17783() != class_239.class_240.field_1332) {
            return false;
        }
        class_3965 hitResult = (class_3965)trace;
        class_1750 ctx = new class_1750(new class_1838(player, class_1268.field_5808, hitResult));
        return !stateClient.method_26166(ctx);
    }

    public static class_243 applyCarpetProtocolHitVec(class_2338 pos, class_2680 state, class_243 hitVecIn) {
        double x = hitVecIn.field_1352;
        double y = hitVecIn.field_1351;
        double z = hitVecIn.field_1350;
        class_2248 block = state.method_26204();
        class_2350 facing = BlockUtils.getFirstPropertyFacingValue((class_2680)state);
        int propertyIncrement = 16;
        double relX = hitVecIn.field_1352 - (double)pos.method_10263();
        if (facing != null) {
            x = (double)pos.method_10263() + relX + 2.0 + (double)(facing.method_10146() * 2);
        }
        if (block instanceof class_2462) {
            x += (double)(((Integer)state.method_11654((class_2769)class_2462.field_11451) - 1) * 16);
        } else if (block instanceof class_2533 && state.method_11654((class_2769)class_2533.field_11625) == class_2760.field_12619) {
            x += 16.0;
        } else if (block instanceof class_2286 && state.method_11654((class_2769)class_2286.field_10789) == class_2747.field_12578) {
            x += 16.0;
        } else if (block instanceof class_2510 && state.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12619) {
            x += 16.0;
        } else if (block instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
            y = state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679 ? (double)pos.method_10264() + 0.9 : (double)pos.method_10264();
        }
        return new class_243(x, y, z);
    }

    private static class_2350 applyPlacementFacing(class_2680 stateSchematic, class_2350 side, class_2680 stateClient) {
        class_2248 blockSchematic = stateSchematic.method_26204();
        class_2248 blockClient = stateClient.method_26204();
        if (blockSchematic instanceof class_2482) {
            if (stateSchematic.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12682 && blockClient instanceof class_2482 && stateClient.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
                if (stateClient.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12679) {
                    return class_2350.field_11033;
                }
                return class_2350.field_11036;
            }
            return class_2350.field_11043;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(class_310 mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(class_310 mc) {
        class_239 trace = mc.field_1765;
        class_1799 stack = mc.field_1724.method_6047();
        if (stack.method_7960()) {
            stack = mc.field_1724.method_6079();
        }
        if (stack.method_7960()) {
            return false;
        }
        if (trace != null && trace.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)trace;
            class_2338 pos = blockHitResult.method_17777();
            class_1750 ctx = new class_1750(new class_1838((class_1657)mc.field_1724, class_1268.field_5808, blockHitResult));
            pos = ctx.method_8037();
            class_2680 stateClient = mc.field_1687.method_8320(pos);
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            boolean schematicHasAir = worldSchematic.method_22347(pos);
            if (!schematicHasAir && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (schematicHasAir && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            blockHitResult = new class_3965(blockHitResult.method_17784(), blockHitResult.method_17780(), pos, false);
            ctx = new class_1750(new class_1838((class_1657)mc.field_1724, class_1268.field_5808, (class_3965)trace));
            if (!stateClient.method_26166(ctx)) {
                return true;
            }
            class_2680 stateSchematic = worldSchematic.method_8320(pos);
            stack = MaterialCache.getInstance().getRequiredBuildItemForState(stateSchematic);
            if (!stack.method_7960() && EntityUtils.getUsedHandForItem((class_1657)mc.field_1724, stack) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(class_2338 pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int minCX = pos.method_10263() - range >> 4;
        int minCY = pos.method_10264() - range >> 4;
        int minCZ = pos.method_10260() - range >> 4;
        int maxCX = pos.method_10263() + range >> 4;
        int maxCY = pos.method_10264() + range >> 4;
        int maxCZ = pos.method_10260() + range >> 4;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        for (int cy = minCY; cy <= maxCY; ++cy) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    List<IntBoundingBox> boxes = manager.getTouchedBoxesInSubChunk(new SubChunkPos(cx, cy, cz));
                    for (int i = 0; i < boxes.size(); ++i) {
                        IntBoundingBox box = boxes.get(i);
                        if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(class_1937 world, class_2350.class_2351 axis, class_2338 pos1, class_2338 pos2) {
        class_2338.class_2339 posMutable = new class_2338.class_2339();
        switch (axis) {
            case field_11051: {
                int x1 = Math.min(pos1.method_10263(), pos2.method_10263());
                int x2 = Math.max(pos1.method_10263(), pos2.method_10263());
                int y1 = Math.min(pos1.method_10264(), pos2.method_10264());
                int y2 = Math.max(pos1.method_10264(), pos2.method_10264());
                int z = pos1.method_10260();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    class_2818 chunk = world.method_8497(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, chunk.method_12031() + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.method_8320((class_2338)posMutable.method_10103(x, y, z)).method_26215()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case field_11052: {
                int x1 = Math.min(pos1.method_10263(), pos2.method_10263());
                int x2 = Math.max(pos1.method_10263(), pos2.method_10263());
                int y = pos1.method_10264();
                int z1 = Math.min(pos1.method_10260(), pos2.method_10260());
                int z2 = Math.max(pos1.method_10260(), pos2.method_10260());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        class_2818 chunk = world.method_8497(cx, cz);
                        if (y > chunk.method_12031() + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.method_8320((class_2338)posMutable.method_10103(x, y, z)).method_26215()) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case field_11048: {
                int x = pos1.method_10263();
                int z1 = Math.min(pos1.method_10260(), pos2.method_10260());
                int z2 = Math.max(pos1.method_10260(), pos2.method_10260());
                int y1 = Math.min(pos1.method_10264(), pos2.method_10264());
                int y2 = Math.max(pos1.method_10264(), pos2.method_10264());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    class_2818 chunk = world.method_8497(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, chunk.method_12031() + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.method_8320((class_2338)posMutable.method_10103(x, y, z)).method_26215()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public static boolean easyPlaceIsPositionCached(class_2338 pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(class_2338 pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    public static class PositionCache {
        private final class_2338 pos;
        private final long time;
        private final long timeout;

        private PositionCache(class_2338 pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public class_2338 getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

