/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mumfrey.worldeditcui.InitialisationFactory;
import com.mumfrey.worldeditcui.config.Colour;
import com.mumfrey.worldeditcui.render.ConfiguredColour;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2588;
import org.jetbrains.annotations.Nullable;

public final class CUIConfiguration
implements InitialisationFactory {
    private static final String CONFIG_FILE_NAME = "worldeditcui.config.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private boolean debugMode = false;
    private boolean ignoreUpdates = false;
    private boolean promiscuous = false;
    private boolean clearAllOnKey = false;
    private Colour cuboidGridColor = ConfiguredColour.CUBOIDBOX.getDefault();
    private Colour cuboidEdgeColor = ConfiguredColour.CUBOIDGRID.getDefault();
    private Colour cuboidFirstPointColor = ConfiguredColour.CUBOIDPOINT1.getDefault();
    private Colour cuboidSecondPointColor = ConfiguredColour.CUBOIDPOINT2.getDefault();
    private Colour polyGridColor = ConfiguredColour.POLYGRID.getDefault();
    private Colour polyEdgeColor = ConfiguredColour.POLYBOX.getDefault();
    private Colour polyPointColor = ConfiguredColour.POLYPOINT.getDefault();
    private Colour ellipsoidGridColor = ConfiguredColour.ELLIPSOIDGRID.getDefault();
    private Colour ellipsoidPointColor = ConfiguredColour.ELLIPSOIDCENTRE.getDefault();
    private Colour cylinderGridColor = ConfiguredColour.CYLINDERGRID.getDefault();
    private Colour cylinderEdgeColor = ConfiguredColour.CYLINDERBOX.getDefault();
    private Colour cylinderPointColor = ConfiguredColour.CYLINDERCENTRE.getDefault();
    private Colour chunkBoundaryColour = ConfiguredColour.CHUNKBOUNDARY.getDefault();
    private Colour chunkGridColour = ConfiguredColour.CHUNKGRID.getDefault();
    private static transient Map<String, Object> configArray = new LinkedHashMap<String, Object>();

    @Override
    public void initialise() {
        int index = 0;
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                if (field.getType() != Colour.class) continue;
                ConfiguredColour configuredColour = ConfiguredColour.values()[index++];
                Colour colour = Colour.firstOrDefault((Colour)field.get(this), configuredColour.getColour().getHex());
                field.set(this, colour);
                configuredColour.setColour(colour);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.save();
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean ignoreUpdates() {
        return this.ignoreUpdates;
    }

    public boolean isPromiscuous() {
        return this.promiscuous;
    }

    public void setPromiscuous(boolean promiscuous) {
        this.promiscuous = promiscuous;
    }

    public boolean isClearAllOnKey() {
        return this.clearAllOnKey;
    }

    public void setClearAllOnKey(boolean clearAllOnKey) {
        this.clearAllOnKey = clearAllOnKey;
    }

    private static Path getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve(CONFIG_FILE_NAME);
    }

    public static CUIConfiguration create() {
        Path jsonFile = CUIConfiguration.getConfigFile();
        CUIConfiguration config = null;
        if (Files.exists(jsonFile, new LinkOption[0])) {
            try (BufferedReader fileReader = Files.newBufferedReader(jsonFile, StandardCharsets.UTF_8);){
                config = (CUIConfiguration)GSON.fromJson((Reader)fileReader, CUIConfiguration.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (config == null) {
            config = new CUIConfiguration();
        }
        configArray.put("debugMode", config.debugMode);
        configArray.put("ignoreUpdates", config.ignoreUpdates);
        configArray.put("promiscuous", config.promiscuous);
        configArray.put("clearAllOnKey", config.clearAllOnKey);
        configArray.put("cuboidGridColor", config.cuboidGridColor);
        configArray.put("cuboidEdgeColor", config.cuboidEdgeColor);
        configArray.put("cuboidFirstPointColor", config.cuboidFirstPointColor);
        configArray.put("cuboidSecondPointColor", config.cuboidSecondPointColor);
        configArray.put("polyGridColor", config.polyGridColor);
        configArray.put("polyEdgeColor", config.polyEdgeColor);
        configArray.put("polyPointColor", config.polyPointColor);
        configArray.put("ellipsoidGridColor", config.ellipsoidGridColor);
        configArray.put("ellipsoidPointColor", config.ellipsoidPointColor);
        configArray.put("cylinderGridColor", config.cylinderGridColor);
        configArray.put("cylinderEdgeColor", config.cylinderEdgeColor);
        configArray.put("cylinderPointColor", config.cylinderPointColor);
        configArray.put("chunkBoundaryColour", config.chunkBoundaryColour);
        configArray.put("chunkGridColour", config.chunkGridColour);
        return config;
    }

    public void changeValue(String text, Object value) {
        configArray.replace(text, value);
    }

    public Map<String, Object> getConfigArray() {
        return configArray;
    }

    public void configChanged() {
        this.debugMode = (Boolean)configArray.get("debugMode");
        this.ignoreUpdates = (Boolean)configArray.get("ignoreUpdates");
        this.promiscuous = (Boolean)configArray.get("promiscuous");
        this.clearAllOnKey = (Boolean)configArray.get("clearAllOnKey");
        this.cuboidGridColor = (Colour)configArray.get("cuboidGridColor");
        this.cuboidEdgeColor = (Colour)configArray.get("cuboidEdgeColor");
        this.cuboidFirstPointColor = (Colour)configArray.get("cuboidFirstPointColor");
        this.cuboidSecondPointColor = (Colour)configArray.get("cuboidSecondPointColor");
        this.polyGridColor = (Colour)configArray.get("polyGridColor");
        this.polyEdgeColor = (Colour)configArray.get("polyEdgeColor");
        this.polyPointColor = (Colour)configArray.get("polyPointColor");
        this.ellipsoidGridColor = (Colour)configArray.get("ellipsoidGridColor");
        this.ellipsoidPointColor = (Colour)configArray.get("ellipsoidPointColor");
        this.cylinderGridColor = (Colour)configArray.get("cylinderGridColor");
        this.cylinderEdgeColor = (Colour)configArray.get("cylinderEdgeColor");
        this.cylinderPointColor = (Colour)configArray.get("cylinderPointColor");
        this.chunkBoundaryColour = (Colour)configArray.get("chunkBoundaryColour");
        this.chunkGridColour = (Colour)configArray.get("chunkGridColour");
        this.initialise();
    }

    public Object getDefaultValue(String text) {
        switch (text) {
            case "debugMode": 
            case "ignoreUpdates": 
            case "promiscuous": 
            case "clearAllOnKey": {
                return false;
            }
            case "cuboidGridColor": {
                return ConfiguredColour.CUBOIDBOX.getDefault();
            }
            case "cuboidEdgeColor": {
                return ConfiguredColour.CUBOIDGRID.getDefault();
            }
            case "cuboidFirstPointColor": {
                return ConfiguredColour.CUBOIDPOINT1.getDefault();
            }
            case "cuboidSecondPointColor": {
                return ConfiguredColour.CUBOIDPOINT2.getDefault();
            }
            case "polyGridColor": {
                return ConfiguredColour.POLYGRID.getDefault();
            }
            case "polyEdgeColor": {
                return ConfiguredColour.POLYBOX.getDefault();
            }
            case "polyPointColor": {
                return ConfiguredColour.POLYPOINT.getDefault();
            }
            case "ellipsoidGridColor": {
                return ConfiguredColour.ELLIPSOIDGRID.getDefault();
            }
            case "ellipsoidPointColor": {
                return ConfiguredColour.ELLIPSOIDCENTRE.getDefault();
            }
            case "cylinderGridColor": {
                return ConfiguredColour.CYLINDERGRID.getDefault();
            }
            case "cylinderEdgeColor": {
                return ConfiguredColour.CYLINDERBOX.getDefault();
            }
            case "cylinderPointColor": {
                return ConfiguredColour.CYLINDERCENTRE.getDefault();
            }
            case "chunkBoundaryColour": {
                return ConfiguredColour.CHUNKBOUNDARY.getDefault();
            }
            case "chunkGridColour": {
                return ConfiguredColour.CHUNKGRID.getDefault();
            }
        }
        return null;
    }

    @Nullable
    public class_2588 getDescription(String text) {
        switch (text) {
            case "debugMode": {
                return new class_2588("worldeditcui.options.debugMode");
            }
            case "ignoreUpdates": {
                return new class_2588("worldeditcui.options.ignoreUpdates");
            }
            case "promiscuous": {
                return new class_2588("worldeditcui.options.compat.spammy");
            }
            case "clearAllOnKey": {
                return new class_2588("worldeditcui.options.extra.clearall");
            }
            case "cuboidGridColor": {
                return new class_2588("worldeditcui.color.cuboidgrid");
            }
            case "cuboidEdgeColor": {
                return new class_2588("worldeditcui.color.cuboidedge");
            }
            case "cuboidFirstPointColor": {
                return new class_2588("worldeditcui.color.cuboidpoint1");
            }
            case "cuboidSecondPointColor": {
                return new class_2588("worldeditcui.color.cuboidpoint2");
            }
            case "polyGridColor": {
                return new class_2588("worldeditcui.color.polygrid");
            }
            case "polyEdgeColor": {
                return new class_2588("worldeditcui.color.polyedge");
            }
            case "polyPointColor": {
                return new class_2588("worldeditcui.color.polypoint");
            }
            case "ellipsoidGridColor": {
                return new class_2588("worldeditcui.color.ellipsoidgrid");
            }
            case "ellipsoidPointColor": {
                return new class_2588("worldeditcui.color.ellipsoidpoint");
            }
            case "cylinderGridColor": {
                return new class_2588("worldeditcui.color.cylindergrid");
            }
            case "cylinderEdgeColor": {
                return new class_2588("worldeditcui.color.cylinderedge");
            }
            case "cylinderPointColor": {
                return new class_2588("worldeditcui.color.cylinderpoint");
            }
            case "chunkBoundaryColour": {
                return new class_2588("worldeditcui.color.chunkboundary");
            }
            case "chunkGridColour": {
                return new class_2588("worldeditcui.color.chunkgrid");
            }
        }
        return null;
    }

    public void save() {
        try (BufferedWriter fileWriter = Files.newBufferedWriter(CUIConfiguration.getConfigFile(), StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)fileWriter);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

