/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.config;

public class Colour {
    private String hex;
    private transient int argb;
    private transient float a;
    private transient float r;
    private transient float g;
    private transient float b;
    private transient String defaultColour;
    private transient boolean woken;

    public Colour(String colour) {
        this.hex = this.defaultColour = colour;
        if (this.hex.length() == 9) {
            this.update();
        }
    }

    public Colour() {
    }

    public static Colour parse(String colour, Colour defaultColour) {
        return (colour = Colour.sanitiseColour(colour, null)) == null ? defaultColour : new Colour(colour);
    }

    public static Colour firstOrDefault(Colour colour, String defaultColour) {
        if (colour == null) {
            return new Colour(defaultColour);
        }
        if (colour.hex == null) {
            colour.hex = defaultColour;
            colour.defaultColour = defaultColour;
        } else {
            colour.hex = Colour.sanitiseColour(colour.hex, defaultColour);
        }
        return colour;
    }

    private static String sanitiseColour(String colour, String def) {
        if (colour == null) {
            return def;
        }
        if (!colour.startsWith("#")) {
            return def;
        }
        if (colour.length() != 7 && colour.length() != 9) {
            return def;
        }
        return colour.matches("(?i)^#[0-9a-f]{6,8}$") ? colour : def;
    }

    public void setHex(String hex) {
        if (hex.length() < 8) {
            hex = "00000000".substring(0, 8 - hex.length()) + hex;
        }
        this.hex = "#" + hex;
        this.update();
    }

    public String getHex() {
        if (this.hex == null) {
            this.hex = this.defaultColour;
            this.update();
        }
        if (this.hex.length() == 7) {
            this.hex = this.hex + "CC";
            this.update();
        }
        return this.hex;
    }

    private void update() {
        String hex = this.getHex();
        this.argb = (int)Long.parseLong(hex.substring(7, 9) + hex.substring(1, 7), 16);
        this.r = (float)Integer.parseInt(hex.substring(1, 3), 16) / 256.0f;
        this.g = (float)Integer.parseInt(hex.substring(3, 5), 16) / 256.0f;
        this.b = (float)Integer.parseInt(hex.substring(5, 7), 16) / 256.0f;
        this.a = (float)Integer.parseInt(hex.substring(7, 9), 16) / 256.0f;
        this.woken = true;
    }

    public int getIntARGB() {
        return this.argb;
    }

    public float red() {
        if (!this.woken) {
            this.update();
        }
        return this.r;
    }

    public float green() {
        if (!this.woken) {
            this.update();
        }
        return this.g;
    }

    public float blue() {
        if (!this.woken) {
            this.update();
        }
        return this.b;
    }

    public float alpha() {
        if (!this.woken) {
            this.update();
        }
        return this.a;
    }

    public Colour copyFrom(Colour other) {
        this.hex = other.getHex();
        this.update();
        return this;
    }
}

