/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.debug;

import com.mumfrey.worldeditcui.InitialisationFactory;
import com.mumfrey.worldeditcui.WorldEditCUI;
import com.mumfrey.worldeditcui.debug.DebugModeEnabledFilter;
import com.mumfrey.worldeditcui.exceptions.InitialisationException;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;

public final class CUIDebug
implements InitialisationFactory {
    private static final boolean LOG_ALL_ERRORS = Boolean.getBoolean("wecui.debug.logall");
    private static final Logger LOGGER = LogManager.getLogger((String)"WorldEditCUI");
    private final WorldEditCUI controller;
    private boolean debugLogged;

    public CUIDebug(WorldEditCUI controller) {
        this.controller = controller;
    }

    @Override
    public void initialise() throws InitialisationException {
        org.apache.logging.log4j.core.Logger loggerImpl = (org.apache.logging.log4j.core.Logger)LOGGER;
        Path debugFile = FabricLoader.getInstance().getGameDir().resolve("worldeditcui.debug.log");
        Layout layout = null;
        for (Appender appender : loggerImpl.getContext().getConfiguration().getAppenders().values()) {
            if (!(appender instanceof FileAppender) && !(appender instanceof RollingFileAppender) && !(appender instanceof RollingRandomAccessFileAppender) && !(appender instanceof RandomAccessFileAppender)) continue;
            layout = appender.getLayout();
            break;
        }
        FileAppender appender = ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().withName("WECUIDebug")).withFileName(debugFile.toAbsolutePath().toString()).withCreateOnDemand(true).withFilter((Filter)new DebugModeEnabledFilter(this.controller.getConfiguration()))).withLayout(layout)).build();
        appender.start();
        loggerImpl.addAppender((Appender)appender);
    }

    public void debug(String message) {
        if (this.controller.getConfiguration().isDebugMode()) {
            LOGGER.info("Debug - " + message);
        }
    }

    public void error(String message, Throwable exception) {
        if (!this.debugLogged || LOG_ALL_ERRORS) {
            LOGGER.error(message, exception);
            this.debugLogged = true;
        }
    }

    public void info(String message) {
        LOGGER.info(message);
    }

    public void info(String message, Throwable e) {
        LOGGER.info(message, e);
    }
}

