/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.region;

import com.mumfrey.worldeditcui.WorldEditCUI;
import com.mumfrey.worldeditcui.event.listeners.CUIRenderContext;
import com.mumfrey.worldeditcui.render.ConfiguredColour;
import com.mumfrey.worldeditcui.render.points.PointCube;
import com.mumfrey.worldeditcui.render.region.Region;
import com.mumfrey.worldeditcui.render.region.RegionType;
import com.mumfrey.worldeditcui.render.shapes.Render3DPolygon;
import com.mumfrey.worldeditcui.util.Vector3;
import java.util.ArrayList;
import java.util.List;

public class PolyhedronRegion
extends Region {
    private static final Vector3 HALF = new Vector3(0.5, 0.5, 0.5);
    private final List<PointCube> vertices = new ArrayList<PointCube>();
    private final List<Vector3[]> faces = new ArrayList<Vector3[]>();
    private final List<Render3DPolygon> faceRenders = new ArrayList<Render3DPolygon>();

    public PolyhedronRegion(WorldEditCUI controller) {
        super(controller, ConfiguredColour.POLYBOX.style(), ConfiguredColour.POLYPOINT.style(), ConfiguredColour.CUBOIDPOINT1.style());
    }

    @Override
    public void render(CUIRenderContext ctx) {
        for (PointCube vertex : this.vertices) {
            vertex.render(ctx);
        }
        for (Render3DPolygon face : this.faceRenders) {
            face.render(ctx);
        }
    }

    @Override
    public void setCuboidPoint(int id, double x, double y, double z) {
        PointCube vertex = new PointCube(x, y, z).setId(id);
        vertex.setStyle(id == 0 ? this.styles[2] : this.styles[1]);
        if (id < this.vertices.size()) {
            this.vertices.set(id, vertex);
        } else {
            for (int i = 0; i < id - this.vertices.size(); ++i) {
                this.vertices.add(null);
            }
            this.vertices.add(vertex);
        }
    }

    @Override
    public void addPolygon(int[] vertexIds) {
        Vector3[] face = new Vector3[vertexIds.length];
        for (int i = 0; i < vertexIds.length; ++i) {
            PointCube vertex = this.vertices.get(vertexIds[i]);
            if (vertex == null) {
                return;
            }
            face[i] = vertex.getPoint().add(HALF);
        }
        this.faces.add(face);
        this.update();
    }

    private void update() {
        this.faceRenders.clear();
        for (Vector3[] face : this.faces) {
            this.faceRenders.add(new Render3DPolygon(this.styles[0], face));
        }
    }

    @Override
    protected void updateStyles() {
        for (PointCube vertex : this.vertices) {
            vertex.setStyle(vertex.getId() == 0 ? this.styles[2] : this.styles[1]);
        }
        for (Render3DPolygon face : this.faceRenders) {
            face.setStyle(this.styles[0]);
        }
    }

    @Override
    public RegionType getType() {
        return RegionType.POLYHEDRON;
    }
}

