/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.event.listeners.CUIRenderContext;
import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.points.PointRectangle;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.Vector2;
import java.util.List;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;

public class Render2DGrid
extends RenderRegion {
    private final List<PointRectangle> points;
    private final int min;
    private final int max;

    public Render2DGrid(RenderStyle style, List<PointRectangle> points, int min, int max) {
        super(style);
        this.points = points;
        this.min = min;
        this.max = max;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        double off = 0.03;
        for (double height = (double)this.min; height <= (double)(this.max + 1); height += 1.0) {
            this.drawPoly(ctx, height + off);
        }
    }

    protected void drawPoly(CUIRenderContext ctx, double height) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            for (PointRectangle point : this.points) {
                if (point == null) continue;
                Vector2 pos = point.getPoint();
                double x = pos.getX() - ctx.cameraPos().getX();
                double z = pos.getY() - ctx.cameraPos().getZ();
                buf.method_22912(x + 0.5, height - ctx.cameraPos().getY(), z + 0.5).method_1344();
            }
            tessellator.method_1350();
        }
    }
}

