/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.event.listeners.CUIRenderContext;
import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.BoundingBox;
import com.mumfrey.worldeditcui.util.Observable;
import com.mumfrey.worldeditcui.util.Vector3;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;

public class Render3DBox
extends RenderRegion {
    private Vector3 first;
    private Vector3 second;

    public Render3DBox(RenderStyle style, BoundingBox region) {
        this(style, region.getMin(), region.getMax());
        if (region.isDynamic()) {
            region.addObserver(this);
        }
    }

    public Render3DBox(RenderStyle style, Vector3 first, Vector3 second) {
        super(style);
        this.first = first;
        this.second = second;
    }

    @Override
    public void notifyChanged(Observable<?> source) {
        this.setPosition((BoundingBox)source);
    }

    public void setPosition(BoundingBox region) {
        this.setPosition(region.getMin(), region.getMax());
    }

    public void setPosition(Vector3 first, Vector3 second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        Vector3 camera = ctx.cameraPos();
        double x1 = this.first.getX() - camera.getX();
        double y1 = this.first.getY() - camera.getY();
        double z1 = this.first.getZ() - camera.getZ();
        double x2 = this.second.getX() - camera.getX();
        double y2 = this.second.getY() - camera.getY();
        double z2 = this.second.getZ() - camera.getZ();
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            buf.method_22912(x1, y1, z1).method_1344();
            buf.method_22912(x2, y1, z1).method_1344();
            buf.method_22912(x2, y1, z2).method_1344();
            buf.method_22912(x1, y1, z2).method_1344();
            tessellator.method_1350();
            buf.method_1328(2, class_290.field_1592);
            line.applyColour();
            buf.method_22912(x1, y2, z1).method_1344();
            buf.method_22912(x2, y2, z1).method_1344();
            buf.method_22912(x2, y2, z2).method_1344();
            buf.method_22912(x1, y2, z2).method_1344();
            tessellator.method_1350();
            buf.method_1328(1, class_290.field_1592);
            line.applyColour();
            buf.method_22912(x1, y1, z1).method_1344();
            buf.method_22912(x1, y2, z1).method_1344();
            buf.method_22912(x2, y1, z1).method_1344();
            buf.method_22912(x2, y2, z1).method_1344();
            buf.method_22912(x2, y1, z2).method_1344();
            buf.method_22912(x2, y2, z2).method_1344();
            buf.method_22912(x1, y1, z2).method_1344();
            buf.method_22912(x1, y2, z2).method_1344();
            tessellator.method_1350();
        }
    }
}

