/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.event.listeners.CUIRenderContext;
import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.shapes.Render3DGrid;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import com.mumfrey.worldeditcui.util.Vector3;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4493;

public class RenderChunkBoundary
extends RenderRegion {
    private final class_310 mc;
    private final Render3DGrid grid;

    public RenderChunkBoundary(RenderStyle boundaryStyle, RenderStyle gridStyle, class_310 minecraft) {
        super(boundaryStyle);
        this.mc = minecraft;
        this.grid = new Render3DGrid(gridStyle, Vector3.ZERO, Vector3.ZERO);
        this.grid.setSpacing(4.0);
    }

    @Override
    public void render(CUIRenderContext ctx) {
        double yMax = this.mc.field_1687 != null ? (double)this.mc.field_1687.method_8322() : 256.0;
        double yMin = 0.0;
        long xBlock = class_3532.method_15357((double)ctx.cameraPos().getX());
        long zBlock = class_3532.method_15357((double)ctx.cameraPos().getZ());
        int xChunk = (int)(xBlock >> 4);
        int zChunk = (int)(zBlock >> 4);
        double xBase = (double)(0L - (xBlock - (long)(xChunk * 16))) - (ctx.cameraPos().getX() - (double)xBlock);
        double zBase = (double)(0L - (zBlock - (long)(zChunk * 16))) - (ctx.cameraPos().getZ() - (double)zBlock) + 16.0;
        this.grid.setPosition(new Vector3(xBase - 0.001, yMin, zBase - 16.0 - 0.001), new Vector3(xBase + 16.0 + 0.001, yMax, zBase + 0.001));
        class_4493.method_21926();
        class_4493.method_21938((double)0.0, (double)(-ctx.cameraPos().getY()), (double)0.0);
        ctx.withCameraAt(Vector3.ZERO, this.grid::render);
        this.renderChunkBorder(yMin, yMax, xBase, zBase);
        if (this.mc.field_1687 != null) {
            this.renderChunkBoundary(xChunk, zChunk, xBase, zBase);
        }
        class_4493.method_21928();
    }

    private void renderChunkBorder(double yMin, double yMax, double xBase, double zBase) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        int spacing = 16;
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            buf.method_1328(1, class_290.field_1592);
            line.applyColour();
            for (int x = -16; x <= 32; x += spacing) {
                for (int z = -16; z <= 32; z += spacing) {
                    buf.method_22912(xBase + (double)x, yMin, zBase - (double)z).method_1344();
                    buf.method_22912(xBase + (double)x, yMax, zBase - (double)z).method_1344();
                }
            }
            for (double y = yMin; y <= yMax; y += yMax) {
                buf.method_22912(xBase, y, zBase).method_1344();
                buf.method_22912(xBase, y, zBase - 16.0).method_1344();
                buf.method_22912(xBase, y, zBase - 16.0).method_1344();
                buf.method_22912(xBase + 16.0, y, zBase - 16.0).method_1344();
                buf.method_22912(xBase + 16.0, y, zBase - 16.0).method_1344();
                buf.method_22912(xBase + 16.0, y, zBase).method_1344();
                buf.method_22912(xBase + 16.0, y, zBase).method_1344();
                buf.method_22912(xBase, y, zBase).method_1344();
            }
            tessellator.method_1350();
        }
    }

    private void renderChunkBoundary(int xChunk, int zChunk, double xBase, double zBase) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        class_2818 chunk = this.mc.field_1687.method_8497(xChunk, zChunk);
        class_2902 heightMap = chunk.method_12032(class_2902.class_2903.field_13202);
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            buf.method_1328(1, class_290.field_1592);
            line.applyColour();
            int[][] lastHeight = new int[][]{{-1, -1}, {-1, -1}};
            int height = 0;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 2; ++j) {
                    for (int axis = 0; axis < 2; ++axis) {
                        double zPos;
                        height = axis == 0 ? heightMap.method_12603(j * 15, i) : heightMap.method_12603(i, j * 15);
                        double xPos = axis == 0 ? xBase + (double)(j * 16) : xBase + (double)i;
                        double d = zPos = axis == 0 ? zBase - 16.0 + (double)i : zBase - 16.0 + (double)(j * 16);
                        if (lastHeight[axis][j] > -1 && height != lastHeight[axis][j]) {
                            buf.method_22912(xPos, (double)lastHeight[axis][j] + 0.001, zPos).method_1344();
                            buf.method_22912(xPos, (double)height + 0.001, zPos).method_1344();
                        }
                        buf.method_22912(xPos, (double)height + 0.001, zPos).method_1344();
                        buf.method_22912(xPos + (double)axis, (double)height + 0.001, zPos + (double)(1 - axis)).method_1344();
                        lastHeight[axis][j] = height;
                    }
                }
            }
            tessellator.method_1350();
        }
    }
}

