/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.worldeditcui.render.shapes;

import com.mumfrey.worldeditcui.event.listeners.CUIRenderContext;
import com.mumfrey.worldeditcui.render.LineStyle;
import com.mumfrey.worldeditcui.render.RenderStyle;
import com.mumfrey.worldeditcui.render.points.PointCube;
import com.mumfrey.worldeditcui.render.shapes.RenderRegion;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;

public class RenderCylinderBox
extends RenderRegion {
    private final double radX;
    private final double radZ;
    private final int minY;
    private final int maxY;
    private final double centreX;
    private final double centreZ;

    public RenderCylinderBox(RenderStyle style, PointCube centre, double radX, double radZ, int minY, int maxY) {
        super(style);
        this.radX = radX;
        this.radZ = radZ;
        this.minY = minY;
        this.maxY = maxY;
        this.centreX = centre.getPoint().getX() + 0.5;
        this.centreZ = centre.getPoint().getZ() + 0.5;
    }

    @Override
    public void render(CUIRenderContext ctx) {
        class_289 tessellator = class_289.method_1348();
        class_287 buf = tessellator.method_1349();
        double xPos = this.centreX - ctx.cameraPos().getX();
        double zPos = this.centreZ - ctx.cameraPos().getZ();
        for (LineStyle line : this.style.getLines()) {
            if (!line.prepare(this.style.getRenderType())) continue;
            double twoPi = Math.PI * 2;
            for (int yBlock : new int[]{this.minY, this.maxY + 1}) {
                buf.method_1328(2, class_290.field_1592);
                line.applyColour();
                for (int i = 0; i <= 75; ++i) {
                    double tempTheta = (double)i * twoPi / 75.0;
                    double tempX = this.radX * Math.cos(tempTheta);
                    double tempZ = this.radZ * Math.sin(tempTheta);
                    buf.method_22912(xPos + tempX, (double)yBlock - ctx.cameraPos().getY(), zPos + tempZ).method_1344();
                }
                tessellator.method_1350();
            }
        }
    }
}

