/*
 * Decompiled with CFR 0.152.
 */
package eu.mikroskeem.worldeditcui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mumfrey.worldeditcui.WorldEditCUI;
import com.mumfrey.worldeditcui.config.CUIConfiguration;
import com.mumfrey.worldeditcui.event.listeners.CUIListenerChannel;
import com.mumfrey.worldeditcui.event.listeners.CUIListenerWorldRender;
import eu.mikroskeem.worldeditcui.CUINetworking;
import eu.mikroskeem.worldeditcui.OptifineHooks;
import eu.mikroskeem.worldeditcui.mixins.MinecraftClientAccess;
import eu.mikroskeem.worldeditcui.mixins.RenderPhaseAccess;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1159;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.MixinEnvironment;

public final class FabricModWorldEditCUI
implements ModInitializer {
    private static final int DELAYED_HELO_TICKS = 10;
    public static final String MOD_ID = "worldeditcui";
    private static FabricModWorldEditCUI instance;
    private static final String KEYBIND_CATEGORY_WECUI = "key.categories.worldeditcui";
    private final class_304 keyBindToggleUI = FabricModWorldEditCUI.key("toggle", class_3675.class_307.field_1668, -1);
    private final class_304 keyBindClearSel = FabricModWorldEditCUI.key("clear", class_3675.class_307.field_1668, -1);
    private final class_304 keyBindChunkBorder = FabricModWorldEditCUI.key("chunk", class_3675.class_307.field_1668, -1);
    private WorldEditCUI controller;
    private CUIListenerWorldRender worldRenderListener;
    private CUIListenerChannel channelListener;
    private class_1937 lastWorld;
    private class_746 lastPlayer;
    private boolean visible = true;
    private int delayedHelo = 0;

    private static class_304 key(String name, class_3675.class_307 type, int code) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.worldeditcui." + name, type, code, KEYBIND_CATEGORY_WECUI));
    }

    public void onInitialize() {
        if (Boolean.getBoolean("wecui.debug.mixinaudit")) {
            MixinEnvironment.getCurrentEnvironment().audit();
        }
        instance = this;
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ClientLifecycleEvents.CLIENT_STARTED.register(this::onGameInitDone);
        CUINetworking.subscribeToCuiPacket(this::onPluginMessage);
        ClientPlayConnectionEvents.JOIN.register(this::onJoinGame);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(ctx -> {
            if (ctx.advancedTranslucency()) {
                try {
                    RenderSystem.pushMatrix();
                    RenderSystem.multMatrix((class_1159)ctx.matrixStack().method_23760().method_23761());
                    RenderPhaseAccess.getTranslucentTarget().method_23516();
                    this.onPostRenderEntities(ctx);
                }
                finally {
                    RenderPhaseAccess.getTranslucentTarget().method_23518();
                    RenderSystem.popMatrix();
                }
            }
        });
        WorldRenderEvents.LAST.register(ctx -> {
            if (!ctx.advancedTranslucency()) {
                OptifineHooks.doOptifineAwareRender(ctx, this::onPostRenderEntities);
            }
        });
    }

    private void onTick(class_310 mc) {
        boolean clock;
        CUIConfiguration config = this.controller.getConfiguration();
        boolean inGame = mc.field_1724 != null;
        boolean bl = clock = ((MinecraftClientAccess)mc).getRenderTickCounter().field_1970 > 0.0f;
        if (inGame && mc.field_1755 == null) {
            while (this.keyBindToggleUI.method_1436()) {
                this.visible = !this.visible;
            }
            while (this.keyBindClearSel.method_1436()) {
                if (mc.field_1724 != null) {
                    mc.field_1724.method_3142("//sel");
                }
                if (!config.isClearAllOnKey()) continue;
                this.controller.clearRegions();
            }
            while (this.keyBindChunkBorder.method_1436()) {
                this.controller.toggleChunkBorders();
            }
        }
        if (inGame && clock && this.controller != null) {
            if (mc.field_1687 != this.lastWorld || mc.field_1724 != this.lastPlayer) {
                this.lastWorld = mc.field_1687;
                this.lastPlayer = mc.field_1724;
                this.controller.getDebugger().debug("World change detected, sending new handshake");
                this.controller.clear();
                this.helo(mc.method_1562());
                this.delayedHelo = 10;
                if (mc.field_1724 != null && config.isPromiscuous()) {
                    mc.field_1724.method_3142("/we cui");
                }
            }
            if (this.delayedHelo > 0) {
                --this.delayedHelo;
                if (this.delayedHelo == 0) {
                    this.helo(mc.method_1562());
                }
            }
        }
    }

    private void onPluginMessage(class_310 client, class_634 handler, class_2540 data, PacketSender sender) {
        try {
            int readableBytes = data.readableBytes();
            if (readableBytes > 0) {
                String stringPayload = data.toString(0, data.readableBytes(), StandardCharsets.UTF_8);
                client.execute(() -> this.channelListener.onMessage(stringPayload));
            } else {
                this.getController().getDebugger().debug("Warning, invalid (zero length) payload received from server");
            }
        }
        catch (Exception ex) {
            this.getController().getDebugger().info("Error decoding payload from server", ex);
        }
    }

    public void onGameInitDone(class_310 client) {
        this.controller = new WorldEditCUI();
        this.controller.initialise(client);
        this.worldRenderListener = new CUIListenerWorldRender(this.controller, client);
        this.channelListener = new CUIListenerChannel(this.controller);
    }

    public void onJoinGame(class_634 handler, PacketSender sender, class_310 client) {
        this.visible = true;
        this.controller.getDebugger().debug("Joined game, sending initial handshake");
        this.helo(handler);
    }

    public void onPostRenderEntities(WorldRenderContext ctx) {
        if (this.visible) {
            this.worldRenderListener.onRender(ctx.matrixStack(), ctx.tickDelta());
        }
    }

    private void helo(class_634 handler) {
        String message = "v|4";
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)message, (Charset)StandardCharsets.UTF_8);
        CUINetworking.send(handler, new class_2540(buffer));
    }

    public WorldEditCUI getController() {
        return this.controller;
    }

    public static FabricModWorldEditCUI getInstance() {
        return instance;
    }
}

