/*
 * Decompiled with CFR 0.152.
 */
package eu.mikroskeem.worldeditcui;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OptifineHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle SHADERS_ACTIVE_PROGRAM;
    private static final MethodHandle PROGRAM_GET_NAME;
    private static final MethodHandle CONFIG_IS_SHADERS;
    private static final MethodHandle SHADERS_BEGIN_LEASH;
    private static final MethodHandle SHADERS_END_LEASH;
    private static final MethodHandle SHADERS_IS_SHADOW_PASS;
    private static boolean optifineDisabled;

    static String activeProgram() {
        if (SHADERS_ACTIVE_PROGRAM == null || PROGRAM_GET_NAME == null) {
            return "<optifine not detected>";
        }
        try {
            return PROGRAM_GET_NAME.invoke(SHADERS_ACTIVE_PROGRAM.invoke());
        }
        catch (Throwable ex) {
            LOGGER.debug("Failed to query OptiFine shader program", ex);
            return "<program query failed>";
        }
    }

    public static void doOptifineAwareRender(WorldRenderContext ctx, Consumer<WorldRenderContext> renderer) {
        if (SHADERS_END_LEASH == null || SHADERS_BEGIN_LEASH == null || CONFIG_IS_SHADERS == null || optifineDisabled) {
            renderer.accept(ctx);
            return;
        }
        try {
            boolean shadersEnabled = CONFIG_IS_SHADERS.invoke();
            if (!shadersEnabled) {
                renderer.accept(ctx);
            } else if (!SHADERS_IS_SHADOW_PASS.invoke()) {
                SHADERS_BEGIN_LEASH.invoke();
                renderer.accept(ctx);
                SHADERS_END_LEASH.invoke();
            }
        }
        catch (Throwable err) {
            optifineDisabled = true;
            LOGGER.error("Failed to render WECUI using OptiFine hooks", err);
        }
    }

    static {
        optifineDisabled = false;
        MethodHandle configIsShaders = null;
        MethodHandle shadersEndLeash = null;
        MethodHandle shadersBeginLeash = null;
        MethodHandle programGetName = null;
        MethodHandle shadersActiveProgram = null;
        MethodHandle shadersIsShadowPass = null;
        try {
            Class<?> config = Class.forName("net.optifine.Config");
            Class<?> shaders = Class.forName("net.optifine.shaders.Shaders");
            Class<?> program = Class.forName("net.optifine.shaders.Program");
            configIsShaders = LOOKUP.findStatic(config, "isShaders", MethodType.methodType(Boolean.TYPE));
            shadersEndLeash = LOOKUP.findStatic(shaders, "endLeash", MethodType.methodType(Void.TYPE));
            shadersBeginLeash = LOOKUP.findStatic(shaders, "beginLeash", MethodType.methodType(Void.TYPE));
            programGetName = LOOKUP.findVirtual(program, "getName", MethodType.methodType(String.class));
            shadersActiveProgram = LOOKUP.findStaticGetter(shaders, "activeProgram", program);
            shadersIsShadowPass = LOOKUP.findStaticGetter(shaders, "isShadowPass", Boolean.TYPE);
            LOGGER.debug("Optifine integration successfully initialized");
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException ignore) {
            optifineDisabled = true;
        }
        CONFIG_IS_SHADERS = configIsShaders;
        SHADERS_END_LEASH = shadersEndLeash;
        SHADERS_BEGIN_LEASH = shadersBeginLeash;
        PROGRAM_GET_NAME = programGetName;
        SHADERS_ACTIVE_PROGRAM = shadersActiveProgram;
        SHADERS_IS_SHADOW_PASS = shadersIsShadowPass;
    }
}

