/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.google.common.collect.Maps;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementScreen;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementTabType;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementWidget;
import de.dafuqs.paginatedadvancements.client.PinnedAdvancementTabType;
import de.dafuqs.paginatedadvancements.mixin.AdvancementWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_453;
import net.minecraft.class_454;
import net.minecraft.class_456;
import net.minecraft.class_457;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import org.jetbrains.annotations.Nullable;

public class PaginatedAdvancementTab
extends class_454 {
    private final class_310 client;
    private final PaginatedAdvancementScreen screen;
    private final int index;
    private int pinnedIndex;
    private final class_8781 root;
    private final class_185 display;
    private final class_1799 icon;
    private final class_2561 title;
    private final class_456 rootWidget;
    private final Map<class_8779, class_456> widgets = Maps.newLinkedHashMap();
    private double originX;
    private double originY;
    private int minPanX = Integer.MAX_VALUE;
    private int minPanY = Integer.MAX_VALUE;
    private int maxPanX = Integer.MIN_VALUE;
    private int maxPanY = Integer.MIN_VALUE;
    private float alpha;
    private boolean initialized;
    @Nullable
    private class_456 hoveredWidget;

    public PaginatedAdvancementTab(class_310 client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, class_8781 root, class_185 display) {
        super(client, (class_457)screen, class_453.field_2678, index, root, display);
        this.client = client;
        this.screen = screen;
        this.index = index;
        this.pinnedIndex = pinnedIndex;
        this.root = root;
        this.display = display;
        this.icon = display.method_821();
        this.title = display.method_811();
        this.rootWidget = new PaginatedAdvancementWidget(this, client, root, display);
        this.addWidget(this.rootWidget, root.method_53649());
    }

    public class_453 method_35734() {
        return class_453.field_2678;
    }

    public int method_35735() {
        return this.index;
    }

    public class_8781 method_53813() {
        return this.root;
    }

    public class_2561 method_2309() {
        return this.title;
    }

    public class_185 method_35736() {
        return this.display;
    }

    public void drawBackground(class_332 context, int x, int y, boolean selected, int atIndex) {
        PaginatedAdvancementTabType.drawBackground(context, x, y, selected, atIndex);
    }

    public void drawIcon(class_332 context, int x, int y, int index) {
        PaginatedAdvancementTabType.drawIcon(context, x, y, index, this.icon);
    }

    public void drawPinnedBackground(class_332 context, int x, int y, boolean selected, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawBackground(context, x, y, selected, this.pinnedIndex);
        }
    }

    public void drawPinnedIcon(class_332 context, int x, int y, int maxPinnedIndex) {
        if (this.pinnedIndex <= maxPinnedIndex) {
            PinnedAdvancementTabType.drawIcon(context, x, y, this.pinnedIndex, this.icon);
        }
    }

    public void render(class_332 context, int startX, int startY, int endX, int endY) {
        int advancementTreeWindowWidth = endX - (startX += 9) + 32;
        int advancementTreeWindowHeight = endY - (startY += 18) + 61;
        if (!this.initialized) {
            this.originX = (double)(advancementTreeWindowWidth / 2 - (this.maxPanX + this.minPanX) / 2) - 22.0;
            this.originY = (double)(advancementTreeWindowHeight / 2 - (this.maxPanY + this.minPanY) / 2) - 32.0;
            this.initialized = true;
        }
        context.method_44379(startX, startY, advancementTreeWindowWidth, advancementTreeWindowHeight);
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)startX, (float)startY, 0.0f);
        class_2960 identifier = this.display.method_812().orElse(class_1060.field_5285);
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        int k = i % 16;
        int l = j % 16;
        int textureCountX = advancementTreeWindowWidth / 16 + 1;
        int textureCountY = advancementTreeWindowHeight / 16 + 2;
        for (int m = -1; m < textureCountX; ++m) {
            for (int n = -1; n < textureCountY; ++n) {
                context.method_25290(identifier, k + 16 * m, l + 16 * n, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        this.rootWidget.method_2323(context, i, j, true);
        this.rootWidget.method_2323(context, i, j, false);
        this.rootWidget.method_2325(context, i, j);
        context.method_51448().method_22909();
        context.method_44380();
    }

    public void drawWidgetTooltip(class_332 context, int mouseX, int mouseY, int startX, int startY, int endXWindow, int endY) {
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, -200.0f);
        if (PaginatedAdvancementsClient.CONFIG.FadeOutBackgroundOnAdvancementHover) {
            context.method_25294(0, 0, endXWindow - startX - 18, endY - startY - 26, class_3532.method_15375((float)(this.alpha * 255.0f)) << 24);
        }
        boolean hoversWidget = false;
        int i = class_3532.method_15357((double)this.originX);
        int j = class_3532.method_15357((double)this.originY);
        if (mouseX > 0 && mouseX < endXWindow - startX - 10 && mouseY > 0 && mouseY < endY - startY) {
            for (class_456 advancementWidget : this.widgets.values()) {
                if (!advancementWidget.method_2329(i, j, mouseX, mouseY)) continue;
                hoversWidget = true;
                advancementWidget.method_2331(context, i, j, this.alpha, startX, startY);
                this.hoveredWidget = advancementWidget;
                break;
            }
        }
        context.method_51448().method_22909();
        if (hoversWidget) {
            this.alpha = class_3532.method_15363((float)(this.alpha + 0.02f), (float)0.0f, (float)0.3f);
        } else {
            this.hoveredWidget = null;
            this.alpha = class_3532.method_15363((float)(this.alpha - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public void drawDebugInfo(class_332 context, int startX, int startY, int endX, int endY) {
        if (this.hoveredWidget != null) {
            int displayedRequirementLines;
            AdvancementWidgetAccessor advancementWidgetAccessor = (AdvancementWidgetAccessor)this.hoveredWidget;
            class_167 progress = advancementWidgetAccessor.getProgress();
            endY -= 60;
            startY -= 72;
            List<class_5250> requirements = this.getRequirements(startX -= 36, (endX -= 46) - 10, advancementWidgetAccessor.getAdvancement().method_53647(), progress);
            boolean overflow = false;
            if (!PaginatedAdvancementScreen.method_25442()) {
                overflow = requirements.size() > PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries;
                displayedRequirementLines = Math.min(requirements.size(), PaginatedAdvancementsClient.CONFIG.MaxCriterionEntries);
            } else {
                displayedRequirementLines = requirements.size();
            }
            startY = Math.max(startY, endY - Math.max(18, 8 + 10 * displayedRequirementLines) - (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip ? 10 : 0));
            this.drawDebugFrame(context, startX, startY, endX, endY);
            int requirementY = startY + 15;
            if (PaginatedAdvancementsClient.CONFIG.ShowAdvancementIDInDebugTooltip) {
                class_5250 idText = class_2561.method_43470((String)("ID: " + advancementWidgetAccessor.getAdvancement().method_53649().comp_1919().toString() + " ")).method_10852((class_2561)class_2561.method_43471((String)"text.paginated_advancements.copy_to_clipboard"));
                context.method_51439(this.client.field_1772, (class_2561)idText, startX + 5, startY + 5, 0xFFFFFF, true);
            } else {
                requirementY = startY + 5;
            }
            if (overflow) {
                this.drawRequirementsWithOverflow(context, startX + 5, requirementY, endX - 5, endY, requirements, displayedRequirementLines);
            } else {
                this.drawRequirements(context, startX + 5, requirementY, endX - 5, endY, requirements);
            }
        }
    }

    private List<class_5250> getRequirements(int startX, int endX, class_161 advancement, class_167 progress) {
        Iterable obtainedCriteria = progress == null ? List.of() : progress.method_734();
        List requirements = advancement.comp_1916().comp_1922();
        ArrayList<class_5250> requirementsDone = new ArrayList<class_5250>();
        ArrayList requirementsLeft = new ArrayList();
        for (List requirementGroup : requirements) {
            ArrayList<class_5250> lines = new ArrayList<class_5250>();
            lines.add(class_2561.method_43471((String)"text.paginated_advancements.group").method_27692(class_124.field_1079));
            boolean anyDone = false;
            for (String requirementString : requirementGroup) {
                int newWidth;
                class_124 formatting = class_124.field_1079;
                for (String s : obtainedCriteria) {
                    if (!s.equals(requirementString)) continue;
                    formatting = class_124.field_1077;
                    anyDone = true;
                    break;
                }
                if ((newWidth = this.client.field_1772.method_27525((class_5348)lines.get(lines.size() - 1)) + this.client.field_1772.method_1727(requirementString)) > endX - startX) {
                    Object indent = "";
                    while (this.client.field_1772.method_1727((String)indent) < this.client.field_1772.method_27525((class_5348)class_2561.method_43471((String)"text.paginated_advancements.group"))) {
                        indent = (String)indent + " ";
                    }
                    lines.add(class_2561.method_43470((String)indent).method_27692(class_124.field_1079));
                }
                ((class_5250)lines.get(lines.size() - 1)).method_10852((class_2561)class_2561.method_43470((String)(requirementString + " ")).method_27692(formatting));
            }
            if (anyDone) {
                for (class_5250 line : lines) {
                    line.method_27692(class_124.field_1077);
                    requirementsDone.add(line);
                }
                continue;
            }
            requirementsLeft.addAll(lines);
        }
        ArrayList<class_5250> combined = new ArrayList<class_5250>();
        combined.addAll(requirementsLeft);
        combined.addAll(requirementsDone);
        return combined;
    }

    protected void drawDebugFrame(class_332 context, int startX, int startY, int endX, int endY) {
        context.method_51448().method_22903();
        int TOP_ELEMENT_HEIGHT = 15;
        context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, startY, 0, 0, 15, TOP_ELEMENT_HEIGHT);
        context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, startY, 237, 0, 15, TOP_ELEMENT_HEIGHT);
        context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, endY - 15, 0, 125, 15, 15);
        context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, endY - 15, 237, 125, 15, 15);
        int maxTopHeightInOneDrawCall = 100;
        int middleHeight = endY - startY - TOP_ELEMENT_HEIGHT - 15;
        int currentY = startY + TOP_ELEMENT_HEIGHT;
        while (middleHeight > 0) {
            int currentDrawHeight = Math.min(middleHeight, maxTopHeightInOneDrawCall);
            context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, startX, currentY, 0, TOP_ELEMENT_HEIGHT, 15, currentDrawHeight);
            context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, endX - 15, currentY, 237, TOP_ELEMENT_HEIGHT, 15, currentDrawHeight);
            middleHeight -= currentDrawHeight;
            currentY += currentDrawHeight;
        }
        int maxTopWidthInOneDrawCall = 220;
        int middleWidth = endX - startX - 15 - 15;
        int currentX = startX + 15;
        while (middleWidth > 0) {
            int currentDrawWidth = Math.min(middleWidth, maxTopWidthInOneDrawCall);
            context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, startY, 15, 0, currentDrawWidth, TOP_ELEMENT_HEIGHT);
            context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, currentX, endY - 15, 15, 125, currentDrawWidth, 15);
            middleWidth -= currentDrawWidth;
            currentX += currentDrawWidth;
        }
        int centerStartX = startX + 6;
        int centerEndX = endX - 6;
        int centerStartY = startY + 3;
        int centerEndY = endY - 6;
        int drawStartY = centerStartY;
        int drawHeight = centerEndY - centerStartY;
        while (drawHeight > 0) {
            int drawStartX = centerStartX;
            int currentHeight = Math.min(drawHeight, 10);
            int drawWidth = centerEndX - centerStartX;
            while (drawWidth > 0) {
                int currentWidth = Math.min(200, drawWidth);
                context.method_25302(PaginatedAdvancementScreen.WINDOW_TEXTURE, drawStartX, drawStartY, 4, 4, currentWidth, currentHeight);
                drawWidth -= currentWidth;
                drawStartX += currentWidth;
            }
            drawHeight -= currentHeight;
            drawStartY += currentHeight;
        }
        context.method_51448().method_22909();
    }

    protected void drawRequirementsWithOverflow(class_332 context, int startX, int startY, int endX, int endY, List<class_5250> requirements, int lines) {
        for (int i = 0; i < lines; ++i) {
            if (i == lines - 1) {
                context.method_51439(this.client.field_1772, (class_2561)class_2561.method_43471((String)"text.paginated_advancements.expand_debug"), startX, startY, 0x999999, false);
            } else {
                context.method_51439(this.client.field_1772, (class_2561)requirements.get(i), startX, startY, 65280, false);
            }
            startY += 10;
        }
    }

    protected void drawRequirements(class_332 context, int startX, int startY, int endX, int endY, List<class_5250> requirements) {
        int scrollAmount = 0;
        assert (this.hoveredWidget != null);
        class_456 class_4562 = this.hoveredWidget;
        if (class_4562 instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)class_4562;
            scrollAmount = paginatedAdvancementWidget.getDebugScrollAmount();
            int maxLines = (endY - startY) / 10;
            scrollAmount = Math.max(0, Math.min(requirements.size() - maxLines, scrollAmount));
            paginatedAdvancementWidget.setDebugScrollAmount(scrollAmount);
        }
        if (scrollAmount > 0) {
            context.method_51439(this.client.field_1772, (class_2561)class_2561.method_43471((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
            ++scrollAmount;
            startY += 10;
        }
        for (int i = scrollAmount; i < requirements.size() && startY + 10 < endY; ++i) {
            if (startY + 20 >= endY && i + 1 != requirements.size()) {
                context.method_51439(this.client.field_1772, (class_2561)class_2561.method_43471((String)"text.paginated_advancements.scroll_debug"), startX, startY, 0x999999, false);
                break;
            }
            context.method_51439(this.client.field_1772, (class_2561)requirements.get(i), startX, startY, 65280, false);
            startY += 10;
        }
    }

    public boolean scrollDebug(int diff) {
        class_456 class_4562;
        if (this.hoveredWidget != null && (class_4562 = this.hoveredWidget) instanceof PaginatedAdvancementWidget) {
            PaginatedAdvancementWidget paginatedAdvancementWidget = (PaginatedAdvancementWidget)class_4562;
            int value = paginatedAdvancementWidget.getDebugScrollAmount();
            paginatedAdvancementWidget.setDebugScrollAmount(value + diff);
            return true;
        }
        return false;
    }

    public int getPaginatedDisplayedPage(int maxDisplayedTabs) {
        return this.index / maxDisplayedTabs;
    }

    public int getPaginatedDisplayedPosition(int maxDisplayedTabs, int currentPage) {
        return 1 + this.index - maxDisplayedTabs * currentPage;
    }

    public boolean isClickOnTab(int screenX, int screenY, double mouseX, double mouseY, boolean paginated, int maxDisplayedTabs, int currentPage) {
        if (paginated) {
            if (this.getPaginatedDisplayedPage(maxDisplayedTabs) != currentPage) {
                return false;
            }
            int pageIndex = this.getPaginatedDisplayedPosition(maxDisplayedTabs, currentPage);
            if (pageIndex <= maxDisplayedTabs) {
                return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, pageIndex, mouseX, mouseY);
            }
        } else {
            return PaginatedAdvancementTabType.isClickOnTab(screenX, screenY, this.index, mouseX, mouseY);
        }
        return false;
    }

    public boolean isClickOnPinnedTab(int screenX, int screenY, double mouseX, double mouseY, int maxPinnedTabs) {
        if (this.pinnedIndex > -1 && this.pinnedIndex <= maxPinnedTabs) {
            return PinnedAdvancementTabType.isClickOnTab(screenX, screenY, this.pinnedIndex, mouseX, mouseY);
        }
        return false;
    }

    @Nullable
    public static PaginatedAdvancementTab create(class_310 client, PaginatedAdvancementScreen screen, int index, int pinnedIndex, class_8781 root) {
        if (root.method_53647().comp_1913().isPresent()) {
            return new PaginatedAdvancementTab(client, screen, index, pinnedIndex, root, (class_185)root.method_53647().comp_1913().get());
        }
        return null;
    }

    public void move(double offsetX, double offsetY, int endX, int endY) {
        if (this.maxPanX - this.minPanX > endX) {
            this.originX = class_3532.method_15350((double)(this.originX + offsetX), (double)(-(this.maxPanX - endX)), (double)0.0);
        }
        if (this.maxPanY - this.minPanY > endY) {
            this.originY = class_3532.method_15350((double)(this.originY + offsetY), (double)(-(this.maxPanY - endY)), (double)0.0);
        }
    }

    public void method_2318(class_8781 advancement) {
        Optional optional = advancement.method_53647().comp_1913();
        if (optional.isPresent()) {
            PaginatedAdvancementWidget advancementWidget = new PaginatedAdvancementWidget(this, this.client, advancement, (class_185)optional.get());
            this.addWidget(advancementWidget, advancement.method_53649());
        }
    }

    private void addWidget(class_456 widget, class_8779 advancement) {
        this.widgets.put(advancement, widget);
        for (class_456 advancementWidget : this.widgets.values()) {
            advancementWidget.method_2332();
        }
        this.calculatePan();
    }

    public void calculatePan() {
        for (class_456 widget : this.widgets.values()) {
            int widgetStartX = widget.method_2327();
            int widgetEndX = widgetStartX + 28;
            int widgetStartY = widget.method_2326();
            int widgetEndY = widgetStartY + 27;
            this.minPanX = Math.min(this.minPanX, widgetStartX);
            this.maxPanX = Math.max(this.maxPanX, widgetEndX);
            this.minPanY = Math.min(this.minPanY, widgetStartY);
            this.maxPanY = Math.max(this.maxPanY, widgetEndY);
        }
    }

    @Nullable
    public class_456 method_2308(class_8779 advancement) {
        return this.widgets.get(advancement);
    }

    public PaginatedAdvancementScreen getScreen() {
        return this.screen;
    }

    public void setPinIndex(int index) {
        this.pinnedIndex = index;
    }

    public int getPinIndex() {
        return this.pinnedIndex;
    }

    public void copyHoveredAdvancementID() {
        if (this.hoveredWidget != null) {
            AdvancementWidgetAccessor awa = (AdvancementWidgetAccessor)this.hoveredWidget;
            class_310.method_1551().field_1774.method_1455(awa.getAdvancement().method_53649().comp_1919().toString());
            class_310.method_1551().field_1705.method_1758((class_2561)class_2561.method_43471((String)"text.paginated_advancements.copied_to_clipboard"), false);
        }
    }
}

