/*
 * Decompiled with CFR 0.152.
 */
package jerozgen.languagereload.mixin;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.access.ILanguageOptionsScreen;
import jerozgen.languagereload.config.Config;
import jerozgen.languagereload.gui.LanguageEntry;
import jerozgen.languagereload.gui.LanguageListWidget;
import net.minecraft.class_1076;
import net.minecraft.class_1077;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_426;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_7842;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_426.class})
public abstract class LanguageOptionsScreenMixin
extends class_4667
implements ILanguageOptionsScreen {
    @Unique
    private LanguageListWidget availableLanguageList;
    @Unique
    private LanguageListWidget selectedLanguageList;
    @Unique
    private class_342 searchBox;
    @Unique
    private final LinkedList<String> selectedLanguages = new LinkedList();
    @Unique
    private final Map<String, LanguageEntry> languageEntries = new LinkedHashMap<String, LanguageEntry>();

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    void onConstructed(class_437 parent, class_315 options, class_1076 languageManager, CallbackInfo ci) {
        String currentLangCode = languageManager.method_4669();
        if (!currentLangCode.equals("*")) {
            this.selectedLanguages.add(currentLangCode);
        }
        this.selectedLanguages.addAll(Config.getInstance().fallbacks);
        languageManager.method_4665().forEach((code, language) -> this.languageEntries.put((String)code, new LanguageEntry(this::refresh, (String)code, (class_1077)language, this.selectedLanguages)));
        this.field_49503.method_48995(48);
        this.field_49503.method_48991(53);
    }

    @Inject(method={"initBody"}, at={@At(value="HEAD")}, cancellable=true)
    void onInitBody(CallbackInfo ci) {
        int listWidth = Math.min(this.field_22789 / 2 - 4, 200);
        this.availableLanguageList = new LanguageListWidget(this.field_22787, this.it(), listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.available.title"));
        this.selectedLanguageList = new LanguageListWidget(this.field_22787, this.it(), listWidth, this.field_22790, (class_2561)class_2561.method_43471((String)"pack.selected.title"));
        this.availableLanguageList.method_46421(this.field_22789 / 2 - 4 - listWidth);
        this.selectedLanguageList.method_46421(this.field_22789 / 2 + 4);
        this.field_49503.method_48999((class_8021)this.availableLanguageList);
        this.field_49503.method_48999((class_8021)this.selectedLanguageList);
        this.refresh();
        ci.cancel();
    }

    protected void method_57732() {
        this.searchBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, 22, 200, 20, this.searchBox, (class_2561)class_2561.method_43473()){

            public void method_25365(boolean focused) {
                if (!this.method_25370() && focused) {
                    super.method_25365(true);
                    LanguageOptionsScreenMixin.this.focusSearch();
                } else {
                    super.method_25365(focused);
                }
            }
        };
        this.searchBox.method_1863(__ -> this.refresh());
        class_8667 header = (class_8667)this.field_49503.method_48992((class_8021)class_8667.method_52741().method_52735(5));
        header.method_52740().method_46467();
        header.method_52736((class_8021)new class_7842(this.field_22785, this.field_22793));
        header.method_52736((class_8021)this.searchBox);
    }

    @Inject(method={"initTabNavigation"}, at={@At(value="HEAD")}, cancellable=true)
    protected void onInitTabNavigation(CallbackInfo ci) {
        super.method_48640();
        int listWidth = Math.min(this.field_22789 / 2 - 4, 200);
        this.availableLanguageList.method_57712(listWidth, this.field_49503);
        this.selectedLanguageList.method_57712(listWidth, this.field_49503);
        this.availableLanguageList.method_46421(this.field_22789 / 2 - 4 - listWidth);
        this.selectedLanguageList.method_46421(this.field_22789 / 2 + 4);
        this.availableLanguageList.updateScroll();
        this.selectedLanguageList.updateScroll();
        ci.cancel();
    }

    @Inject(method={"onDone"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDone(CallbackInfo ci) {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.field_21335);
        String language = this.selectedLanguages.peekFirst();
        if (language == null) {
            LanguageReload.setLanguage("*", new LinkedList<String>());
        } else {
            LinkedList<String> fallbacks = new LinkedList<String>(this.selectedLanguages);
            fallbacks.removeFirst();
            LanguageReload.setLanguage(language, fallbacks);
        }
        ci.cancel();
    }

    @Unique
    private void refresh() {
        this.refreshList(this.selectedLanguageList, this.selectedLanguages.stream().map(this.languageEntries::get).filter(Objects::nonNull));
        this.refreshList(this.availableLanguageList, this.languageEntries.values().stream().filter(entry -> {
            if (this.selectedLanguageList.method_25396().contains(entry)) {
                return false;
            }
            String query = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
            String langCode = entry.getCode().toLowerCase(Locale.ROOT);
            String langName = entry.getLanguage().method_48303().getString().toLowerCase(Locale.ROOT);
            return langCode.contains(query) || langName.contains(query);
        }));
    }

    @Unique
    private void refreshList(LanguageListWidget list, Stream<? extends LanguageEntry> entries) {
        LanguageEntry selectedEntry = (LanguageEntry)list.method_25334();
        list.method_25313(null);
        list.method_25396().clear();
        entries.forEach(entry -> {
            list.method_25396().add(entry);
            entry.setParent(list);
            if (entry == selectedEntry) {
                list.method_25313((class_350.class_351)entry);
            }
        });
        list.updateScroll();
    }

    protected void method_56131() {
        this.focusSearch();
    }

    @Unique
    private void focusSearch() {
        this.method_48263(class_8016.method_48194((class_364)this.searchBox, (class_4069[])new class_4069[]{this}));
    }

    @Override
    public void languagereload_focusList(LanguageListWidget list) {
        this.method_48263(class_8016.method_48194((class_364)list, (class_4069[])new class_4069[]{this}));
    }

    @Override
    public void languagereload_focusEntry(LanguageEntry entry) {
        this.method_48263(class_8016.method_48194((class_364)entry, (class_4069[])new class_4069[]{entry.getParent(), this}));
    }

    @Unique
    class_426 it() {
        return (class_426)this;
    }

    LanguageOptionsScreenMixin(class_437 parent, class_315 options, class_2561 title) {
        super(parent, options, title);
    }
}

