/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.compatibility.checks;

import net.caffeinemc.mods.sodium.client.compatibility.checks.BugChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.OsUtils;
import net.caffeinemc.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterInfo;
import net.caffeinemc.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterProbe;
import net.caffeinemc.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterVendor;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaDriverVersion;
import net.caffeinemc.mods.sodium.client.platform.MessageBox;
import net.caffeinemc.mods.sodium.client.platform.windows.WindowsFileVersion;
import net.caffeinemc.mods.sodium.client.platform.windows.api.d3dkmt.D3DKMT;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreLaunchChecks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-EarlyDriverScanner");
    private static final String REQUIRED_LWJGL_VERSION = "3.3.3";
    private static final String normalMessage = "You must change the LWJGL version in your launcher to continue. This is usually controlled by the settings for a profile or instance in your launcher.";
    private static final String prismMessage = "It appears you are using Prism Launcher to start the game. You can likely fix this problem by opening your instance settings and navigating to the Version section in the sidebar.";

    public static void beforeLWJGLInit() {
        if (BugChecks.ISSUE_2561 && !Version.getVersion().startsWith(REQUIRED_LWJGL_VERSION)) {
            String message = normalMessage;
            if (System.getProperty("minecraft.launcher.brand", "unknown").equalsIgnoreCase("PrismLauncher")) {
                message = prismMessage;
            }
            PreLaunchChecks.showCriticalErrorAndClose("Sodium Renderer - Unsupported LWJGL", ("The game failed to start because the currently active LWJGL version is not compatible.\n\nInstalled version: ###CURRENT_VERSION###\nRequired version: ###REQUIRED_VERSION###\n\n" + message).replace("###CURRENT_VERSION###", Version.getVersion()).replace("###REQUIRED_VERSION###", REQUIRED_LWJGL_VERSION), "https://github.com/CaffeineMC/sodium-fabric/wiki/LWJGL-Compatibility");
        }
    }

    public static void onGameInit() {
        WindowsFileVersion installedVersion;
        if (BugChecks.ISSUE_899 && (installedVersion = PreLaunchChecks.findIntelDriverMatchingBug899()) != null) {
            PreLaunchChecks.showCriticalErrorAndClose("Sodium Renderer - Unsupported Driver", "The game failed to start because the currently installed Intel Graphics Driver is not compatible.\n\nInstalled version: ###CURRENT_DRIVER###\nRequired version: 10.18.10.5161 (or newer)\n\nYou must update your graphics card driver in order to continue.".replace("###CURRENT_DRIVER###", installedVersion.toString()), "https://github.com/CaffeineMC/sodium-fabric/wiki/Driver-Compatibility#windows-intel-gen7");
        }
        if (BugChecks.ISSUE_1486 && (installedVersion = PreLaunchChecks.findNvidiaDriverMatchingBug1486()) != null) {
            PreLaunchChecks.showCriticalErrorAndClose("Sodium Renderer - Unsupported Driver", "The game failed to start because the currently installed NVIDIA Graphics Driver is not compatible.\n\nInstalled version: ###CURRENT_DRIVER###\nRequired version: 536.23 (or newer)\n\nYou must update your graphics card driver in order to continue.".replace("###CURRENT_DRIVER###", NvidiaDriverVersion.parse(installedVersion).toString()), "https://github.com/CaffeineMC/sodium-fabric/wiki/Driver-Compatibility#nvidia-gpus");
        }
    }

    private static void showCriticalErrorAndClose(String title, String message, String url) {
        LOGGER.error("###ERROR_DESCRIPTION###\n\nFor more information, please see: ###HELP_URL###".replace("###ERROR_DESCRIPTION###", message).replace("###HELP_URL###", url == null ? "" : url));
        MessageBox.showMessageBox(null, MessageBox.IconType.ERROR, title, message, url);
        System.exit(1);
    }

    @Nullable
    private static WindowsFileVersion findIntelDriverMatchingBug899() {
        if (OsUtils.getOs() != OsUtils.OperatingSystem.WIN) {
            return null;
        }
        for (GraphicsAdapterInfo graphicsAdapterInfo : GraphicsAdapterProbe.getAdapters()) {
            D3DKMT.WDDMAdapterInfo wddmAdapterInfo;
            String driverName;
            if (!(graphicsAdapterInfo instanceof D3DKMT.WDDMAdapterInfo) || (driverName = (wddmAdapterInfo = (D3DKMT.WDDMAdapterInfo)graphicsAdapterInfo).getOpenGlIcdName()) == null) continue;
            WindowsFileVersion driverVersion = wddmAdapterInfo.openglIcdVersion();
            if (!driverName.matches("ig7icd(32|64)") || driverVersion.z() != 10 || driverVersion.w() >= 5161) continue;
            return driverVersion;
        }
        return null;
    }

    @Nullable
    private static WindowsFileVersion findNvidiaDriverMatchingBug1486() {
        if (OsUtils.getOs() != OsUtils.OperatingSystem.WIN) {
            return null;
        }
        for (GraphicsAdapterInfo graphicsAdapterInfo : GraphicsAdapterProbe.getAdapters()) {
            D3DKMT.WDDMAdapterInfo wddmAdapterInfo;
            WindowsFileVersion driverVersion;
            if (graphicsAdapterInfo.vendor() != GraphicsAdapterVendor.NVIDIA || !(graphicsAdapterInfo instanceof D3DKMT.WDDMAdapterInfo) || (driverVersion = (wddmAdapterInfo = (D3DKMT.WDDMAdapterInfo)graphicsAdapterInfo).openglIcdVersion()).z() != 15 || driverVersion.w() < 2647 || driverVersion.w() >= 3623) continue;
            return driverVersion;
        }
        return null;
    }
}

