/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.pipeline;

import java.util.Iterator;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.client.model.color.ColorProvider;
import net.caffeinemc.mods.sodium.client.model.color.ColorProviderRegistry;
import net.caffeinemc.mods.sodium.client.model.light.LightMode;
import net.caffeinemc.mods.sodium.client.model.light.LightPipelineProvider;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadOrientation;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.Material;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.builder.ChunkMeshBufferBuilder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractBlockRenderContext;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.caffeinemc.mods.sodium.client.services.PlatformModelAccess;
import net.caffeinemc.mods.sodium.client.services.SodiumModelData;
import net.caffeinemc.mods.sodium.client.world.LevelSlice;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.ShadeMode;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4696;
import net.minecraft.class_6575;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BlockRenderer
extends AbstractBlockRenderContext {
    private final ColorProviderRegistry colorProviderRegistry;
    private final int[] vertexColors = new int[4];
    private final ChunkVertexEncoder.Vertex[] vertices = ChunkVertexEncoder.Vertex.uninitializedQuad();
    private ChunkBuildBuffers buffers;
    private final Vector3f posOffset = new Vector3f();
    private final class_2338.class_2339 scratchPos = new class_2338.class_2339();
    @Nullable
    private ColorProvider<class_2680> colorProvider;
    private TranslucentGeometryCollector collector;

    public BlockRenderer(ColorProviderRegistry colorRegistry, LightPipelineProvider lighters) {
        this.colorProviderRegistry = colorRegistry;
        this.lighters = lighters;
        this.random = new class_6575(42L);
    }

    public void prepare(ChunkBuildBuffers buffers, LevelSlice level, TranslucentGeometryCollector collector) {
        this.buffers = buffers;
        this.level = level;
        this.collector = collector;
        this.slice = level;
    }

    public void release() {
        this.buffers = null;
        this.level = null;
        this.collector = null;
        this.slice = null;
    }

    public void renderModel(class_1087 model, class_2680 state, class_2338 pos, class_2338 origin) {
        this.state = state;
        this.pos = pos;
        this.randomSeed = state.method_26190(pos);
        this.posOffset.set((float)origin.method_10263(), (float)origin.method_10264(), (float)origin.method_10260());
        if (state.method_49228()) {
            class_243 modelOffset = state.method_26226((class_1922)this.level, pos);
            this.posOffset.add((float)modelOffset.field_1352, (float)modelOffset.field_1351, (float)modelOffset.field_1350);
        }
        this.colorProvider = this.colorProviderRegistry.getColorProvider(state.method_26204());
        this.type = class_4696.method_23679((class_2680)state);
        this.prepareCulling(true);
        this.prepareAoInfo(model.method_4708());
        this.modelData = PlatformModelAccess.getInstance().getModelData(this.slice, model, state, pos, this.slice.getPlatformModelData(pos));
        Iterable<class_1921> renderTypes = PlatformModelAccess.getInstance().getModelRenderTypes(this.level, model, state, pos, this.random, this.modelData);
        Iterator<class_1921> iterator = renderTypes.iterator();
        while (iterator.hasNext()) {
            class_1921 type;
            this.type = type = iterator.next();
            ((FabricBakedModel)model).emitBlockQuads(this.level, state, pos, this.randomSupplier, (RenderContext)this);
        }
        this.type = null;
        this.modelData = SodiumModelData.EMPTY;
    }

    @Override
    protected void processQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        ShadeMode shadeMode = mat.shadeMode();
        LightMode lightMode = aoMode == TriState.DEFAULT ? this.defaultLightMode : (this.useAmbientOcclusion && aoMode.get() ? LightMode.SMOOTH : LightMode.FLAT);
        boolean emissive = mat.emissive();
        BlendMode blendMode = mat.blendMode();
        Material material = blendMode == BlendMode.DEFAULT ? DefaultMaterials.forRenderLayer(this.type) : DefaultMaterials.forRenderLayer(blendMode.blockRenderLayer == null ? this.type : blendMode.blockRenderLayer);
        ChunkModelBuilder builder = this.buffers.get(material);
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, lightMode, emissive, shadeMode);
        this.bufferQuad(quad, this.quadLightData.br, material, builder);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        ColorProvider<class_2680> colorProvider;
        if (colorIndex != -1 && (colorProvider = this.colorProvider) != null) {
            int[] vertexColors = this.vertexColors;
            colorProvider.getColors(this.slice, this.pos, this.scratchPos, this.state, quad, vertexColors);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(vertexColors[i], quad.color(i)));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, float[] brightnesses, Material material, ChunkModelBuilder modelBuilder) {
        ModelQuadOrientation orientation = this.defaultLightMode == LightMode.FLAT ? ModelQuadOrientation.NORMAL : ModelQuadOrientation.orientByBrightness(brightnesses, quad);
        ChunkVertexEncoder.Vertex[] vertices = this.vertices;
        Vector3f offset = this.posOffset;
        for (int dstIndex = 0; dstIndex < 4; ++dstIndex) {
            int srcIndex = orientation.getVertexIndex(dstIndex);
            ChunkVertexEncoder.Vertex out = vertices[dstIndex];
            out.x = quad.x(srcIndex) + offset.x;
            out.y = quad.y(srcIndex) + offset.y;
            out.z = quad.z(srcIndex) + offset.z;
            out.color = ColorARGB.toABGR(quad.color(srcIndex));
            out.ao = brightnesses[srcIndex];
            out.u = quad.u(srcIndex);
            out.v = quad.v(srcIndex);
            out.light = quad.lightmap(srcIndex);
        }
        ModelQuadFacing normalFace = quad.normalFace();
        if (material.isTranslucent() && this.collector != null) {
            this.collector.appendQuad(quad.getFaceNormal(), vertices, normalFace);
        }
        ChunkMeshBufferBuilder vertexBuffer = modelBuilder.getVertexBuffer(normalFace);
        vertexBuffer.push(vertices, material);
        modelBuilder.addSprite(SpriteFinderCache.forBlockAtlas().find(quad.getTexU(0), quad.getTexV(0)));
    }
}

