/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_4588;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;

public class QuadEncoder {
    public static void writeQuadVertices(MutableQuadViewImpl quad, class_4588 vertexConsumer, int overlay, Matrix4f matPosition, boolean trustedNormals, Matrix3f matNormal) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer != null) {
            QuadEncoder.writeQuadVertices(quad, writer, overlay, matPosition, trustedNormals, matNormal);
        } else {
            QuadEncoder.writeQuadVerticesSlow(quad, vertexConsumer, overlay, matPosition, trustedNormals, matNormal);
        }
    }

    public static void writeQuadVertices(MutableQuadViewImpl quad, VertexBufferWriter writer, int overlay, Matrix4f matPosition, boolean trustedNormals, Matrix3f matNormal) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            boolean useNormals = quad.hasVertexNormals();
            int normal = 0;
            if (useNormals) {
                quad.populateMissingNormals();
            } else {
                normal = MatrixHelper.transformNormal(matNormal, trustedNormals, quad.packedFaceNormal());
            }
            for (int i = 0; i < 4; ++i) {
                float x = quad.x(i);
                float y = quad.y(i);
                float z = quad.z(i);
                float xt = MatrixHelper.transformPositionX(matPosition, x, y, z);
                float yt = MatrixHelper.transformPositionY(matPosition, x, y, z);
                float zt = MatrixHelper.transformPositionZ(matPosition, x, y, z);
                if (useNormals) {
                    normal = MatrixHelper.transformNormal(matNormal, trustedNormals, quad.packedNormal(i));
                }
                ModelVertex.write(ptr, xt, yt, zt, ColorARGB.toABGR(quad.color(i)), quad.u(i), quad.v(i), overlay, quad.lightmap(i), normal);
                ptr += 36L;
            }
            writer.push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    private static void writeQuadVerticesSlow(MutableQuadViewImpl quad, class_4588 vertexConsumer, int overlay, Matrix4f matPosition, boolean trustedNormals, Matrix3f matNormal) {
        boolean useNormals = quad.hasVertexNormals();
        float nxt = 0.0f;
        float nyt = 0.0f;
        float nzt = 0.0f;
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            Vector3f faceNormal = quad.faceNormal();
            float nx = faceNormal.x;
            float ny = faceNormal.y;
            float nz = faceNormal.z;
            nxt = MatrixHelper.transformNormalX(matNormal, nx, ny, nz);
            nyt = MatrixHelper.transformNormalY(matNormal, nx, ny, nz);
            nzt = MatrixHelper.transformNormalZ(matNormal, nx, ny, nz);
            if (!trustedNormals) {
                float scalar = Math.invsqrt((float)Math.fma((float)nxt, (float)nxt, (float)Math.fma((float)nyt, (float)nyt, (float)(nzt * nzt))));
                nxt *= scalar;
                nyt *= scalar;
                nzt *= scalar;
            }
        }
        for (int i = 0; i < 4; ++i) {
            float x = quad.x(i);
            float y = quad.y(i);
            float z = quad.z(i);
            float xt = MatrixHelper.transformPositionX(matPosition, x, y, z);
            float yt = MatrixHelper.transformPositionY(matPosition, x, y, z);
            float zt = MatrixHelper.transformPositionZ(matPosition, x, y, z);
            vertexConsumer.method_22912(xt, yt, zt);
            vertexConsumer.method_39415(quad.color(i));
            vertexConsumer.method_22913(quad.u(i), quad.v(i));
            vertexConsumer.method_22922(overlay);
            vertexConsumer.method_60803(quad.lightmap(i));
            if (useNormals) {
                int packedNormal = quad.packedNormal(i);
                float nx = NormI8.unpackX(packedNormal);
                float ny = NormI8.unpackY(packedNormal);
                float nz = NormI8.unpackZ(packedNormal);
                nxt = MatrixHelper.transformNormalX(matNormal, nx, ny, nz);
                nyt = MatrixHelper.transformNormalY(matNormal, nx, ny, nz);
                nzt = MatrixHelper.transformNormalZ(matNormal, nx, ny, nz);
                if (!trustedNormals) {
                    float scalar = Math.invsqrt((float)Math.fma((float)nxt, (float)nxt, (float)Math.fma((float)nyt, (float)nyt, (float)(nzt * nzt))));
                    nxt *= scalar;
                    nyt *= scalar;
                    nzt *= scalar;
                }
            }
            vertexConsumer.method_22914(nxt, nyt, nzt);
        }
    }
}

