/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.texture;

import java.util.Map;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;

public class BlockSpriteFinder {
    private final Node root = new Node(0.5f, 0.5f, 0.25f);
    private final class_1059 spriteAtlasTexture;
    private int badSpriteCount = 0;

    public BlockSpriteFinder(Map<class_2960, class_1058> sprites, class_1059 spriteAtlasTexture) {
        this.spriteAtlasTexture = spriteAtlasTexture;
        sprites.values().forEach(this.root::add);
    }

    public class_1058 find(float u, float v) {
        return this.root.find(u, v);
    }

    private class Node {
        static final float EPS = 1.0E-5f;
        final float midU;
        final float midV;
        final float cellRadius;
        Object lowLow = null;
        Object lowHigh = null;
        Object highLow = null;
        Object highHigh = null;

        Node(float midU, float midV, float radius) {
            this.midU = midU;
            this.midV = midV;
            this.cellRadius = radius;
        }

        void add(class_1058 sprite) {
            boolean highV;
            if (sprite.method_4594() < -1.0E-5f || sprite.method_4577() > 1.00001f || sprite.method_4593() < -1.0E-5f || sprite.method_4575() > 1.00001f) {
                if (BlockSpriteFinder.this.badSpriteCount++ < 5) {
                    String errorMessage = "SpriteFinderImpl: Skipping sprite {} with broken bounds [{}, {}]x[{}, {}]. Sprite bounds should be between 0 and 1.";
                    SodiumClientMod.logger().error(errorMessage, new Object[]{sprite.method_45851().method_45816(), Float.valueOf(sprite.method_4594()), Float.valueOf(sprite.method_4577()), Float.valueOf(sprite.method_4593()), Float.valueOf(sprite.method_4575())});
                }
                return;
            }
            boolean lowU = sprite.method_4594() < this.midU - 1.0E-5f;
            boolean highU = sprite.method_4577() > this.midU + 1.0E-5f;
            boolean lowV = sprite.method_4593() < this.midV - 1.0E-5f;
            boolean bl = highV = sprite.method_4575() > this.midV + 1.0E-5f;
            if (lowU && lowV) {
                this.addInner(sprite, this.lowLow, -1, -1, q -> {
                    this.lowLow = q;
                });
            }
            if (lowU && highV) {
                this.addInner(sprite, this.lowHigh, -1, 1, q -> {
                    this.lowHigh = q;
                });
            }
            if (highU && lowV) {
                this.addInner(sprite, this.highLow, 1, -1, q -> {
                    this.highLow = q;
                });
            }
            if (highU && highV) {
                this.addInner(sprite, this.highHigh, 1, 1, q -> {
                    this.highHigh = q;
                });
            }
        }

        private void addInner(class_1058 sprite, Object quadrant, int uStep, int vStep, Consumer<Object> setter) {
            if (quadrant == null) {
                setter.accept(sprite);
            } else if (quadrant instanceof Node) {
                ((Node)quadrant).add(sprite);
            } else {
                Node n = new Node(this.midU + this.cellRadius * (float)uStep, this.midV + this.cellRadius * (float)vStep, this.cellRadius * 0.5f);
                if (quadrant instanceof class_1058) {
                    n.add((class_1058)quadrant);
                }
                n.add(sprite);
                setter.accept(n);
            }
        }

        private class_1058 find(float u, float v) {
            if (u < this.midU) {
                return v < this.midV ? this.findInner(this.lowLow, u, v) : this.findInner(this.lowHigh, u, v);
            }
            return v < this.midV ? this.findInner(this.highLow, u, v) : this.findInner(this.highHigh, u, v);
        }

        private class_1058 findInner(Object quadrant, float u, float v) {
            if (quadrant instanceof class_1058) {
                return (class_1058)quadrant;
            }
            if (quadrant instanceof Node) {
                return ((Node)quadrant).find(u, v);
            }
            return BlockSpriteFinder.this.spriteAtlasTexture.method_4608(class_1047.method_4539());
        }
    }
}

