/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.vertex;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.minecraft.class_293;
import net.minecraft.class_296;

public class VertexFormatDescriptionImpl
implements VertexFormatDescription {
    private final int id;
    private final int stride;
    private final int[] offsets;
    private final boolean isSimple;

    public VertexFormatDescriptionImpl(class_293 format, int id) {
        this.id = id;
        this.stride = format.method_1362();
        this.offsets = VertexFormatDescriptionImpl.getOffsets(format);
        this.isSimple = VertexFormatDescriptionImpl.checkSimple(format);
    }

    private static boolean checkSimple(class_293 format) {
        EnumSet<CommonVertexAttribute> attributeSet = EnumSet.noneOf(CommonVertexAttribute.class);
        List elementList = format.method_1357();
        for (int elementIndex = 0; elementIndex < elementList.size(); ++elementIndex) {
            class_296 element = (class_296)elementList.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType != null && attributeSet.add(commonType)) continue;
            return false;
        }
        return true;
    }

    public static int[] getOffsets(class_293 format) {
        int[] commonElementOffsets = new int[CommonVertexAttribute.COUNT];
        Arrays.fill(commonElementOffsets, -1);
        List elementList = format.method_1357();
        int[] elementOffsets = format.method_60838();
        for (int elementIndex = 0; elementIndex < elementList.size(); ++elementIndex) {
            class_296 element = (class_296)elementList.get(elementIndex);
            CommonVertexAttribute commonType = CommonVertexAttribute.getCommonType(element);
            if (commonType == null) continue;
            commonElementOffsets[commonType.ordinal()] = elementOffsets[element.comp_2842()];
        }
        return commonElementOffsets;
    }

    @Override
    public boolean containsElement(CommonVertexAttribute element) {
        return this.offsets[element.ordinal()] != -1;
    }

    @Override
    public int getElementOffset(CommonVertexAttribute element) {
        int offset = this.offsets[element.ordinal()];
        if (offset == -1) {
            throw new NoSuchElementException("Vertex format does not contain element: " + String.valueOf((Object)element));
        }
        return offset;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int stride() {
        return this.stride;
    }

    @Override
    public boolean isSimpleFormat() {
        return this.isSimple;
    }
}

