/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.entity.shadows;

import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2874;
import net.minecraft.class_4538;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_765;
import net.minecraft.class_898;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_898.class})
public class EntityRenderDispatcherMixin {
    @Unique
    private static final int SHADOW_COLOR = ColorABGR.pack(1.0f, 1.0f, 1.0f);

    @Inject(method={"renderBlockShadow"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderShadowPartFast(class_4587.class_4665 matrices, class_4588 vertices, class_2791 chunk, class_4538 level, class_2338 pos, double x, double y, double z, float radius, float opacity, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertices);
        if (writer == null) {
            return;
        }
        ci.cancel();
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_26217() == class_2464.field_11455 || !blockState.method_26234((class_1922)level, blockPos)) {
            return;
        }
        int light = level.method_22339(pos);
        if (light <= 3) {
            return;
        }
        class_265 voxelShape = blockState.method_26218((class_1922)level, blockPos);
        if (voxelShape.method_1110()) {
            return;
        }
        float brightness = class_765.method_23284((class_2874)level.method_8597(), (int)light);
        float alpha = (float)(((double)opacity - (y - (double)pos.method_10264()) / 2.0) * 0.5 * (double)brightness);
        if (alpha >= 0.0f) {
            if (alpha > 1.0f) {
                alpha = 1.0f;
            }
            class_238 box = voxelShape.method_1107();
            float minX = (float)((double)pos.method_10263() + box.field_1323 - x);
            float maxX = (float)((double)pos.method_10263() + box.field_1320 - x);
            float minY = (float)((double)pos.method_10264() + box.field_1322 - y);
            float minZ = (float)((double)pos.method_10260() + box.field_1321 - z);
            float maxZ = (float)((double)pos.method_10260() + box.field_1324 - z);
            EntityRenderDispatcherMixin.renderShadowPart(matrices, writer, radius, alpha, minX, maxX, minY, minZ, maxZ);
        }
    }

    @Unique
    private static void renderShadowPart(class_4587.class_4665 matrices, VertexBufferWriter writer, float radius, float alpha, float minX, float maxX, float minY, float minZ, float maxZ) {
        float size = 0.5f * (1.0f / radius);
        float u1 = -minX * size + 0.5f;
        float u2 = -maxX * size + 0.5f;
        float v1 = -minZ * size + 0.5f;
        float v2 = -maxZ * size + 0.5f;
        Matrix3f matNormal = matrices.method_23762();
        Matrix4f matPosition = matrices.method_23761();
        int color = ColorABGR.withAlpha(SHADOW_COLOR, alpha);
        int normal = MatrixHelper.transformNormal(matNormal, matrices.field_48930, class_2350.field_11036);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(144);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr, matPosition, minX, minY, minZ, u1, v1, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, minX, minY, maxZ, u1, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, maxZ, u2, v2, color, normal);
            EntityRenderDispatcherMixin.writeShadowVertex(ptr += 36L, matPosition, maxX, minY, minZ, u2, v1, color, normal);
            ptr += 36L;
            writer.push(stack, buffer, 4, ModelVertex.FORMAT);
        }
    }

    @Unique
    private static void writeShadowVertex(long ptr, Matrix4f matPosition, float x, float y, float z, float u, float v, int color, int normal) {
        float xt = MatrixHelper.transformPositionX(matPosition, x, y, z);
        float yt = MatrixHelper.transformPositionY(matPosition, x, y, z);
        float zt = MatrixHelper.transformPositionZ(matPosition, x, y, z);
        ModelVertex.write(ptr, xt, yt, zt, color, u, v, 0xF000F0, class_4608.field_21444, normal);
    }
}

