/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.workarounds.context_creation;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.client.compatibility.checks.ModuleScanner;
import net.caffeinemc.mods.sodium.client.compatibility.checks.PostLaunchChecks;
import net.caffeinemc.mods.sodium.client.compatibility.environment.GLContextInfo;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.Workarounds;
import net.caffeinemc.mods.sodium.client.compatibility.workarounds.nvidia.NvidiaWorkarounds;
import net.caffeinemc.mods.sodium.client.services.PlatformRuntimeInformation;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_323;
import net.minecraft.class_3678;
import net.minecraft.class_543;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.WGL;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1041.class})
public class WindowMixin {
    @Shadow
    @Final
    private static Logger field_5178;
    @Unique
    private long wglPrevContext = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwCreateWindow(IILjava/lang/CharSequence;JJ)J"), expect=0, require=0)
    private long wrapGlfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        boolean applyNvidiaWorkarounds = Workarounds.isWorkaroundEnabled(Workarounds.Reference.NVIDIA_THREADED_OPTIMIZATIONS);
        if (applyNvidiaWorkarounds) {
            NvidiaWorkarounds.install();
        }
        try {
            long l = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)monitor, (long)share);
            return l;
        }
        finally {
            if (applyNvidiaWorkarounds) {
                NvidiaWorkarounds.uninstall();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/neoforged/fml/loading/ImmediateWindowHandler;setupMinecraftWindow(Ljava/util/function/IntSupplier;Ljava/util/function/IntSupplier;Ljava/util/function/Supplier;Ljava/util/function/LongSupplier;)J")}, expect=0, require=0)
    private long wrapGlfwCreateWindowForge(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor, Operation<Long> op) {
        boolean applyNvidiaWorkarounds = Workarounds.isWorkaroundEnabled(Workarounds.Reference.NVIDIA_THREADED_OPTIMIZATIONS);
        if (applyNvidiaWorkarounds && !PlatformRuntimeInformation.getInstance().platformHasEarlyLoadingScreen()) {
            NvidiaWorkarounds.install();
        }
        try {
            long l = (Long)op.call(new Object[]{width, height, title, monitor});
            return l;
        }
        finally {
            if (applyNvidiaWorkarounds) {
                NvidiaWorkarounds.uninstall();
            }
        }
    }

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL;createCapabilities()Lorg/lwjgl/opengl/GLCapabilities;", shift=At.Shift.AFTER)})
    private void postContextReady(class_3678 eventHandler, class_323 monitorTracker, class_543 settings, String videoMode, String title, CallbackInfo ci) {
        GLContextInfo driver = GLContextInfo.create();
        if (driver == null) {
            field_5178.warn("Could not retrieve identifying strings for OpenGL implementation");
        } else {
            field_5178.info("OpenGL Vendor: {}", (Object)driver.vendor());
            field_5178.info("OpenGL Renderer: {}", (Object)driver.renderer());
            field_5178.info("OpenGL Version: {}", (Object)driver.version());
        }
        this.wglPrevContext = class_156.method_668() == class_156.class_158.field_1133 ? WGL.wglGetCurrentContext() : 0L;
        PostLaunchChecks.onContextInitialized();
        ModuleScanner.checkModules();
    }

    @Inject(method={"updateDisplay"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;flipFrame(J)V", shift=At.Shift.AFTER)})
    private void preSwapBuffers(CallbackInfo ci) {
        if (this.wglPrevContext == 0L) {
            return;
        }
        long context = WGL.wglGetCurrentContext();
        if (this.wglPrevContext == context) {
            return;
        }
        field_5178.warn("The OpenGL context appears to have been suddenly replaced! Something has likely just injected into the game process.");
        ModuleScanner.checkModules();
        this.wglPrevContext = context;
    }
}

