/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame.components;

import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_8030;

public class ScrollBarComponent
extends AbstractWidget {
    protected static final int SCROLL_OFFSET = 6;
    protected final Dim2i dim;
    private final Mode mode;
    private final int frameLength;
    private final int viewPortLength;
    private final int maxScrollBarOffset;
    private final Consumer<Integer> onSetOffset;
    private int offset = 0;
    private boolean isDragging;
    private Dim2i scrollThumb = null;
    private int scrollThumbClickOffset;
    private Dim2i extendedScrollArea = null;

    public ScrollBarComponent(Dim2i trackArea, Mode mode, int frameLength, int viewPortLength, Consumer<Integer> onSetOffset) {
        this.dim = trackArea;
        this.mode = mode;
        this.frameLength = frameLength;
        this.viewPortLength = viewPortLength;
        this.onSetOffset = onSetOffset;
        this.maxScrollBarOffset = this.frameLength - this.viewPortLength;
    }

    public ScrollBarComponent(Dim2i scrollBarArea, Mode mode, int frameLength, int viewPortLength, Consumer<Integer> onSetOffset, Dim2i extendedTrackArea) {
        this(scrollBarArea, mode, frameLength, viewPortLength, onSetOffset);
        this.extendedScrollArea = extendedTrackArea;
    }

    public void updateThumbPosition() {
        int scrollThumbLength = this.viewPortLength * (this.mode == Mode.VERTICAL ? this.dim.height() : this.dim.width() - 6) / this.frameLength;
        int maximumScrollThumbOffset = this.viewPortLength - scrollThumbLength;
        int scrollThumbOffset = this.offset * maximumScrollThumbOffset / this.maxScrollBarOffset;
        this.scrollThumb = new Dim2i(this.dim.x() + 2 + (this.mode == Mode.HORIZONTAL ? scrollThumbOffset : 0), this.dim.y() + 2 + (this.mode == Mode.VERTICAL ? scrollThumbOffset : 0), (this.mode == Mode.VERTICAL ? this.dim.width() : scrollThumbLength) - 4, (this.mode == Mode.VERTICAL ? scrollThumbLength : this.dim.height()) - 4);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        this.drawBorder(guiGraphics, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        this.drawRect(guiGraphics, this.scrollThumb.x(), this.scrollThumb.y(), this.scrollThumb.getLimitX(), this.scrollThumb.getLimitY(), -5592406);
        if (this.method_25370()) {
            this.drawBorder(guiGraphics, this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -1);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.dim.containsCursor(mouseX, mouseY)) {
            if (this.scrollThumb.containsCursor(mouseX, mouseY)) {
                this.scrollThumbClickOffset = this.mode == Mode.VERTICAL ? (int)(mouseY - (double)(this.scrollThumb.y() + this.scrollThumb.height() / 2)) : (int)(mouseX - (double)(this.scrollThumb.x() + this.scrollThumb.width() / 2));
                this.isDragging = true;
            } else {
                int value = this.mode == Mode.VERTICAL ? (int)((mouseY - (double)this.dim.y() - (double)(this.scrollThumb.height() / 2)) / (double)(this.dim.height() - this.scrollThumb.height()) * (double)this.maxScrollBarOffset) : (int)((mouseX - (double)this.dim.x() - (double)(this.scrollThumb.width() / 2)) / (double)(this.dim.width() - this.scrollThumb.width()) * (double)this.maxScrollBarOffset);
                this.setOffset(value);
                this.isDragging = false;
            }
            return true;
        }
        this.isDragging = false;
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging) {
            int value = this.mode == Mode.VERTICAL ? (int)((mouseY - (double)this.scrollThumbClickOffset - (double)this.dim.y() - (double)(this.scrollThumb.height() / 2)) / (double)(this.dim.height() - this.scrollThumb.height()) * (double)this.maxScrollBarOffset) : (int)((mouseX - (double)this.scrollThumbClickOffset - (double)this.dim.x() - (double)(this.scrollThumb.width() / 2)) / (double)(this.dim.width() - this.scrollThumb.width()) * (double)this.maxScrollBarOffset);
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if ((this.dim.containsCursor(mouseX, mouseY) || this.extendedScrollArea != null && this.extendedScrollArea.containsCursor(mouseX, mouseY)) && this.offset <= this.maxScrollBarOffset && this.offset >= 0) {
            int value = (int)((double)this.offset - verticalAmount * 6.0);
            this.setOffset(value);
            return true;
        }
        return false;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int value) {
        this.offset = class_3532.method_15340((int)value, (int)0, (int)this.maxScrollBarOffset);
        this.updateThumbPosition();
        this.onSetOffset.accept(this.offset);
    }

    public class_8030 method_48202() {
        return new class_8030(this.dim.x(), this.dim.y(), this.dim.width(), this.dim.height());
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (!this.method_25370()) {
            return false;
        }
        if (this.mode == Mode.VERTICAL) {
            if (keyCode == 265) {
                this.setOffset(this.getOffset() - 6);
                return true;
            }
            if (keyCode == 264) {
                this.setOffset(this.getOffset() + 6);
                return true;
            }
        } else {
            if (keyCode == 263) {
                this.setOffset(this.getOffset() - 6);
                return true;
            }
            if (keyCode == 262) {
                this.setOffset(this.getOffset() + 6);
                return true;
            }
        }
        return false;
    }

    public static enum Mode {
        HORIZONTAL,
        VERTICAL;

    }
}

