/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline.transform.parameter;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.irisshaders.iris.gl.blending.AlphaTest;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.helpers.Tri;
import net.irisshaders.iris.pipeline.transform.Patch;
import net.irisshaders.iris.pipeline.transform.parameter.Parameters;
import net.irisshaders.iris.shaderpack.texture.TextureStage;

public class SodiumParameters
extends Parameters {
    public final ChunkVertexType vertexType;
    public final AlphaTest alpha;

    public SodiumParameters(Patch patch, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap, AlphaTest alpha, ChunkVertexType vertexType) {
        super(patch, textureMap);
        this.vertexType = vertexType;
        this.alpha = alpha;
    }

    @Override
    public AlphaTest getAlphaTest() {
        return this.alpha;
    }

    @Override
    public TextureStage getTextureStage() {
        return TextureStage.GBUFFERS_AND_SHADOW;
    }

    public ChunkVertexType getVertexType() {
        return this.vertexType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.vertexType == null ? 0 : this.vertexType.hashCode());
        result = 31 * result + (this.alpha == null ? 0 : this.alpha.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SodiumParameters other = (SodiumParameters)obj;
        if (this.vertexType == null ? other.vertexType != null : !this.vertexType.equals((Object)other.vertexType)) {
            return false;
        }
        if (this.alpha == null) {
            return other.alpha == null;
        }
        return this.alpha.equals(other.alpha);
    }
}

