/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils;

import io.github.sjouwer.gammautils.GammaUtils;
import io.github.sjouwer.gammautils.config.ModConfig;
import io.github.sjouwer.gammautils.statuseffect.StatusEffectManager;
import io.github.sjouwer.gammautils.util.InfoProvider;
import io.github.sjouwer.gammautils.util.LightLevelUtil;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_746;

public class NightVisionManager {
    private static final ModConfig.NightVisionSettings config = GammaUtils.getConfig().nightVision;
    private static final class_310 client = class_310.method_1551();
    private static Timer transitionTimer = null;
    private static double dynamicNightVisionTarget = Double.NaN;

    private NightVisionManager() {
    }

    public static int getNightVisionPercentage() {
        return (int)Math.round(config.getStrength());
    }

    public static void toggleNightVision() {
        class_746 player = NightVisionManager.client.field_1724;
        if (player == null) {
            return;
        }
        if (config.isEnabled()) {
            NightVisionManager.setNightVision(0.0, true, true, true);
        } else {
            NightVisionManager.setNightVision(0.0, false, false, true);
            StatusEffectManager.enableNightVision(player);
            dynamicNightVisionTarget = Double.NaN;
            NightVisionManager.setNightVision(config.getToggledStrength(), true, false, true);
        }
    }

    public static void increaseNightVision(int value) {
        double newValue = config.getStrength();
        NightVisionManager.setNightVision(newValue += value == 0 ? (double)config.getStepStrength() : (double)value, false, false, true);
    }

    public static void decreaseNightVision(int value) {
        double newValue = config.getStrength();
        NightVisionManager.setNightVision(newValue -= value == 0 ? (double)config.getStepStrength() : (double)value, false, false, true);
    }

    public static void setDimensionPreference() {
        if (NightVisionManager.client.field_1687 == null || !config.isDimensionPreferenceEnabled()) {
            return;
        }
        class_5321 dimension = NightVisionManager.client.field_1687.method_27983();
        if (dimension.equals(class_1937.field_25179)) {
            NightVisionManager.setNightVision(config.getOverworldPreference(), false, false, false);
        } else if (dimension.equals(class_1937.field_25180)) {
            NightVisionManager.setNightVision(config.getNetherPreference(), false, false, false);
        } else if (dimension.equals(class_1937.field_25181)) {
            NightVisionManager.setNightVision(config.getEndPreference(), false, false, false);
        }
    }

    public static void setDynamicNightVision() {
        if (!config.isDynamicNightVisionEnabled()) {
            return;
        }
        double lightLevel = LightLevelUtil.getAverageLightLevel(config.getDynamicAveragingLightRange());
        double step = (double)(config.getMaxDynamicStrength() - config.getMinDynamicStrength()) / 15.0;
        double target = (double)config.getMinDynamicStrength() + step * (15.0 - lightLevel);
        if (dynamicNightVisionTarget != target) {
            dynamicNightVisionTarget = target;
            NightVisionManager.setNightVision(target, true, false, false, true);
        }
    }

    public static void setNightVision(double newValue, boolean smoothTransition, boolean disable, boolean showMessage) {
        NightVisionManager.setNightVision(newValue, smoothTransition, disable, showMessage, false);
    }

    public static void setNightVision(double newValue, boolean smoothTransition, boolean disable, boolean showMessage, boolean dynamic) {
        if (transitionTimer != null) {
            transitionTimer.cancel();
        }
        if (config.isLimiterEnabled() && config.getMaximumStrength() > config.getMinimumStrength()) {
            newValue = Math.clamp(newValue, (double)config.getMinimumStrength(), (double)config.getMaximumStrength());
        }
        if (smoothTransition && (config.isSmoothTransitionEnabled() || dynamic)) {
            double valueChangePerTick = config.getTransitionSpeed(dynamic) / 100.0;
            if (newValue < config.getStrength()) {
                valueChangePerTick *= -1.0;
            }
            NightVisionManager.startTransitionTimer(newValue, valueChangePerTick, disable, showMessage);
        } else {
            config.setStrength(newValue);
            if (disable) {
                StatusEffectManager.disableNightVision(NightVisionManager.client.field_1724);
            }
            if (showMessage) {
                InfoProvider.showNightVisionStatusHudMessage();
            }
        }
        if (config.isToggleUpdateEnabled() && newValue != 0.0 && newValue != (double)config.getToggledStrength()) {
            config.setToggledStrength((int)Math.round(newValue));
        }
    }

    private static void startTransitionTimer(final double newValue, final double valueChangePerTick, final boolean disable, final boolean showMessage) {
        transitionTimer = new Timer();
        transitionTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                double nextValue = config.getStrength() + valueChangePerTick;
                if (valueChangePerTick > 0.0 && nextValue >= newValue || valueChangePerTick < 0.0 && nextValue <= newValue) {
                    transitionTimer.cancel();
                    config.setStrength(newValue);
                    if (disable) {
                        StatusEffectManager.disableNightVision(NightVisionManager.client.field_1724);
                    }
                } else {
                    config.setStrength(nextValue);
                }
                if (showMessage) {
                    InfoProvider.showNightVisionStatusHudMessage();
                }
            }
        }, 0L, 10L);
    }
}

