/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.config.sodium;

import net.caffeinemc.mods.sodium.client.gui.options.Option;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import org.apache.commons.lang3.Validate;

public class FloatSliderControl
implements Control<Float> {
    private final Option<Float> option;
    private final float min;
    private final float max;
    private final float interval;
    private final String text;

    public FloatSliderControl(Option<Float> option, float min, float max, float interval, class_2561 text) {
        Validate.isTrue((max > min ? 1 : 0) != 0, (String)"The maximum value must be greater than the minimum value", (Object[])new Object[0]);
        Validate.isTrue((interval > 0.0f ? 1 : 0) != 0, (String)"The slider interval must be greater than zero", (Object[])new Object[0]);
        Validate.isTrue(((max - min) / interval % 1.0f == 0.0f ? 1 : 0) != 0, (String)"The maximum value must be divisable by the interval", (Object[])new Object[0]);
        Validate.notNull((Object)text, (String)"The slider mode must not be null", (Object[])new Object[0]);
        this.option = option;
        this.min = min;
        this.max = max;
        this.interval = interval;
        this.text = text.getString();
    }

    public ControlElement<Float> createElement(Dim2i dim) {
        return new Button(this.option, dim, this.min, this.max, this.interval, this.text);
    }

    public Option<Float> getOption() {
        return this.option;
    }

    public int getMaxWidth() {
        return 130;
    }

    private static class Button
    extends ControlElement<Float> {
        private static final int THUMB_WIDTH = 2;
        private static final int TRACK_HEIGHT = 1;
        private final class_768 sliderBounds;
        private final float min;
        private final float range;
        private final float interval;
        private final String text;
        private double thumbPosition;

        public Button(Option<Float> option, Dim2i dim, float min, float max, float interval, String text) {
            super(option, dim);
            this.min = min;
            this.range = max - min;
            this.interval = interval;
            this.thumbPosition = this.getThumbPositionForValue(((Float)option.getValue()).floatValue());
            this.text = text;
            this.sliderBounds = new class_768(dim.getLimitX() - 96, dim.getCenterY() - 5, 90, 10);
        }

        public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
            super.method_25394(drawContext, mouseX, mouseY, delta);
            if (this.option.isAvailable() && this.hovered) {
                this.renderSlider(drawContext);
            } else {
                this.renderStandaloneValue(drawContext);
            }
        }

        private void renderStandaloneValue(class_332 drawContext) {
            int sliderX = this.sliderBounds.method_3321();
            int sliderY = this.sliderBounds.method_3322();
            int sliderWidth = this.sliderBounds.method_3319();
            int sliderHeight = this.sliderBounds.method_3320();
            String label = this.text.formatted(this.option.getValue());
            int labelWidth = this.font.method_1727(label);
            this.drawString(drawContext, label, sliderX + sliderWidth - labelWidth, sliderY + sliderHeight / 2 - 4, -1);
        }

        private void renderSlider(class_332 drawContext) {
            int sliderX = this.sliderBounds.method_3321();
            int sliderY = this.sliderBounds.method_3322();
            int sliderWidth = this.sliderBounds.method_3319();
            int sliderHeight = this.sliderBounds.method_3320();
            this.thumbPosition = this.getThumbPositionForValue(((Float)this.option.getValue()).floatValue());
            double thumbOffset = class_3532.method_15350((double)((double)(this.getFloatValue() - this.min) / (double)this.range * (double)sliderWidth), (double)0.0, (double)sliderWidth);
            double thumbX = (double)sliderX + thumbOffset - 2.0;
            double trackY = (double)((float)sliderY + (float)sliderHeight / 2.0f) - 0.5;
            drawContext.method_25294((int)thumbX, sliderY, (int)thumbX + 4, sliderY + sliderHeight, -1);
            drawContext.method_25294(sliderX, (int)trackY, sliderX + sliderWidth, (int)trackY + 1, -1);
            String label = String.valueOf(this.getFloatValue());
            int labelWidth = this.font.method_1727(label);
            this.drawString(drawContext, label, sliderX - labelWidth - 6, sliderY + sliderHeight / 2 - 4, -1);
        }

        public float getFloatValue() {
            return this.min + this.interval * (float)((int)Math.round(this.getSnappedThumbPosition() / (double)this.interval));
        }

        public double getSnappedThumbPosition() {
            return this.thumbPosition / (1.0 / (double)this.range);
        }

        public double getThumbPositionForValue(float value) {
            return (double)(value - this.min) * (1.0 / (double)this.range);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.option.isAvailable() && button == 0 && this.sliderBounds.method_3318((int)mouseX, (int)mouseY)) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }

        private void setValueFromMouse(double d) {
            this.setValue((d - (double)this.sliderBounds.method_3321()) / (double)this.sliderBounds.method_3319());
        }

        private void setValue(double d) {
            this.thumbPosition = class_3532.method_15350((double)d, (double)0.0, (double)1.0);
            float value = this.getFloatValue();
            if (((Float)this.option.getValue()).floatValue() != value) {
                this.option.setValue((Object)Float.valueOf(value));
            }
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.option.isAvailable() && button == 0) {
                this.setValueFromMouse(mouseX);
                return true;
            }
            return false;
        }
    }
}

