/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.sodiumextra.mixin.optimizations.beacon_beam_rendering;

import me.flashyreese.mods.sodiumextra.compat.IrisCompat;
import me.flashyreese.mods.sodiumextra.mixin.optimizations.beacon_beam_rendering.LevelRendererAccessor;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2580;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_822;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_822.class}, priority=1500)
public abstract class MixinBeaconRenderer {
    @Inject(method={"renderBeaconBeam(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/resources/ResourceLocation;FFJIIIFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeRenderBeam(class_4587 poseStack, class_4597 multiBufferSource, class_2960 resourceLocation, float tickDelta, float heightScale, long worldTime, int yOffset, int maxY, int color, float innerRadius, float outerRadius, CallbackInfo ci) {
        ci.cancel();
        if (IrisCompat.isIrisPresent() && IrisCompat.isRenderingShadowPass()) {
            return;
        }
        int height = yOffset + maxY;
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.0, 0.5);
        float time = (float)Math.floorMod(worldTime, 40) + tickDelta;
        float negativeTime = maxY < 0 ? time : -time;
        float fractionalPart = class_3532.method_22450((float)(negativeTime * 0.2f - (float)class_3532.method_15375((float)(negativeTime * 0.1f))));
        poseStack.method_22903();
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(time * 2.25f - 45.0f));
        float innerX3 = -innerRadius;
        float innerZ4 = -innerRadius;
        float innerV2 = -1.0f + fractionalPart;
        float innerV1 = (float)maxY * heightScale * (0.5f / innerRadius) + innerV2;
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(1152);
            ptr = MixinBeaconRenderer.writeBeamLayerVertices(ptr, poseStack, ColorARGB.toABGR((int)color), yOffset, height, 0.0f, innerRadius, innerRadius, 0.0f, innerX3, 0.0f, 0.0f, innerZ4, innerV1, innerV2);
            VertexBufferWriter.of((class_4588)multiBufferSource.getBuffer(class_1921.method_23592((class_2960)resourceLocation, (boolean)false))).push(stack, buffer, 16, ModelVertex.FORMAT);
            poseStack.method_22909();
            float innerX1 = -outerRadius;
            float outerZ1 = -outerRadius;
            float innerZ2 = -outerRadius;
            innerX3 = -outerRadius;
            innerV2 = -1.0f + fractionalPart;
            innerV1 = (float)maxY * heightScale + innerV2;
            buffer = ptr;
            ptr = MixinBeaconRenderer.writeBeamLayerVertices(ptr, poseStack, ColorARGB.toABGR((int)color, (int)32), yOffset, height, innerX1, outerZ1, outerRadius, innerZ2, innerX3, outerRadius, outerRadius, outerRadius, innerV1, innerV2);
            VertexBufferWriter.of((class_4588)multiBufferSource.getBuffer(class_1921.method_23592((class_2960)resourceLocation, (boolean)true))).push(stack, buffer, 16, ModelVertex.FORMAT);
        }
        poseStack.method_22909();
    }

    @Unique
    private static long writeBeamLayerVertices(long ptr, class_4587 poseStack, int color, int yOffset, int height, float x1, float z1, float x2, float z2, float x3, float z3, float x4, float z4, float v1, float v2) {
        class_4587.class_4665 pose = poseStack.method_23760();
        Matrix4f positionMatrix = pose.method_23761();
        Matrix3f normalMatrix = pose.method_23762();
        int normal = MatrixHelper.transformNormal((Matrix3f)normalMatrix, (boolean)false, (float)0.0f, (float)1.0f, (float)0.0f);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, height, z1, color, 1.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, yOffset, z1, color, 1.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, yOffset, z2, color, 0.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, height, z2, color, 0.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, height, z4, color, 1.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, yOffset, z4, color, 1.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, yOffset, z3, color, 0.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, height, z3, color, 0.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, height, z2, color, 1.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x2, yOffset, z2, color, 1.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, yOffset, z4, color, 0.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x4, height, z4, color, 0.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, height, z3, color, 1.0f, v1, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x3, yOffset, z3, color, 1.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, yOffset, z1, color, 0.0f, v2, normal);
        ptr = MixinBeaconRenderer.transformAndWriteVertex(ptr, positionMatrix, x1, height, z1, color, 0.0f, v1, normal);
        return ptr;
    }

    @Unique
    private static long transformAndWriteVertex(long ptr, Matrix4f positionMatrix, float x, float y, float z, int color, float u, float v, int normal) {
        float transformedX = MatrixHelper.transformPositionX((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        float transformedY = MatrixHelper.transformPositionY((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        float transformedZ = MatrixHelper.transformPositionZ((Matrix4f)positionMatrix, (float)x, (float)y, (float)z);
        ModelVertex.write((long)ptr, (float)transformedX, (float)transformedY, (float)transformedZ, (int)color, (float)u, (float)v, (int)0xF000F0, (int)class_4608.field_21444, (int)normal);
        return ptr += 36L;
    }

    @Inject(method={"render(Lnet/minecraft/world/level/block/entity/BeaconBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(class_2580 beaconBlockEntity, float f, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, CallbackInfo ci) {
        class_238 box;
        class_4604 frustum = ((LevelRendererAccessor)class_310.method_1551().field_1769).getCullingFrustum();
        if (!frustum.method_23093(box = new class_238((double)beaconBlockEntity.method_11016().method_10263() - 1.0, (double)beaconBlockEntity.method_11016().method_10264() - 1.0, (double)beaconBlockEntity.method_11016().method_10260() - 1.0, (double)beaconBlockEntity.method_11016().method_10263() + 1.0, (double)beaconBlockEntity.method_11016().method_10264() + (beaconBlockEntity.method_10937().isEmpty() ? 1.0 : 1024.0), (double)beaconBlockEntity.method_11016().method_10260() + 1.0))) {
            ci.cancel();
        }
    }
}

