/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityBooleanLRU;

public class RandomPropertyRule {
    public final int RULE_NUMBER;
    public final String PROPERTY_FILE;
    private final Integer[] SUFFIX_NUMBERS;
    private final Integer[] WEIGHTS;
    private final int WEIGHT_TOTAL;
    private final RandomProperty[] PROPERTIES_TO_TEST;
    private final boolean RULE_ALWAYS_APPROVED;
    private final boolean UPDATES;
    static final RandomPropertyRule defaultReturn = new RandomPropertyRule(){

        @Override
        public int getVariantSuffixFromThisCase(int seed) {
            return 1;
        }

        @Override
        public boolean doesEntityMeetConditionsOfThisCase(ETFEntity etfEntity, boolean isUpdate, EntityBooleanLRU UUID_CaseHasUpdateablesCustom) {
            return true;
        }
    };

    private RandomPropertyRule() {
        this.RULE_NUMBER = 0;
        this.PROPERTY_FILE = "default setter";
        this.SUFFIX_NUMBERS = new Integer[]{1};
        this.PROPERTIES_TO_TEST = new RandomProperty[0];
        this.RULE_ALWAYS_APPROVED = true;
        this.UPDATES = false;
        this.WEIGHTS = null;
        this.WEIGHT_TOTAL = 0;
    }

    public boolean isAlwaysMet() {
        return this.RULE_ALWAYS_APPROVED;
    }

    public RandomPropertyRule(String propertiesFile, int ruleNumber, Integer[] suffixes, Integer[] weights, RandomProperty ... properties) {
        this.PROPERTY_FILE = propertiesFile;
        this.RULE_NUMBER = ruleNumber;
        this.PROPERTIES_TO_TEST = properties;
        this.RULE_ALWAYS_APPROVED = properties.length == 0;
        this.SUFFIX_NUMBERS = suffixes;
        if (weights == null || weights.length == 0) {
            this.WEIGHTS = null;
            this.WEIGHT_TOTAL = 0;
        } else {
            if (weights.length != suffixes.length) {
                Integer[] weightsFinal = new Integer[suffixes.length];
                int smaller = Math.min(weights.length, suffixes.length);
                System.arraycopy(weights, 0, weightsFinal, 0, smaller);
                if (weights.length >= suffixes.length) {
                    ETFUtils2.logWarn("Random Property file [" + this.PROPERTY_FILE + "] rule # [" + this.RULE_NUMBER + "] has more weights than suffixes, trimming to match");
                } else {
                    ETFUtils2.logWarn("Random Property file [" + this.PROPERTY_FILE + "] rule # [" + this.RULE_NUMBER + "] has more suffixes than weights, expanding to match");
                    int avgWeight = Arrays.stream(weights).mapToInt(Integer::intValue).sum() / weights.length;
                    for (int i = weights.length; i < weightsFinal.length; ++i) {
                        weightsFinal[i] = avgWeight;
                    }
                }
                weights = weightsFinal;
            }
            int total = 0;
            this.WEIGHTS = new Integer[weights.length];
            for (int i = 0; i < weights.length; ++i) {
                Integer weight = weights[i];
                if (weight < 0) {
                    total = 0;
                    break;
                }
                this.WEIGHTS[i] = total += weight.intValue();
            }
            this.WEIGHT_TOTAL = total;
        }
        this.UPDATES = Arrays.stream(properties).anyMatch(RandomProperty::canPropertyUpdate);
    }

    public Set<Integer> getSuffixSet() {
        return new HashSet<Integer>(List.of(this.SUFFIX_NUMBERS));
    }

    public boolean doesEntityMeetConditionsOfThisCase(ETFEntity etfEntity, boolean isUpdate, EntityBooleanLRU UUID_CaseHasUpdateablesCustom) {
        if (this.RULE_ALWAYS_APPROVED) {
            return true;
        }
        if (etfEntity == null) {
            return false;
        }
        if (this.UPDATES && UUID_CaseHasUpdateablesCustom != null) {
            UUID_CaseHasUpdateablesCustom.put(etfEntity.etf$getUuid(), true);
        }
        try {
            for (RandomProperty property : this.PROPERTIES_TO_TEST) {
                if (property.testEntity(etfEntity, isUpdate)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Random Property file [" + this.PROPERTY_FILE + "] rule # [" + this.RULE_NUMBER + "] failed with Exception:\n" + e.getMessage());
            return false;
        }
    }

    public int getVariantSuffixFromThisCase(int seed) {
        if (this.WEIGHT_TOTAL == 0) {
            return this.SUFFIX_NUMBERS[Math.abs(seed) % this.SUFFIX_NUMBERS.length];
        }
        int seedValue = Math.abs(seed) % this.WEIGHT_TOTAL;
        for (int i = 0; i < this.WEIGHTS.length; ++i) {
            if (seedValue >= this.WEIGHTS[i]) continue;
            return this.SUFFIX_NUMBERS[i];
        }
        return 0;
    }

    public void cacheEntityInitialResultsOfNonUpdatingProperties(ETFEntity entity) {
        for (RandomProperty property : this.PROPERTIES_TO_TEST) {
            if (property.canPropertyUpdate()) continue;
            try {
                property.cacheEntityInitialResult(entity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

